/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services.stats;

import java.util.Date;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.stats.IStatsRecorder;

public abstract class MessageStatsRecorder
implements IStatsRecorder {
    public void recordLogin(IPerson person) {
        String msg = this.getDisplayName(person) + " logged in successfully at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordLogout(IPerson person) {
        String msg = this.getDisplayName(person) + " logged out at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordSessionCreated(IPerson person) {
        String msg = "Session created for " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordSessionDestroyed(IPerson person) {
        String msg = "Session destroyed for " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelDefinitionPublished(IPerson person, ChannelDefinition channelDef) {
        String msg = "Channel '" + channelDef.getName() + "' " + "was published by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelDefinitionModified(IPerson person, ChannelDefinition channelDef) {
        String msg = "Channel '" + channelDef.getName() + "' " + "was modified by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelDefinitionRemoved(IPerson person, ChannelDefinition channelDef) {
        String msg = "Channel '" + channelDef.getName() + "' " + "was removed by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelAddedToLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was added to layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelUpdatedInLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was updated in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelMovedInLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was moved in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelRemovedFromLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was removed from layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordFolderAddedToLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        String msg = "Folder [" + folderDesc.getName() + ", " + folderDesc.getId() + "] " + "was added to layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordFolderUpdatedInLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        String msg = "Folder [" + folderDesc.getName() + ", " + folderDesc.getId() + "] " + "was updated in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordFolderMovedInLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        String msg = "Folder [" + folderDesc.getName() + ", " + folderDesc.getId() + "] " + "was moved in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordFolderRemovedFromLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        String msg = "Folder [" + folderDesc.getName() + ", " + folderDesc.getId() + "] " + "was removed from layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelInstantiated(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was instantiated in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelRendered(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was rendered in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    public void recordChannelTargeted(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        String msg = "Channel [" + channelDesc.getName() + ", " + channelDesc.getChannelPublishId() + ", " + channelDesc.getChannelSubscribeId() + "] " + "was targeted in layout " + profile.getLayoutId() + " " + "by " + this.getDisplayName(person) + " " + "at " + new Date();
        this.outputMessage(this.fixMsg(msg));
    }

    protected abstract void outputMessage(String var1);

    private String getDisplayName(IPerson person) {
        String name = null;
        if (person != null) {
            String userName = (String)person.getAttribute("username");
            if (person.isGuest()) {
                name = "GUEST_USER (" + this.fixNull(userName) + ")";
            } else {
                String firstName = (String)person.getAttribute("givenName");
                String lastName = (String)person.getAttribute("sn");
                name = this.fixNull(firstName) + " " + this.fixNull(lastName) + " (" + this.fixNull(userName) + ")";
            }
        } else {
            name = "NULL_PERSON";
        }
        return name;
    }

    private String fixNull(String s) {
        return s == null ? "" : s;
    }

    private String fixMsg(String msg) {
        return "STATS-RECORDER: " + msg;
    }
}

