/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class Text
extends StyleElement {
    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String fnAtt = this.getAttribute("href");
        if (fnAtt == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws TransformerException {
        Outputter out = context.getOutputter();
        String hrefAtt = this.getAttribute("href");
        Expression hrefExpr = this.makeAttributeValueTemplate(hrefAtt);
        String href = hrefExpr.evaluateAsString(context);
        String encodingAtt = this.getAttribute("encoding");
        Expression encodingExpr = this.makeAttributeValueTemplate(encodingAtt);
        String encoding = encodingExpr.evaluateAsString(context);
        URL fileURL = null;
        try {
            try {
                fileURL = new URL(href);
            }
            catch (MalformedURLException e1) {
                try {
                    fileURL = new URL("file:" + href);
                }
                catch (MalformedURLException e2) {
                    System.out.println("Cannot open " + href);
                    return;
                }
            }
            InputStreamReader isr = null;
            isr = encoding.equals("") ? new InputStreamReader(fileURL.openStream()) : new InputStreamReader(fileURL.openStream(), encoding);
            BufferedReader is = new BufferedReader(isr);
            int BUFFER_SIZE = 4096;
            char[] chars = new char[4096];
            char[] nchars = new char[4096];
            int len = 0;
            int i = 0;
            int carry = -1;
            while ((len = is.read(chars)) > 0) {
                int nlen = 0;
                for (i = 0; i < len; ++i) {
                    if (chars[i] == '\r') {
                        if (i < len - 1) {
                            if (chars[i + 1] == '\n') continue;
                            nchars[nlen] = 10;
                            ++nlen;
                            continue;
                        }
                        carry = is.read();
                        nchars[nlen] = 10;
                        ++nlen;
                        if (carry != 10) break;
                        carry = -1;
                        break;
                    }
                    nchars[nlen] = chars[i];
                    ++nlen;
                }
                out.writeContent(nchars, 0, nlen);
                if (carry != -1) {
                    out.writeContent(String.valueOf((char)carry));
                }
                carry = -1;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("Cannot read " + href);
        }
    }
}

