/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.LinkedList;
import java.util.TreeMap;
import org.jasig.portal.CountID;
import org.jasig.portal.ErrorID;
import org.jasig.portal.PortalException;

public class ProblemsTable {
    public static TreeMap registeredIds = new TreeMap();
    public static LinkedList recentIds = new LinkedList();
    private static final int maxRecent = 10;

    public static void register(ErrorID id) {
        if (id == null) {
            return;
        }
        String category = id.getCategory();
        String specific = id.getSpecific();
        TreeMap<String, CountID> minor = (TreeMap<String, CountID>)registeredIds.get(category);
        if (minor == null) {
            minor = new TreeMap<String, CountID>();
            registeredIds.put(category, minor);
        }
        if (!minor.containsKey(specific)) {
            minor.put(specific, new CountID(id));
        }
    }

    public static void store(PortalException pe) {
        if (pe == null) {
            return;
        }
        ErrorID id = pe.getErrorID();
        if (id == null) {
            return;
        }
        String category = id.getCategory();
        String specific = id.getSpecific();
        TreeMap minor = (TreeMap)registeredIds.get(category);
        if (minor == null) {
            return;
        }
        CountID countid = (CountID)minor.get(specific);
        if (countid == null) {
            return;
        }
        ++countid.count;
        countid.lastPortalException = pe;
        recentIds.remove(countid);
        recentIds.addFirst(countid);
        if (recentIds.size() > 10) {
            recentIds.removeLast();
        }
    }
}

