/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.local.searchers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.local.ITypedEntitySearcher;
import org.jasig.portal.services.LogService;

public class RDBMChannelDefSearcher
implements ITypedEntitySearcher {
    private static final String is_search = "select CHAN_ID from UP_CHANNEL where (CHAN_NAME=? or CHAN_TITLE=?)";
    private static final String partial_search = "select CHAN_ID from UP_CHANNEL where (CHAN_NAME like ? or CHAN_TITLE like ?)";
    private Class chanDef;

    public RDBMChannelDefSearcher() {
        try {
            this.chanDef = Class.forName("org.jasig.portal.ChannelDefinition");
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityIdentifier[] searchForEntities(String query, int method) throws GroupsException {
        EntityIdentifier[] r = new EntityIdentifier[]{};
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>();
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            switch (method) {
                case 1: {
                    ps = new RDBMServices.PreparedStatement(conn, is_search);
                    break;
                }
                case 2: {
                    query = query + "%";
                    ps = new RDBMServices.PreparedStatement(conn, partial_search);
                    break;
                }
                case 3: {
                    query = "%" + query;
                    ps = new RDBMServices.PreparedStatement(conn, partial_search);
                    break;
                }
                case 4: {
                    query = "%" + query + "%";
                    ps = new RDBMServices.PreparedStatement(conn, partial_search);
                    break;
                }
                default: {
                    throw new GroupsException("Unknown search type");
                }
            }
            ps.clearParameters();
            ps.setString(1, query);
            ps.setString(2, query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ar.add(new EntityIdentifier(rs.getString(1), this.chanDef));
            }
            ps.close();
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMChannelDefSearcher.searchForEntities(): " + ps);
            LogService.log(LogService.ERROR, e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return ar.toArray(r);
    }

    public Class getType() {
        return this.chanDef;
    }
}

