/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.UserLayoutChannelDescription;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TransientUserLayoutManagerWrapper
implements IUserLayoutManager {
    public static final String TRANSIENT_FOLDER_ID = "ft1";
    public static final String SUBSCRIBE_PREFIX = "ctf";
    IUserLayoutManager man = null;
    private Map mFnameMap = Collections.synchronizedMap(new HashMap());
    private Map mSubIdMap = Collections.synchronizedMap(new HashMap());
    private Map mChanMap = Collections.synchronizedMap(new HashMap());
    private String mFocusedId = "";
    private int mSubId = 0;

    public TransientUserLayoutManagerWrapper(IUserLayoutManager manager) throws PortalException {
        this.man = manager;
        if (this.man == null) {
            throw new PortalException("Cannot wrap a null IUserLayoutManager !");
        }
    }

    public IUserLayout getUserLayout() throws PortalException {
        return this.man.getUserLayout();
    }

    public void setUserLayout(IUserLayout userLayout) throws PortalException {
        this.man.setUserLayout(userLayout);
    }

    public void getUserLayout(ContentHandler ch) throws PortalException {
        this.man.getUserLayout(new TransientUserLayoutManagerSAXFilter(ch));
    }

    public void getUserLayout(String nodeId, ContentHandler ch) throws PortalException {
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        if (null != node) {
            IUserLayoutNodeDescription layoutNode = this.man.getNode(nodeId);
            if (layoutNode != null) {
                this.man.getUserLayout(nodeId, new TransientUserLayoutManagerSAXFilter(ch));
            } else {
                Document doc = DocumentFactory.getNewDocument();
                try {
                    Element e = node.getXML(doc);
                    doc.appendChild(e);
                    Transformer trans = TransformerFactory.newInstance().newTransformer();
                    trans.transform(new DOMSource(doc), new SAXResult(new TransientUserLayoutManagerSAXFilter(ch)));
                }
                catch (Exception e) {
                    throw new PortalException("Encountered an exception trying to output user layout", e);
                }
            }
        }
    }

    public void setLayoutStore(IUserLayoutStore ls) {
        this.man.setLayoutStore(ls);
    }

    public Document getUserLayoutDOM() throws PortalException {
        return this.man.getUserLayoutDOM();
    }

    public void loadUserLayout() throws PortalException {
        this.man.loadUserLayout();
    }

    public void saveUserLayout() throws PortalException {
        this.man.saveUserLayout();
    }

    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        IUserLayoutNodeDescription ulnd = null;
        try {
            ulnd = this.man.getNode(nodeId);
        }
        catch (PortalException pe) {
            LogService.log(LogService.DEBUG, "Node '" + nodeId + "' is not in layout, " + "checking for a transient node...");
        }
        if (null == ulnd) {
            ulnd = this.getTransientNode(nodeId);
        }
        return ulnd;
    }

    public IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.man.addNode(node, parentId, nextSiblingId);
    }

    public boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.moveNode(nodeId, parentId, nextSiblingId);
        }
        return false;
    }

    public boolean deleteNode(String nodeId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.deleteNode(nodeId);
        }
        return false;
    }

    public boolean updateNode(IUserLayoutNodeDescription node) throws PortalException {
        String nodeId = node.getId();
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.updateNode(node);
        }
        return false;
    }

    public boolean canAddNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.man.canAddNode(node, parentId, nextSiblingId);
    }

    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canMoveNode(nodeId, parentId, nextSiblingId);
        }
        return false;
    }

    public boolean canDeleteNode(String nodeId) throws PortalException {
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canDeleteNode(nodeId);
        }
        return false;
    }

    public boolean canUpdateNode(IUserLayoutNodeDescription node) throws PortalException {
        String nodeId = node.getId();
        if (nodeId != null && !this.mSubIdMap.containsKey(nodeId) && !nodeId.equals(TRANSIENT_FOLDER_ID)) {
            return this.man.canUpdateNode(node);
        }
        return false;
    }

    public void markAddTargets(IUserLayoutNodeDescription node) throws PortalException {
        this.man.markAddTargets(node);
    }

    public void markMoveTargets(String nodeId) throws PortalException {
        this.man.markMoveTargets(nodeId);
    }

    public String getParentId(String nodeId) throws PortalException {
        return this.man.getParentId(nodeId);
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        return this.man.getChildIds(nodeId);
    }

    public String getNextSiblingId(String nodeId) throws PortalException {
        return this.man.getNextSiblingId(nodeId);
    }

    public String getPreviousSiblingId(String nodeId) throws PortalException {
        return this.man.getPreviousSiblingId(nodeId);
    }

    public String getCacheKey() throws PortalException {
        return this.man.getCacheKey();
    }

    public int getLayoutId() {
        return this.man.getLayoutId();
    }

    public String getRootFolderId() {
        return this.man.getRootFolderId();
    }

    public IUserLayoutNodeDescription createNodeDescription(int nodeType) throws PortalException {
        return this.man.createNodeDescription(nodeType);
    }

    public boolean addLayoutEventListener(LayoutEventListener l) {
        return this.man.addLayoutEventListener(l);
    }

    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return this.man.removeLayoutEventListener(l);
    }

    protected ChannelDefinition getChannelDefinition(String subId) throws PortalException {
        ChannelDefinition chanDef = (ChannelDefinition)this.mChanMap.get(subId);
        if (null == chanDef) {
            String fname = this.getFname(subId);
            LogService.log(LogService.DEBUG, "TransientUserLayoutManagerWrapper>>getChannelDefinition, attempting to get a channel definition using functional name: " + fname);
            try {
                chanDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
            }
            catch (Exception e) {
                throw new PortalException("Failed to get channel information for subscribeId: " + subId);
            }
            this.mChanMap.put(subId, chanDef);
        }
        return chanDef;
    }

    public String getFname(String subId) {
        return (String)this.mSubIdMap.get(subId);
    }

    public String getSubscribeId(String fname) throws PortalException {
        String subId = (String)this.mFnameMap.get(fname);
        if (subId == null) {
            subId = this.man.getSubscribeId(fname);
        }
        if (subId == null) {
            try {
                ChannelDefinition chanDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
                if (chanDef != null) {
                    subId = this.getNextSubscribeId();
                    this.mFnameMap.put(fname, subId);
                    this.mSubIdMap.put(subId, fname);
                    this.mChanMap.put(subId, chanDef);
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "TransientUserLayoutManagerWrapper::getSubscribeId() : an exception encountered while trying to obtain ChannelDefinition for fname \"" + fname + "\" : " + e);
                subId = null;
            }
        }
        return subId;
    }

    public String getFocusedId() {
        return this.mFocusedId;
    }

    public void setFocusedId(String subscribeId) {
        this.mFocusedId = subscribeId;
    }

    private IUserLayoutChannelDescription getTransientNode(String nodeId) throws PortalException {
        String fname = this.getFname(nodeId);
        if (null == fname || fname.equals("")) {
            throw new PortalException("Could not find a transient node for id: " + nodeId);
        }
        UserLayoutChannelDescription ulnd = new UserLayoutChannelDescription();
        try {
            ChannelDefinition chanDef = (ChannelDefinition)this.mChanMap.get(nodeId);
            if (null == chanDef) {
                chanDef = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(fname);
                this.mChanMap.put(nodeId, chanDef);
            }
            ulnd.setId(nodeId);
            ulnd.setName(chanDef.getName());
            ulnd.setUnremovable(true);
            ulnd.setImmutable(true);
            ulnd.setHidden(false);
            ulnd.setTitle(chanDef.getTitle());
            ulnd.setDescription(chanDef.getDescription());
            ulnd.setClassName(chanDef.getJavaClass());
            ulnd.setChannelPublishId("" + chanDef.getId());
            ulnd.setChannelTypeId("" + chanDef.getTypeId());
            ulnd.setFunctionalName(chanDef.getFName());
            ulnd.setTimeout(chanDef.getTimeout());
            ulnd.setEditable(chanDef.isEditable());
            ulnd.setHasHelp(chanDef.hasHelp());
            ulnd.setHasAbout(chanDef.hasAbout());
            ChannelParameter[] parms = chanDef.getParameters();
            for (int i = 0; i < parms.length; ++i) {
                ChannelParameter parm = parms[i];
                ulnd.setParameterValue(parm.getName(), parm.getValue());
                ulnd.setParameterOverride(parm.getName(), parm.getOverride());
            }
        }
        catch (Exception e) {
            throw new PortalException("Failed to obtain channel definition using fname: " + fname);
        }
        return ulnd;
    }

    private synchronized String getNextSubscribeId() {
        ++this.mSubId;
        return SUBSCRIBE_PREFIX + this.mSubId;
    }

    class TransientUserLayoutManagerSAXFilter
    extends SAX2FilterImpl {
        private static final String LAYOUT = "layout";
        private static final String LAYOUT_FRAGMENT = "layout_fragment";
        private static final String FOLDER = "folder";
        private static final String CHANNEL = "channel";
        private static final String PARAMETER = "parameter";

        public TransientUserLayoutManagerSAXFilter(ContentHandler handler) {
            super(handler);
        }

        public TransientUserLayoutManagerSAXFilter(XMLReader parent) {
            super(parent);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String id = atts.getValue("ID");
            if (null != id && id.equals(TransientUserLayoutManagerWrapper.this.getRootFolderId())) {
                super.startElement(uri, localName, qName, atts);
                AttributesImpl folderAtts = new AttributesImpl();
                folderAtts.addAttribute("", "ID", "ID", "ID", TransientUserLayoutManagerWrapper.TRANSIENT_FOLDER_ID);
                folderAtts.addAttribute("", "type", "type", "CDATA", "regular");
                folderAtts.addAttribute("", "hidden", "hidden", "CDATA", "true");
                folderAtts.addAttribute("", "unremovable", "unremovable", "CDATA", "true");
                folderAtts.addAttribute("", "immutable", "immutable", "CDATA", "true");
                folderAtts.addAttribute("", "name", "name", "CDATA", "Transient Folder");
                this.startElement("", FOLDER, FOLDER, folderAtts);
                return;
            }
            if (qName.equals(FOLDER)) {
                id = atts.getValue("ID");
                if (null != id && id.equals(TransientUserLayoutManagerWrapper.TRANSIENT_FOLDER_ID)) {
                    super.startElement(uri, localName, qName, atts);
                    String subscribeId = "";
                    try {
                        subscribeId = TransientUserLayoutManagerWrapper.this.getFocusedId();
                        if (null != subscribeId && !subscribeId.equals("") && TransientUserLayoutManagerWrapper.this.mSubIdMap.containsKey(subscribeId)) {
                            ChannelDefinition chanDef = TransientUserLayoutManagerWrapper.this.getChannelDefinition(subscribeId);
                            AttributesImpl channelAttrs = new AttributesImpl();
                            channelAttrs.addAttribute("", "ID", "ID", "ID", subscribeId);
                            channelAttrs.addAttribute("", "typeID", "typeID", "CDATA", "" + chanDef.getTypeId());
                            channelAttrs.addAttribute("", "hidden", "hidden", "CDATA", "false");
                            channelAttrs.addAttribute("", "editable", "editable", "CDATA", CommonUtils.boolToStr(chanDef.isEditable()));
                            channelAttrs.addAttribute("", "unremovable", "unremovable", "CDATA", "true");
                            channelAttrs.addAttribute("", "name", "name", "CDATA", chanDef.getName());
                            channelAttrs.addAttribute("", "description", "description", "CDATA", chanDef.getDescription());
                            channelAttrs.addAttribute("", "title", "title", "CDATA", chanDef.getTitle());
                            channelAttrs.addAttribute("", "class", "class", "CDATA", chanDef.getJavaClass());
                            channelAttrs.addAttribute("", "chanID", "chanID", "CDATA", "" + chanDef.getId());
                            channelAttrs.addAttribute("", "fname", "fname", "CDATA", chanDef.getFName());
                            channelAttrs.addAttribute("", "timeout", "timeout", "CDATA", "" + chanDef.getTimeout());
                            channelAttrs.addAttribute("", "hasHelp", "hasHelp", "CDATA", CommonUtils.boolToStr(chanDef.hasHelp()));
                            channelAttrs.addAttribute("", "hasAbout", "hasAbout", "CDATA", CommonUtils.boolToStr(chanDef.hasAbout()));
                            this.startElement("", CHANNEL, CHANNEL, channelAttrs);
                            ChannelParameter[] chanParms = chanDef.getParameters();
                            for (int i = 0; i < chanParms.length; ++i) {
                                AttributesImpl parmAttrs = new AttributesImpl();
                                ChannelParameter parm = chanParms[i];
                                parmAttrs.addAttribute("", "name", "name", "CDATA", parm.getName());
                                parmAttrs.addAttribute("", "value", "value", "CDATA", parm.getValue());
                                this.startElement("", PARAMETER, PARAMETER, parmAttrs);
                                this.endElement("", PARAMETER, PARAMETER);
                            }
                            this.endElement("", CHANNEL, CHANNEL);
                        }
                    }
                    catch (Exception e) {
                        LogService.log(LogService.ERROR, "Could not obtain channel definition from database for subscribe id: " + subscribeId + " - error is: " + e.getMessage());
                    }
                    super.endElement(uri, localName, qName);
                    return;
                }
                AttributesImpl attsImpl = new AttributesImpl(atts);
                super.startElement(uri, localName, qName, attsImpl);
            } else {
                AttributesImpl attsImpl = new AttributesImpl(atts);
                super.startElement(uri, localName, qName, attsImpl);
            }
        }
    }
}

