/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import edu.yale.its.tp.cas.client.ServiceTicketValidator;
import edu.yale.its.tp.cas.proxy.ProxyTicketReceptor;
import java.io.IOException;
import java.util.Date;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.services.LogService;

public class YaleCasContext
extends ChainingSecurityContext {
    private static final int YALE_CAS_AUTHTYPE = 5889;
    private static String CasProxyCallbackUrl = null;
    private static String PortalServiceUrl = null;
    private static String CasValidateUrl = null;
    private String pgtIou = null;

    YaleCasContext() {
        CasProxyCallbackUrl = PropertiesManager.getProperty("org.jasig.portal.security.provider.YaleCasContext.CasProxyCallbackUrl");
        LogService.instance();
        LogService.log(LogService.DEBUG, "CasProxyCallbackUrl is " + CasProxyCallbackUrl);
        PortalServiceUrl = PropertiesManager.getProperty("org.jasig.portal.security.provider.YaleCasContext.PortalServiceUrl");
        LogService.instance();
        LogService.log(LogService.DEBUG, "PortalServiceUrl is " + PortalServiceUrl);
        CasValidateUrl = PropertiesManager.getProperty("org.jasig.portal.security.provider.YaleCasContext.CasValidateUrl");
        LogService.instance();
        LogService.log(LogService.DEBUG, "CasValidateUrl is " + CasValidateUrl);
    }

    public int getAuthType() {
        return 5889;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        String m_service_ticket = new String(this.myOpaqueCredentials.credentialstring);
        this.isauth = false;
        try {
            ServiceTicketValidator sv = new ServiceTicketValidator();
            sv.setCasValidateUrl(CasValidateUrl);
            sv.setProxyCallbackUrl(CasProxyCallbackUrl);
            sv.setService(PortalServiceUrl);
            sv.setServiceTicket(m_service_ticket);
            LogService.instance();
            LogService.log(LogService.DEBUG, new Date() + " YaleCasContext: Validating ServiceTicket: " + m_service_ticket);
            sv.validate();
            LogService.instance();
            LogService.log(LogService.DEBUG, new Date() + " YaleCasContext: got response:");
            LogService.instance();
            LogService.log(LogService.DEBUG, "YaleCasContext: " + sv.getResponse());
            if (sv.isAuthenticationSuccesful()) {
                this.myPrincipal.setUID(sv.getUser());
                this.pgtIou = sv.getPgtIou();
                this.isauth = true;
                LogService.instance();
                LogService.log(LogService.INFO, "CASContext authenticated " + this.myPrincipal.getUID());
            }
        }
        catch (Exception ex) {
            LogService.instance();
            LogService.log(LogService.ERROR, "YaleCASContext: " + ex);
            throw new PortalSecurityException("Error in CAS AUthentication");
        }
        super.authenticate();
    }

    public String getCasServiceToken(String target) throws IOException {
        return ProxyTicketReceptor.getProxyTicket(this.pgtIou, target);
    }
}

