/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.webservices.ser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.encoding.Target;
import org.apache.axis.message.SOAPHandler;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.UPFileSpec;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ChannelRuntimeDataDeserializer
extends DeserializerImpl {
    private Map channelRuntimeDataInfo = new HashMap(8);
    private static final Object REQUEST_PARAMS_HINT = new Object();
    private static final Object KEYWORDS_HINT = new Object();
    private static final Object RENDERING_AS_ROOT_HINT = new Object();
    private static final Object BROWSER_INFO_HINT = new Object();
    private static final Object LOCALES_HINT = new Object();
    private static final Object UP_FILE_SPEC_HINT = new Object();
    private static final Object BASE_ACTION_URL_HINT = new Object();
    private static final Object HTTP_REQUEST_METHOD_HINT = new Object();

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (!localName.equals("channel-runtime-data")) {
            throw new SAXException("Expecting <channel-runtime-data> element. Got <" + localName + "> instead.");
        }
        return new ChannelRuntimeDataHandler(this);
    }

    public void setValue(Object value, Object hint) throws SAXException {
        if (hint != null) {
            this.channelRuntimeDataInfo.put(hint, value);
        }
        if (this.channelRuntimeDataInfo.size() == 8) {
            Map params = (Map)this.channelRuntimeDataInfo.get(REQUEST_PARAMS_HINT);
            String keywords = (String)this.channelRuntimeDataInfo.get(KEYWORDS_HINT);
            boolean isRenderingAsRoot = (Boolean)this.channelRuntimeDataInfo.get(RENDERING_AS_ROOT_HINT);
            BrowserInfo browserInfo = (BrowserInfo)this.channelRuntimeDataInfo.get(BROWSER_INFO_HINT);
            Locale[] locales = (Locale[])this.channelRuntimeDataInfo.get(LOCALES_HINT);
            UPFileSpec upfs = (UPFileSpec)this.channelRuntimeDataInfo.get(UP_FILE_SPEC_HINT);
            String baseActionURL = (String)this.channelRuntimeDataInfo.get(BASE_ACTION_URL_HINT);
            String httpRequestMethod = (String)this.channelRuntimeDataInfo.get(HTTP_REQUEST_METHOD_HINT);
            ChannelRuntimeData runtimeData = new ChannelRuntimeData();
            runtimeData.setParametersSingleValued(params);
            runtimeData.setKeywords(keywords);
            runtimeData.setRenderingAsRoot(isRenderingAsRoot);
            runtimeData.setBrowserInfo(browserInfo);
            runtimeData.setLocales(locales);
            runtimeData.setUPFile(upfs);
            runtimeData.setBaseActionURL(baseActionURL);
            runtimeData.setHttpRequestMethod(httpRequestMethod);
            this.value = runtimeData;
        }
    }

    protected class ChannelRuntimeDataHandler
    extends DeserializerImpl {
        ChannelRuntimeDataDeserializer crdd = null;

        public ChannelRuntimeDataHandler(ChannelRuntimeDataDeserializer crdd) {
            this.crdd = crdd;
        }

        public void setValue(Object val, Object hint) throws SAXException {
            this.crdd.setValue(val, hint);
        }

        public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
            QName typeQName = context.getTypeFromAttributes(namespace, localName, attributes);
            Deserializer dser = context.getDeserializerForType(typeQName);
            if (dser == null) {
                dser = new DeserializerImpl();
            }
            DeserializerTarget dt = null;
            if (localName.equals("request-parameters")) {
                dt = new DeserializerTarget((Deserializer)this, REQUEST_PARAMS_HINT);
            } else if (localName.equals("keywords")) {
                dt = new DeserializerTarget((Deserializer)this, KEYWORDS_HINT);
            } else if (localName.equals("rendering-as-root")) {
                dt = new DeserializerTarget((Deserializer)this, RENDERING_AS_ROOT_HINT);
            } else if (localName.equals("browser-info")) {
                dt = new DeserializerTarget((Deserializer)this, BROWSER_INFO_HINT);
            } else if (localName.equals("locales")) {
                dt = new DeserializerTarget((Deserializer)this, LOCALES_HINT);
            } else if (localName.equals("up-file-spec")) {
                dt = new DeserializerTarget((Deserializer)this, UP_FILE_SPEC_HINT);
            } else if (localName.equals("base-action-url")) {
                dt = new DeserializerTarget((Deserializer)this, BASE_ACTION_URL_HINT);
            } else if (localName.equals("http-request-method")) {
                dt = new DeserializerTarget((Deserializer)this, HTTP_REQUEST_METHOD_HINT);
            }
            if (dt != null) {
                dser.registerValueTarget((Target)dt);
            }
            return (SOAPHandler)dser;
        }
    }
}

