/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.webservices.ser;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.encoding.Target;
import org.apache.axis.message.SOAPHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CookieDeserializer
extends DeserializerImpl {
    private Map cookieInfo = new HashMap(8);
    private static final Object NAME_HINT = new Object();
    private static final Object VALUE_HINT = new Object();
    private static final Object COMMENT_HINT = new Object();
    private static final Object DOMAIN_HINT = new Object();
    private static final Object MAXAGE_HINT = new Object();
    private static final Object PATH_HINT = new Object();
    private static final Object SECURE_HINT = new Object();
    private static final Object VERSION_HINT = new Object();

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (!localName.equals("cookie")) {
            throw new SAXException("Expecting <cookie> element. Got <" + localName + "> instead.");
        }
        return new CookieHandler(this);
    }

    public void setValue(Object value, Object hint) throws SAXException {
        if (hint != null) {
            this.cookieInfo.put(hint, value);
        }
        if (this.cookieInfo.size() == 8) {
            String cName = (String)this.cookieInfo.get(NAME_HINT);
            String cValue = (String)this.cookieInfo.get(VALUE_HINT);
            String cComment = (String)this.cookieInfo.get(COMMENT_HINT);
            String cDomain = (String)this.cookieInfo.get(DOMAIN_HINT);
            int cMaxAge = (Integer)this.cookieInfo.get(MAXAGE_HINT);
            String cPath = (String)this.cookieInfo.get(PATH_HINT);
            boolean cSecure = (Boolean)this.cookieInfo.get(SECURE_HINT);
            int cVersion = (Integer)this.cookieInfo.get(VERSION_HINT);
            Cookie cookie = new Cookie(cName != null ? cName : "", cValue != null ? cValue : "");
            if (cComment != null) {
                cookie.setComment(cComment);
            }
            if (cDomain != null) {
                cookie.setDomain(cDomain);
            }
            cookie.setMaxAge(cMaxAge);
            if (cPath != null) {
                cookie.setPath(cPath);
            }
            cookie.setSecure(cSecure);
            cookie.setVersion(cVersion);
            this.value = cookie;
        }
    }

    protected class CookieHandler
    extends DeserializerImpl {
        CookieDeserializer cd = null;

        public CookieHandler(CookieDeserializer cd) {
            this.cd = cd;
        }

        public void setValue(Object val, Object hint) throws SAXException {
            this.cd.setValue(val, hint);
        }

        public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
            QName typeQName = context.getTypeFromAttributes(namespace, localName, attributes);
            Deserializer dser = context.getDeserializerForType(typeQName);
            if (dser == null) {
                dser = new DeserializerImpl();
            }
            DeserializerTarget dt = null;
            if (localName.equals("name")) {
                dt = new DeserializerTarget((Deserializer)this, NAME_HINT);
            } else if (localName.equals("value")) {
                dt = new DeserializerTarget((Deserializer)this, VALUE_HINT);
            } else if (localName.equals("comment")) {
                dt = new DeserializerTarget((Deserializer)this, COMMENT_HINT);
            } else if (localName.equals("domain")) {
                dt = new DeserializerTarget((Deserializer)this, DOMAIN_HINT);
            } else if (localName.equals("maxAge")) {
                dt = new DeserializerTarget((Deserializer)this, MAXAGE_HINT);
            } else if (localName.equals("path")) {
                dt = new DeserializerTarget((Deserializer)this, PATH_HINT);
            } else if (localName.equals("secure")) {
                dt = new DeserializerTarget((Deserializer)this, SECURE_HINT);
            } else if (localName.equals("version")) {
                dt = new DeserializerTarget((Deserializer)this, VERSION_HINT);
            }
            if (dt != null) {
                dser.registerValueTarget((Target)dt);
            }
            return (SOAPHandler)dser;
        }
    }
}

