/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.webservices.ser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.encoding.Target;
import org.apache.axis.message.SOAPHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LocaleDeserializer
extends DeserializerImpl {
    private Map localeInfo = new HashMap(3);
    private static final Object LANGUAGE_HINT = new Object();
    private static final Object COUNTRY_HINT = new Object();
    private static final Object VARIANT_HINT = new Object();

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (!localName.equals("locale")) {
            throw new SAXException("Expecting <locale> element. Got <" + localName + "> instead.");
        }
        return new LocaleHandler(this);
    }

    public void setValue(Object value, Object hint) throws SAXException {
        if (hint != null) {
            this.localeInfo.put(hint, value);
        }
        if (this.localeInfo.size() == 3) {
            String lLanguage = (String)this.localeInfo.get(LANGUAGE_HINT);
            String lCountry = (String)this.localeInfo.get(COUNTRY_HINT);
            String lVariant = (String)this.localeInfo.get(VARIANT_HINT);
            Locale locale = null;
            if (lLanguage != null && lCountry != null && lVariant != null) {
                locale = new Locale(lLanguage, lCountry, lVariant);
            } else if (lLanguage != null && lCountry != null) {
                locale = new Locale(lLanguage, lCountry);
            } else if (lLanguage != null) {
                // empty if block
            }
            this.value = locale;
        }
    }

    protected class LocaleHandler
    extends DeserializerImpl {
        LocaleDeserializer cd = null;

        public LocaleHandler(LocaleDeserializer cd) {
            this.cd = cd;
        }

        public void setValue(Object val, Object hint) throws SAXException {
            this.cd.setValue(val, hint);
        }

        public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
            QName typeQName = context.getTypeFromAttributes(namespace, localName, attributes);
            Deserializer dser = context.getDeserializerForType(typeQName);
            if (dser == null) {
                dser = new DeserializerImpl();
            }
            DeserializerTarget dt = null;
            if (localName.equals("language")) {
                dt = new DeserializerTarget((Deserializer)this, LANGUAGE_HINT);
            } else if (localName.equals("country")) {
                dt = new DeserializerTarget((Deserializer)this, COUNTRY_HINT);
            } else if (localName.equals("variant")) {
                dt = new DeserializerTarget((Deserializer)this, VARIANT_HINT);
            }
            if (dt != null) {
                dser.registerValueTarget((Target)dt);
            }
            return (SOAPHandler)dser;
        }
    }
}

