/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean.helpers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.bean.CocoonBean;
import org.apache.cocoon.bean.helpers.OutputStreamListener;
import org.apache.commons.lang.BooleanUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanConfigurator {
    private static final String NODE_ROOT = "cocoon";
    private static final String ATTR_VERBOSE = "verbose";
    private static final String NODE_LOGGING = "logging";
    private static final String ATTR_LOG_KIT = "log-kit";
    private static final String ATTR_LOG_LEVEL = "level";
    private static final String ATTR_LOGGER = "logger";
    private static final String NODE_CONTEXT_DIR = "context-dir";
    private static final String NODE_DEST_DIR = "dest-dir";
    private static final String NODE_WORK_DIR = "work-dir";
    private static final String NODE_CONFIG_FILE = "config-file";
    private static final String NODE_URI_FILE = "uri-file";
    private static final String NODE_CHECKSUMS_URI = "checksums-uri";
    private static final String ATTR_CONTEXT_DIR = "context-dir";
    private static final String ATTR_DEST_DIR = "dest-dir";
    private static final String ATTR_WORK_DIR = "work-dir";
    private static final String ATTR_CONFIG_FILE = "config-file";
    private static final String ATTR_URI_FILE = "uri-file";
    private static final String ATTR_CHECKSUMS_URI = "checksums-uri";
    private static final String ATTR_AGENT = "user-agent";
    private static final String ATTR_ACCEPT = "accept";
    private static final String ATTR_DEFAULT_FILENAME = "default-filename";
    private static final String NODE_BROKEN_LINKS = "broken-links";
    private static final String ATTR_BROKEN_LINK_REPORT_TYPE = "type";
    private static final String ATTR_BROKEN_LINK_REPORT_FILE = "file";
    private static final String ATTR_BROKEN_LINK_GENERATE = "generate";
    private static final String ATTR_BROKEN_LINK_EXTENSION = "extension";
    private static final String NODE_AGENT = "user-agent";
    private static final String NODE_ACCEPT = "accept";
    private static final String ATTR_FOLLOW_LINKS = "follow-links";
    private static final String ATTR_PRECOMPILE_ONLY = "precompile-only";
    private static final String ATTR_CONFIRM_EXTENSIONS = "confirm-extensions";
    private static final String NODE_LOAD_CLASS = "load-class";
    private static final String NODE_DEFAULT_FILENAME = "default-filename";
    private static final String NODE_INCLUDE = "include";
    private static final String NODE_EXCLUDE = "exclude";
    private static final String ATTR_INCLUDE_EXCLUDE_PATTERN = "pattern";
    private static final String NODE_INCLUDE_LINKS = "include-links";
    private static final String ATTR_LINK_EXTENSION = "extension";
    private static final String NODE_URI = "uri";
    private static final String ATTR_URI_TYPE = "type";
    private static final String ATTR_URI_SOURCEPREFIX = "src-prefix";
    private static final String ATTR_URI_SOURCEURI = "src";
    private static final String ATTR_URI_DESTURI = "dest";
    private static final String NODE_URIS = "uris";
    private static final String ATTR_NAME = "name";

    public static String configure(Document xconf, CocoonBean cocoon, String destDir, String uriGroup, OutputStreamListener listener) throws IllegalArgumentException {
        Element root = xconf.getDocumentElement();
        if (!NODE_ROOT.equals(root.getNodeName())) {
            throw new IllegalArgumentException("Expected root node of cocoon");
        }
        if (BeanConfigurator.hasAttribute(root, ATTR_VERBOSE)) {
            cocoon.setVerbose(BeanConfigurator.getBooleanAttributeValue(root, ATTR_VERBOSE));
        }
        if (BeanConfigurator.hasAttribute(root, ATTR_FOLLOW_LINKS)) {
            cocoon.setFollowLinks(BeanConfigurator.getBooleanAttributeValue(root, ATTR_FOLLOW_LINKS));
        }
        if (BeanConfigurator.hasAttribute(root, ATTR_PRECOMPILE_ONLY)) {
            cocoon.setPrecompileOnly(BeanConfigurator.getBooleanAttributeValue(root, ATTR_PRECOMPILE_ONLY));
        }
        if (BeanConfigurator.hasAttribute(root, ATTR_CONFIRM_EXTENSIONS)) {
            cocoon.setConfirmExtensions(BeanConfigurator.getBooleanAttributeValue(root, ATTR_CONFIRM_EXTENSIONS));
        }
        if (BeanConfigurator.hasAttribute(root, "context-dir")) {
            cocoon.setContextDir(BeanConfigurator.getAttributeValue(root, "context-dir"));
        }
        if (BeanConfigurator.hasAttribute(root, "dest-dir")) {
            destDir = BeanConfigurator.getAttributeValue(root, "dest-dir");
        }
        if (BeanConfigurator.hasAttribute(root, "work-dir")) {
            cocoon.setWorkDir(BeanConfigurator.getAttributeValue(root, "work-dir"));
        }
        if (BeanConfigurator.hasAttribute(root, "config-file")) {
            cocoon.setConfigFile(BeanConfigurator.getAttributeValue(root, "config-file"));
        }
        if (BeanConfigurator.hasAttribute(root, "uri-file")) {
            cocoon.addTargets(BeanConfigurator.processURIFile(BeanConfigurator.getAttributeValue(root, "uri-file")), destDir);
        }
        if (BeanConfigurator.hasAttribute(root, "checksums-uri")) {
            cocoon.setChecksumURI(BeanConfigurator.getAttributeValue(root, "checksums-uri"));
        }
        if (BeanConfigurator.hasAttribute(root, "user-agent")) {
            cocoon.setAgentOptions(BeanConfigurator.getAttributeValue(root, "user-agent"));
        }
        if (BeanConfigurator.hasAttribute(root, "accept")) {
            cocoon.setAcceptOptions(BeanConfigurator.getAttributeValue(root, "accept"));
        }
        if (BeanConfigurator.hasAttribute(root, "default-filename")) {
            cocoon.setDefaultFilename(BeanConfigurator.getAttributeValue(root, "default-filename"));
        }
        if (destDir == null || destDir.length() == 0) {
            destDir = BeanConfigurator.getNodeValue(root, "dest-dir");
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String pattern;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName();
            if (nodeName.equals(NODE_BROKEN_LINKS)) {
                BeanConfigurator.parseBrokenLinkNode(cocoon, node, listener);
                continue;
            }
            if (nodeName.equals(NODE_LOAD_CLASS)) {
                cocoon.addLoadedClass(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals(NODE_LOGGING)) {
                BeanConfigurator.parseLoggingNode(cocoon, node);
                continue;
            }
            if (nodeName.equals("context-dir")) {
                if (BeanConfigurator.hasAttribute(root, "context-dir")) {
                    throw new IllegalArgumentException("Cannot have context-dir as both element and attribute");
                }
                cocoon.setContextDir(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals("config-file")) {
                if (BeanConfigurator.hasAttribute(root, "config-file")) {
                    throw new IllegalArgumentException("Cannot have config-file as both element and attribute");
                }
                cocoon.setConfigFile(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals("dest-dir")) continue;
            if (nodeName.equals("work-dir")) {
                if (BeanConfigurator.hasAttribute(root, "work-dir")) {
                    throw new IllegalArgumentException("Cannot have work-dir as both element and attribute");
                }
                cocoon.setWorkDir(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals("checksums-uri")) {
                if (BeanConfigurator.hasAttribute(root, "checksums-uri")) {
                    throw new IllegalArgumentException("Cannot have checksums-uri as both element and attribute");
                }
                cocoon.setChecksumURI(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals("user-agent")) {
                cocoon.setAgentOptions(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals("accept")) {
                cocoon.setAcceptOptions(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals("default-filename")) {
                cocoon.setDefaultFilename(BeanConfigurator.getNodeValue(node));
                continue;
            }
            if (nodeName.equals(NODE_INCLUDE)) {
                pattern = BeanConfigurator.parseIncludeExcludeNode(cocoon, node, NODE_INCLUDE);
                cocoon.addIncludePattern(pattern);
                continue;
            }
            if (nodeName.equals(NODE_EXCLUDE)) {
                pattern = BeanConfigurator.parseIncludeExcludeNode(cocoon, node, NODE_EXCLUDE);
                cocoon.addExcludePattern(pattern);
                continue;
            }
            if (nodeName.equals(NODE_INCLUDE_LINKS)) {
                BeanConfigurator.parseIncludeLinksNode(cocoon, node);
                continue;
            }
            if (nodeName.equals(NODE_URI)) {
                BeanConfigurator.parseURINode(cocoon, node, destDir);
                continue;
            }
            if (nodeName.equals(NODE_URIS)) {
                BeanConfigurator.parseURIsNode(cocoon, node, destDir, uriGroup);
                continue;
            }
            if (nodeName.equals("uri-file")) {
                if (BeanConfigurator.hasAttribute(root, "uri-file")) {
                    throw new IllegalArgumentException("Cannot have uri-file as both element and attribute");
                }
                cocoon.addTargets(BeanConfigurator.processURIFile(BeanConfigurator.getNodeValue(node)), destDir);
                continue;
            }
            throw new IllegalArgumentException("Unknown element: <" + nodeName + ">");
        }
        return destDir;
    }

    private static void parseLoggingNode(CocoonBean cocoon, Node node) throws IllegalArgumentException {
        NodeList nodes;
        if (BeanConfigurator.hasAttribute(node, ATTR_LOG_KIT)) {
            cocoon.setLogKit(BeanConfigurator.getAttributeValue(node, ATTR_LOG_KIT));
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_LOGGER)) {
            cocoon.setLogger(BeanConfigurator.getAttributeValue(node, ATTR_LOGGER));
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_LOG_LEVEL)) {
            cocoon.setLogLevel(BeanConfigurator.getAttributeValue(node, ATTR_LOG_LEVEL));
        }
        if ((nodes = node.getChildNodes()).getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <logging> node");
        }
    }

    private static void parseIncludeLinksNode(CocoonBean cocoon, Node node) throws IllegalArgumentException {
        if (BeanConfigurator.hasAttribute(node, "extension")) {
            cocoon.addIncludeLinkExtension(BeanConfigurator.getAttributeValue(node, "extension"));
        }
    }

    private static void parseBrokenLinkNode(CocoonBean cocoon, Node node, OutputStreamListener listener) throws IllegalArgumentException {
        NodeList nodes;
        if (BeanConfigurator.hasAttribute(node, ATTR_BROKEN_LINK_REPORT_FILE)) {
            listener.setReportFile(BeanConfigurator.getAttributeValue(node, ATTR_BROKEN_LINK_REPORT_FILE));
        }
        if (BeanConfigurator.hasAttribute(node, "type")) {
            listener.setReportType(BeanConfigurator.getAttributeValue(node, "type"));
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_BROKEN_LINK_GENERATE)) {
            cocoon.setBrokenLinkGenerate(BeanConfigurator.getBooleanAttributeValue(node, ATTR_BROKEN_LINK_GENERATE));
        }
        if (BeanConfigurator.hasAttribute(node, "extension")) {
            cocoon.setBrokenLinkExtension(BeanConfigurator.getAttributeValue(node, "extension"));
        }
        if ((nodes = node.getChildNodes()).getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <broken-links> node");
        }
    }

    private static String parseIncludeExcludeNode(CocoonBean cocoon, Node node, String NODE_TYPE) throws IllegalArgumentException {
        NodeList nodes = node.getChildNodes();
        if (nodes.getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <include> node");
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_INCLUDE_EXCLUDE_PATTERN)) {
            return BeanConfigurator.getAttributeValue(node, ATTR_INCLUDE_EXCLUDE_PATTERN);
        }
        throw new IllegalArgumentException("Expected a pattern attribute for <" + NODE_TYPE + "> node");
    }

    private static void parseURIsNode(CocoonBean cocoon, Node node, String destDir, String uriGroup) throws IllegalArgumentException {
        boolean followLinks = cocoon.followLinks();
        boolean confirmExtensions = cocoon.confirmExtensions();
        String logger = cocoon.getLoggerName();
        String destURI = destDir;
        String root = null;
        String type = null;
        String name = null;
        if (BeanConfigurator.hasAttribute(node, ATTR_FOLLOW_LINKS)) {
            followLinks = BeanConfigurator.getBooleanAttributeValue(node, ATTR_FOLLOW_LINKS);
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_CONFIRM_EXTENSIONS)) {
            confirmExtensions = BeanConfigurator.getBooleanAttributeValue(node, ATTR_CONFIRM_EXTENSIONS);
        }
        if (BeanConfigurator.hasAttribute(node, "type")) {
            type = BeanConfigurator.getAttributeValue(node, "type");
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_URI_SOURCEPREFIX)) {
            root = BeanConfigurator.getAttributeValue(node, ATTR_URI_SOURCEPREFIX);
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_URI_DESTURI)) {
            destURI = BeanConfigurator.getAttributeValue(node, ATTR_URI_DESTURI);
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_LOGGER)) {
            logger = BeanConfigurator.getAttributeValue(node, ATTR_LOGGER);
        }
        if (BeanConfigurator.hasAttribute(node, ATTR_NAME) && (name = BeanConfigurator.getAttributeValue(node, ATTR_NAME)) != null && uriGroup != null && !name.equals(uriGroup)) {
            return;
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (childName.equals(NODE_URI)) {
                String _sourceURI = null;
                String _destURI = destURI;
                String _root = root;
                String _type = type;
                if (child.getAttributes().getLength() == 0) {
                    _sourceURI = BeanConfigurator.getNodeValue(child);
                } else {
                    _sourceURI = BeanConfigurator.getAttributeValue(child, ATTR_URI_SOURCEURI);
                    if (BeanConfigurator.hasAttribute(child, "type")) {
                        _type = BeanConfigurator.getAttributeValue(child, "type");
                    }
                    if (BeanConfigurator.hasAttribute(child, ATTR_URI_SOURCEPREFIX)) {
                        _root = BeanConfigurator.getAttributeValue(child, ATTR_URI_SOURCEPREFIX);
                    }
                    if (BeanConfigurator.hasAttribute(child, ATTR_URI_DESTURI)) {
                        _destURI = BeanConfigurator.getAttributeValue(child, ATTR_URI_DESTURI);
                    }
                }
                cocoon.addTarget(_type, _root, _sourceURI, _destURI, followLinks, confirmExtensions, logger);
                continue;
            }
            throw new IllegalArgumentException("Unknown element: <" + childName + ">");
        }
    }

    private static void parseURINode(CocoonBean cocoon, Node node, String destDir) throws IllegalArgumentException {
        NodeList nodes = node.getChildNodes();
        if (node.getAttributes().getLength() == 0 && nodes.getLength() != 0) {
            cocoon.addTarget(BeanConfigurator.getNodeValue(node), destDir);
        } else if (node.getAttributes().getLength() != 0 && nodes.getLength() == 0) {
            String src = BeanConfigurator.getAttributeValue(node, ATTR_URI_SOURCEURI);
            String type = null;
            if (BeanConfigurator.hasAttribute(node, "type")) {
                type = BeanConfigurator.getAttributeValue(node, "type");
            }
            String root = null;
            if (BeanConfigurator.hasAttribute(node, ATTR_URI_SOURCEPREFIX)) {
                root = BeanConfigurator.getAttributeValue(node, ATTR_URI_SOURCEPREFIX);
            }
            String dest = null;
            if (BeanConfigurator.hasAttribute(node, ATTR_URI_DESTURI)) {
                dest = BeanConfigurator.getAttributeValue(node, ATTR_URI_DESTURI);
            }
            if (root != null && type != null & dest != null) {
                cocoon.addTarget(type, root, src, dest);
            } else if (root != null & dest != null) {
                cocoon.addTarget(root, src, dest);
            } else if (dest != null) {
                cocoon.addTarget(src, dest);
            } else {
                cocoon.addTarget(src, destDir);
            }
        } else {
            if (node.getAttributes().getLength() != 0 && nodes.getLength() != 0) {
                throw new IllegalArgumentException("Unexpected children of <uri> node");
            }
            throw new IllegalArgumentException("Not enough information for <uri> node");
        }
    }

    private static String getNodeValue(Node root, String name) throws IllegalArgumentException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String nodeName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeName = node.getNodeName()).equals(name)) continue;
            return BeanConfigurator.getNodeValue(node);
        }
        return null;
    }

    private static String getNodeValue(Node node) throws IllegalArgumentException {
        StringBuffer s = new StringBuffer();
        NodeList children = node.getChildNodes();
        boolean found = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) {
                throw new IllegalArgumentException("Unexpected node:" + child.getLocalName());
            }
            s.append(child.getNodeValue());
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Expected value for " + node.getLocalName() + " node");
        }
        return s.toString();
    }

    private static String getAttributeValue(Node node, String attr) throws IllegalArgumentException {
        Node attribute;
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null && (attribute = nodes.getNamedItem(attr)) != null && attribute.getNodeValue() != null) {
            return attribute.getNodeValue();
        }
        throw new IllegalArgumentException("Missing " + attr + " attribute on <" + node.getNodeName() + "> node");
    }

    private static boolean hasAttribute(Node node, String attr) {
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null) {
            Node attribute = nodes.getNamedItem(attr);
            return attribute != null;
        }
        return false;
    }

    private static boolean getBooleanAttributeValue(Node node, String attr) {
        Node attribute;
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null && (attribute = nodes.getNamedItem(attr)) != null) {
            String value = attribute.getNodeValue();
            return BooleanUtils.toBoolean((String)value);
        }
        return false;
    }

    public static List processURIFile(String filename) {
        ArrayList<String> uris = new ArrayList<String>();
        try {
            String uri;
            BufferedReader uriFile = new BufferedReader(new FileReader(filename));
            while (null != (uri = uriFile.readLine())) {
                if ((uri = uri.trim()).equals("") || uri.startsWith("#")) continue;
                uris.add(uri.trim());
            }
            uriFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uris;
    }
}

