/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.modules.input.JXPathHelperConfiguration;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.PackageFunctions;

public class JXPathHelper {
    private JXPathHelper() {
    }

    public static JXPathHelperConfiguration setup(Configuration config, boolean lenient) throws ConfigurationException {
        lenient = config.getChild("lenient").getValueAsBoolean(lenient);
        FunctionLibrary library = new FunctionLibrary();
        JXPathHelper.getFunctions(library, config);
        JXPathHelper.getPackages(library, config);
        return new JXPathHelperConfiguration(library, lenient);
    }

    private static void getFunctions(FunctionLibrary lib, Configuration conf) {
        Configuration[] children = conf.getChildren("function");
        int i = children.length;
        while (i-- > 0) {
            String clazzName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (clazzName == null || prefix == null) continue;
            try {
                Class<?> clazz = Class.forName(clazzName);
                lib.addFunctions((Functions)new ClassFunctions(clazz, prefix));
            }
            catch (ClassNotFoundException cnf) {}
        }
    }

    private static void getPackages(FunctionLibrary lib, Configuration conf) {
        Configuration[] children = conf.getChildren("package");
        int i = children.length;
        while (i-- > 0) {
            String packageName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (packageName == null || prefix == null) continue;
            lib.addFunctions((Functions)new PackageFunctions(packageName, prefix));
        }
    }

    private static void setupExtensions(JXPathHelperConfiguration setup, JXPathContext context, Configuration conf) {
        FunctionLibrary localLib = null;
        if (conf != null) {
            localLib = new FunctionLibrary();
            localLib.addFunctions((Functions)setup.getLibrary());
            JXPathHelper.getPackages(localLib, conf);
            JXPathHelper.getFunctions(localLib, conf);
        } else {
            localLib = setup.getLibrary();
        }
        context.setFunctions((Functions)localLib);
    }

    public static Object getAttribute(String name, Configuration modeConf, JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            JXPathHelper.setupExtensions(setup, jxContext, modeConf);
            if (setup.isLenient()) {
                jxContext.setLenient(true);
            }
            Object obj = jxContext.getValue(name);
            return obj;
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public static Object[] getAttributeValues(String name, Configuration modeConf, JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            Iterator i;
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            LinkedList values = null;
            JXPathHelper.setupExtensions(setup, jxContext, modeConf);
            if (setup.isLenient()) {
                jxContext.setLenient(true);
            }
            if ((i = jxContext.iterate(name)).hasNext()) {
                values = new LinkedList();
            }
            while (i.hasNext()) {
                values.add(i.next());
            }
            Object[] obj = null;
            if (values != null && (obj = values.toArray()).length == 0) {
                obj = null;
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public static Iterator getAttributeNames(JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathBeanInfo info = JXPathIntrospector.getBeanInfo(contextObj.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            LinkedList<String> names = new LinkedList<String>();
            for (int i = 0; i < properties.length; ++i) {
                names.add(properties[i].getName());
            }
            return names.listIterator();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error retrieving attribute names for class: " + contextObj.getClass(), (Throwable)e);
        }
    }
}

