/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.xml.SaxBuffer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParamSaxBuffer
extends SaxBuffer {
    public ParamSaxBuffer() {
    }

    public ParamSaxBuffer(SaxBuffer saxBuffer) {
        super(saxBuffer);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            int j;
            if (ch[i] != '{') continue;
            if (i > start) {
                this.addBit(new SaxBuffer.Characters(ch, start, i - start));
            }
            StringBuffer name = new StringBuffer();
            for (j = i + 1; j < end && ch[j] != '}'; ++j) {
                name.append(ch[j]);
            }
            if (j == end) {
                throw new SAXException("Unclosed '}'");
            }
            this.addBit(new Parameter(name.toString()));
            i = j;
            start = j + 1;
        }
        if (start < end) {
            this.addBit(new SaxBuffer.Characters(ch, start, end - start));
        }
    }

    public void toSAX(ContentHandler contentHandler, Map parameters) throws SAXException {
        Iterator i = this.bits();
        while (i.hasNext()) {
            SaxBuffer.SaxBit saxbit = (SaxBuffer.SaxBit)i.next();
            if (saxbit instanceof Parameter) {
                ((Parameter)saxbit).send(contentHandler, parameters);
                continue;
            }
            saxbit.send(contentHandler);
        }
    }

    static final class Parameter
    implements SaxBuffer.SaxBit {
        private final String name;

        public Parameter(String name) {
            this.name = name;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
        }

        public void send(ContentHandler contentHandler, Map parameters) throws SAXException {
            SaxBuffer value = (SaxBuffer)parameters.get(this.name);
            if (value != null) {
                value.toSAX(contentHandler);
            }
        }

        public void dump(Writer writer) throws IOException {
            writer.write("[ParamSaxBuffer.Parameter] name=" + this.name);
        }
    }
}

