/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import com.oreilly.servlet.multipart.Part;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.services.LogService;

public class ChannelRuntimeData
extends Hashtable
implements Cloneable {
    private BrowserInfo binfo = null;
    private Locale[] locales = null;
    private UPFileSpec channelUPFile = new UPFileSpec();
    private String baseActionURL = null;
    private String httpRequestMethod = null;
    private String keywords = null;
    private boolean renderingAsRoot = false;
    private static final String TRADITIONAL_MEDIA_BASE = "media/";

    public Object clone() {
        ChannelRuntimeData crd = new ChannelRuntimeData();
        crd.binfo = this.binfo;
        crd.locales = this.locales;
        crd.channelUPFile = this.channelUPFile;
        crd.baseActionURL = this.baseActionURL;
        crd.httpRequestMethod = this.httpRequestMethod;
        crd.keywords = this.keywords;
        crd.renderingAsRoot = this.renderingAsRoot;
        crd.putAll(this);
        return crd;
    }

    public void setUPFile(UPFileSpec upfs) {
        this.channelUPFile = upfs;
    }

    public UPFileSpec getUPFile() {
        return this.channelUPFile;
    }

    public void setHttpRequestMethod(String method) {
        this.httpRequestMethod = method;
    }

    public String getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    public void setBaseActionURL(String baseActionURL) {
        this.baseActionURL = baseActionURL;
    }

    public void setRenderingAsRoot(boolean rar) {
        this.renderingAsRoot = rar;
    }

    public void setBrowserInfo(BrowserInfo bi) {
        this.binfo = bi;
    }

    public BrowserInfo getBrowserInfo() {
        return this.binfo;
    }

    public void setLocales(Locale[] locales) {
        this.locales = locales;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public void setParameters(Map params) {
        this.putAll(params);
    }

    public void setParametersSingleValued(Map params) {
        if (params != null) {
            Iterator iter = params.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = params.get(key);
                if (value instanceof String) {
                    this.setParameter(key, (String)value);
                    continue;
                }
                if (!(value instanceof Part)) continue;
                this.setParameter(key, (Part)value);
            }
        }
    }

    public String[] setParameterValues(String pName, String[] values) {
        return super.put(pName, values);
    }

    public void setParameter(String pName, String value) {
        String[] valueArray = new String[]{value};
        super.put(pName, valueArray);
    }

    public Part[] setParameterValues(String pName, Part[] values) {
        return super.put(pName, values);
    }

    public synchronized void setParameter(String key, Part value) {
        Part[] valueArray = new Part[]{value};
        super.put(key, valueArray);
    }

    public String getBaseActionURL() {
        return this.getBaseActionURL(false);
    }

    public String getBaseActionURL(boolean idempotent) {
        if (this.baseActionURL != null) {
            return URLEncoder.encode(this.baseActionURL);
        }
        String url = null;
        try {
            if (idempotent) {
                UPFileSpec upfs = new UPFileSpec(this.channelUPFile);
                upfs.setTagId("idempotent");
                url = upfs.getUPFile();
            } else {
                url = this.channelUPFile.getUPFile();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "ChannelRuntimeData::getBaseActionURL() : unable to construct a base action URL!");
        }
        return URLEncoder.encode(url);
    }

    public String getBaseWorkerURL(String worker) {
        String url = null;
        try {
            url = this.getBaseWorkerURL(worker, false);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "ChannelRuntimeData::getBaseWorkerURL() : unable to construct a worker action URL for a worker \"" + worker + "\".");
        }
        return URLEncoder.encode(url);
    }

    public String getBaseMediaURL(Object aChannelObject) throws PortalException {
        return this.getBaseMediaURL(aChannelObject.getClass());
    }

    public String getBaseMediaURL(Class aChannelClass) throws PortalException {
        if (aChannelClass.getClassLoader() == CarResources.getInstance().getClassLoader()) {
            return this.createBaseCarMediaURL();
        }
        return TRADITIONAL_MEDIA_BASE;
    }

    public String getBaseMediaURL(String resourcePath) throws PortalException {
        if (CarResources.getInstance().containsResource(resourcePath)) {
            return this.createBaseCarMediaURL();
        }
        return TRADITIONAL_MEDIA_BASE;
    }

    private String createBaseCarMediaURL() throws PortalException {
        String url = this.getBaseWorkerURL("carRsrc", true);
        return URLEncoder.encode(url).concat("?carRsrc=");
    }

    public String getBaseWorkerURL(String worker, boolean idempotent) throws PortalException {
        String url = null;
        UPFileSpec upfs = new UPFileSpec(this.channelUPFile);
        upfs.setMethod(1);
        upfs.setMethodNodeId(worker);
        if (idempotent) {
            upfs.setTagId("idempotent");
        }
        url = upfs.getUPFile();
        return URLEncoder.encode(url);
    }

    public boolean isRenderingAsRoot() {
        return this.renderingAsRoot;
    }

    public String getParameter(String pName) {
        String[] value_array = this.getParameterValues(pName);
        if (value_array != null && value_array.length > 0) {
            return value_array[0];
        }
        return null;
    }

    public Object getObjectParameter(String pName) {
        Object[] value_array = this.getObjectParameterValues(pName);
        if (value_array != null && value_array.length > 0) {
            return value_array[0];
        }
        return null;
    }

    public String[] getParameterValues(String pName) {
        Object[] pars = (Object[])super.get(pName);
        if (pars instanceof String[]) {
            return (String[])pars;
        }
        return null;
    }

    public Object[] getObjectParameterValues(String pName) {
        return (Object[])super.get(pName);
    }

    public Enumeration getParameterNames() {
        return super.keys();
    }

    public Map getParameters() {
        HashMap<String, String> params = new HashMap<String, String>(this.size());
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getParameter(name);
            params.put(name, value);
        }
        return params;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }
}

