/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.File;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.ChannelRendererFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.InternalPortalException;
import org.jasig.portal.InternalTimeoutException;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.helpers.AttributesImpl;

public class StandaloneChannelRenderer
extends BaseChannel {
    private StylesheetSet set;
    private MediaManager mediaM;
    private String channelName;
    private PortalControlStructures pcs;
    private BrowserInfo binfo;
    private LocaleManager lm;
    private boolean hasEdit = false;
    private boolean hasAbout = false;
    private boolean hasHelp = false;
    private long timeOut;
    private boolean dataIsSet = false;
    private static final String chanID = "singleton";
    private static final String fs = File.separator;
    private static final String relativeSSLLocation = "/org/jasig/portal/tools/ChannelServlet/ChannelServlet.ssl";
    private static final IChannelRendererFactory cChannelRendererFactory = ChannelRendererFactory.newInstance((class$org$jasig$portal$StandaloneChannelRenderer == null ? (class$org$jasig$portal$StandaloneChannelRenderer = StandaloneChannelRenderer.class$("org.jasig.portal.StandaloneChannelRenderer")) : class$org$jasig$portal$StandaloneChannelRenderer).getName());
    static /* synthetic */ Class class$org$jasig$portal$StandaloneChannelRenderer;

    public void initialize(Hashtable params, String channelName, boolean hasHelp, boolean hasAbout, boolean hasEdit, long timeOut, IPerson person) throws PortalException {
        this.set = new StylesheetSet(ResourceLoader.getResourceAsURLString(this.getClass(), relativeSSLLocation));
        String mediaPropsUrl = ResourceLoader.getResourceAsURLString(this.getClass(), "/properties/media.properties");
        String mimePropsUrl = ResourceLoader.getResourceAsURLString(this.getClass(), "/properties/mime.properties");
        String serializerPropsUrl = ResourceLoader.getResourceAsURLString(this.getClass(), "/properties/serializer.properties");
        this.set.setMediaProps(mediaPropsUrl);
        this.mediaM = new MediaManager(mediaPropsUrl, mimePropsUrl, serializerPropsUrl);
        this.channelName = channelName;
        this.hasHelp = hasHelp;
        this.hasAbout = hasAbout;
        this.hasEdit = hasEdit;
        this.timeOut = timeOut;
        ChannelStaticData sd = new ChannelStaticData();
        sd.setChannelSubscribeId(chanID);
        sd.setTimeout(timeOut);
        sd.setParameters(params);
        sd.setPerson(person);
        this.setStaticData(sd);
    }

    public void prepare(HttpServletRequest req) throws Exception {
        if (this instanceof IPrivilegedChannel) {
            ((IPrivilegedChannel)((Object)this)).setPortalControlStructures(this.pcs);
        }
        this.setRuntimeData(this.getRuntimeData(req));
        this.dataIsSet = true;
    }

    public void render(HttpServletRequest req, HttpServletResponse res) throws Throwable {
        ChannelRuntimeData rd = null;
        if (!this.dataIsSet) {
            if (this instanceof IPrivilegedChannel) {
                ((IPrivilegedChannel)((Object)this)).setPortalControlStructures(this.pcs);
            }
            rd = this.getRuntimeData(req);
        } else {
            this.dataIsSet = false;
        }
        IChannelRenderer cr = cChannelRendererFactory.newInstance(this, rd);
        cr.setTimeout(this.timeOut);
        cr.startRendering();
        res.setContentType(this.mediaM.getReturnMimeType(req));
        BaseMarkupSerializer ser = this.mediaM.getSerializer(this.mediaM.getMedia(req), (Writer)res.getWriter());
        ser.asContentHandler();
        String xslURI = ResourceLoader.getResourceAsURLString(this.getClass(), this.set.getStylesheetURI(req));
        try {
            TransformerHandler th = XSLT.getTransformerHandler(xslURI);
            th.setResult(new SAXResult(ser));
            AttributesImpl atl = new AttributesImpl();
            atl.addAttribute("", "name", "name", "CDATA", this.channelName);
            th.startDocument();
            th.startElement("", "channel", "channel", atl);
            ChannelSAXStreamFilter custodian = new ChannelSAXStreamFilter(th);
            int out = cr.outputRendering(custodian);
            if (out == 2) {
                throw new InternalTimeoutException("The channel has timed out");
            }
            th.endElement("", "channel", "channel");
            th.endDocument();
        }
        catch (InternalPortalException ipe) {
            throw ipe.getException();
        }
    }

    private ChannelRuntimeData getRuntimeData(HttpServletRequest req) {
        this.binfo = new BrowserInfo(req);
        String acceptLanguage = req.getHeader("Accept-Language");
        String requestLocalesString = req.getParameter("locale");
        this.lm = new LocaleManager(this.staticData.getPerson(), acceptLanguage);
        this.lm.setSessionLocales(LocaleManager.parseLocales(requestLocalesString));
        Hashtable<String, Object[]> targetParams = new Hashtable<String, Object[]>();
        UPFileSpec upfs = new UPFileSpec(req);
        String channelTarget = upfs.getTargetNodeId();
        LogService.log(LogService.DEBUG, "StandaloneRenderer::render() : channelTarget=\"" + channelTarget + "\".");
        Enumeration en = req.getParameterNames();
        if (en != null) {
            while (en.hasMoreElements()) {
                String pName = (String)en.nextElement();
                Object[] val = req.getParameterValues(pName);
                if (val == null) {
                    val = ((PortalSessionManager.RequestParamWrapper)req).getObjectParameterValues(pName);
                }
                targetParams.put(pName, val);
            }
        }
        ChannelRuntimeData rd = new ChannelRuntimeData();
        rd.setBrowserInfo(this.binfo);
        rd.setLocales(this.lm.getLocales());
        rd.setHttpRequestMethod(req.getMethod());
        if (channelTarget != null && chanID.equals(channelTarget)) {
            rd.setParameters(targetParams);
        }
        try {
            rd.setUPFile(new UPFileSpec(PortalSessionManager.INTERNAL_TAG_VALUE, 0, "servletRoot", chanID, null));
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, "StandaloneRenderer::render() : unable to generate baseActionURL. " + e);
        }
        return rd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

