/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.StringWriter;
import javax.naming.NamingException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

public class CNumberGuess
implements IChannel {
    ChannelStaticData staticData = new ChannelStaticData();
    ChannelRuntimeData runtimeData = new ChannelRuntimeData();
    private static final String sslLocation = "CNumberGuess/CNumberGuess.ssl";
    private int iMinNum = 0;
    private int iMaxNum = 0;
    private int iGuess = 0;
    private int iGuesses = 0;
    private int iAnswer = 0;
    private boolean bFirstTime = true;
    private LogService logger;

    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    public void receiveEvent(PortalEvent ev) {
    }

    public void setStaticData(ChannelStaticData sd) {
        this.staticData = sd;
        if (this.logger == null) {
            try {
                this.logger = (LogService)sd.getJNDIContext().lookup("/services/org.jasig.portal.services.LogService");
                LogService.log(LogService.DEBUG, "CNumberGuess::setStaticData() : obtained LogService instance from JNDI");
            }
            catch (NamingException ne) {
                this.logger = LogService.instance();
                LogService.log(LogService.ERROR, "CNumberGuess()::setStaticData() : unable to botain LogService instance from JNDI: " + ne);
            }
        }
        String sMinNum = null;
        String sMaxNum = null;
        try {
            sMinNum = sd.getParameter("minNum");
            if (sMinNum != null) {
                this.iMinNum = Integer.parseInt(sMinNum);
            }
            if ((sMaxNum = sd.getParameter("maxNum")) != null) {
                this.iMaxNum = Integer.parseInt(sMaxNum);
            }
            this.iAnswer = this.getRandomNumber(this.iMinNum, this.iMaxNum);
        }
        catch (NumberFormatException nfe) {
            this.iMinNum = 0;
            this.iMaxNum = 100;
            LogService.log(LogService.WARN, "CNumberGuess::setStaticData() : either " + sMinNum + " or " + sMaxNum + " (minNum, maxNum) is not a valid integer. Defaults " + this.iMinNum + " and " + this.iMaxNum + " will be used instead.");
        }
    }

    public void setRuntimeData(ChannelRuntimeData rd) {
        this.runtimeData = rd;
        String sGuess = this.runtimeData.getParameter("guess");
        if (sGuess != null) {
            try {
                this.iGuess = Integer.parseInt(sGuess);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.bFirstTime = false;
            ++this.iGuesses;
        }
    }

    public void renderXML(ContentHandler out) throws PortalException {
        String sSuggest = null;
        if (this.iGuess < this.iAnswer) {
            sSuggest = "higher";
        } else if (this.iGuess > this.iAnswer) {
            sSuggest = "lower";
        }
        StringWriter w = new StringWriter();
        w.write("<?xml version='1.0'?>\n");
        w.write("<content>\n");
        w.write("  <minNum>" + this.iMinNum + "</minNum>\n");
        w.write("  <maxNum>" + this.iMaxNum + "</maxNum>\n");
        w.write("  <guesses>" + this.iGuesses + "</guesses>\n");
        w.write("  <guess>" + this.iGuess + "</guess>\n");
        if (!this.bFirstTime) {
            if (this.iGuess == this.iAnswer) {
                w.write("  <answer>" + this.iAnswer + "</answer>\n");
                this.bFirstTime = true;
                this.iGuesses = 0;
                this.iAnswer = this.getRandomNumber(this.iMinNum, this.iMaxNum);
            } else {
                w.write("  <suggest>" + sSuggest + "</suggest>\n");
            }
        }
        w.write("</content>\n");
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(w.toString());
        xslt.setXSL(sslLocation, "main", this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        xslt.transform();
    }

    private int getRandomNumber(int min, int max) {
        return new Double((double)(max - min) * Math.random() + (double)min).intValue();
    }
}

