/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.permissionsmanager;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerServantFactory;
import org.jasig.portal.channels.permissionsmanager.CommandFactory;
import org.jasig.portal.channels.permissionsmanager.IPermissionCommand;
import org.jasig.portal.channels.permissionsmanager.PermissionsSessionData;
import org.jasig.portal.channels.permissionsmanager.PermissionsXML;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CPermissionsManager
implements IChannel,
ICacheable {
    protected PermissionsSessionData session;
    protected final String sslLocation = "CPermissionsManager.ssl";

    public void setRuntimeData(ChannelRuntimeData rD) {
        IPermissionCommand pc;
        this.session.startRD = Calendar.getInstance().getTime().getTime();
        this.session.runtimeData = rD;
        LogService.log(LogService.DEBUG, "PermissionsManager - setting runtime data");
        if (this.session.servant != null) {
            try {
                this.session.servant.setRuntimeData(rD);
                if (this.session.servant.isFinished()) {
                    this.getGroupServantResults(this.session);
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
        if (this.session.runtimeData.getParameter("prmCommand") != null && (pc = CommandFactory.get(this.session.runtimeData.getParameter("prmCommand"))) != null) {
            try {
                pc.execute(this.session);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
                this.session.runtimeData.setParameter("commandResponse", "Error executing command " + this.session.runtimeData.getParameter("prmCommand") + ": " + e.getMessage());
            }
        }
        if (!this.session.gotOwners) {
            this.session.view = "Select Owners";
        }
        if (this.session.gotOwners && !this.session.gotActivities) {
            PermissionsXML.autoSelectSingleChoice(this.session, "activity");
            this.session.view = "Select Activities";
        }
        if (this.session.gotActivities && !this.session.gotTargets) {
            PermissionsXML.autoSelectSingleChoice(this.session, "target");
            this.session.view = "Select Targets";
        }
        if (this.session.gotTargets && this.session.principals == null) {
            LogService.log(LogService.DEBUG, "PermissionsManager - Checking Servant");
            this.prepServant(this.session);
        }
        if (this.session.principals != null) {
            if (this.session.staticData.getParameter("prmView") != null) {
                this.session.view = this.session.staticData.getParameter("prmView");
                this.session.staticData.remove("prmView");
            } else if (this.session.runtimeData.getParameter("prmView") != null) {
                this.session.view = this.session.runtimeData.getParameter("prmView");
            } else if (!this.session.view.startsWith("Assign")) {
                this.session.view = "Assign By Principal";
            }
        }
    }

    protected void prepServant(PermissionsSessionData session) {
        block17: {
            try {
                if (session.servant == null) {
                    if (!session.gotOwners) {
                        LogService.log(LogService.DEBUG, "PermissionsManager - creating new basic Servant");
                        session.servant = CGroupsManagerServantFactory.getGroupsServantforSelection(session.staticData, "Select principals you would like to assign permissions to", "org.jasig.portal.security.IPerson");
                    } else {
                        LogService.log(LogService.DEBUG, "PermissionsManager - creating new pre-selecting Servant");
                        ArrayList gmembers = new ArrayList();
                        Element[] owners = PermissionsXML.getSelectedOwners(session);
                        for (int j = 0; j < owners.length; ++j) {
                            LogService.log(LogService.DEBUG, "analyzing owner " + owners[j].getAttribute("name"));
                            String ownerKey = owners[j].getAttribute("token");
                            IPermissionManager pm = AuthorizationService.instance().newPermissionManager(ownerKey);
                            String[] acts = null;
                            if (session.gotActivities) {
                                acts = PermissionsXML.getSelectedActivities(session, owners[j]);
                            }
                            String[] tgts = null;
                            if (session.gotTargets) {
                                tgts = PermissionsXML.getSelectedTargets(session, owners[j]);
                            }
                            if (acts != null) {
                                for (int a = 0; a < acts.length; ++a) {
                                    if (tgts != null) {
                                        for (int t = 0; t < tgts.length; ++t) {
                                            this.populateMembers(gmembers, pm.getAuthorizedPrincipals(acts[a], tgts[t]));
                                        }
                                        continue;
                                    }
                                    this.populateMembers(gmembers, pm.getAuthorizedPrincipals(acts[a], null));
                                }
                            } else if (tgts != null) {
                                for (int t = 0; t < tgts.length; ++t) {
                                    this.populateMembers(gmembers, pm.getAuthorizedPrincipals(null, tgts[t]));
                                }
                            } else {
                                this.populateMembers(gmembers, pm.getAuthorizedPrincipals(null, null));
                            }
                            session.servant = CGroupsManagerServantFactory.getGroupsServantforSelection(session.staticData, "You may view principals with existing permissions on the items you have selected by clicking \"Done\", or use the select and deselect buttons to add or remove principals for whom you would like to view/assign permissions", "org.jasig.portal.security.IPerson", true, true, gmembers.toArray(new IGroupMember[0]));
                        }
                    }
                    ChannelRuntimeData servantRD = (ChannelRuntimeData)session.runtimeData.clone();
                    Enumeration srd = servantRD.keys();
                    while (srd.hasMoreElements()) {
                        servantRD.remove(srd.nextElement());
                    }
                    session.servant.setRuntimeData(servantRD);
                    session.view = "Select Principals";
                    break block17;
                }
                LogService.log(LogService.DEBUG, "PermissionsManager - using existing Servant");
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
    }

    protected void populateMembers(ArrayList gmembers, IAuthorizationPrincipal[] aps) {
        LogService.log(LogService.DEBUG, "PermissionsManager.PopulateMembers(): checking principal set of size" + aps.length);
        for (int a = 0; a < aps.length; ++a) {
            try {
                IGroupMember agm = AuthorizationService.instance().getGroupMember(aps[a]);
                LogService.log(LogService.DEBUG, "PermissionsManager.PopulateMembers(): checking whether " + agm.getType() + "." + agm.getKey() + " needs to be added");
                if (gmembers.contains(agm)) continue;
                gmembers.add(agm);
                continue;
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
    }

    protected void getGroupServantResults(PermissionsSessionData session) {
        try {
            LogService.log(LogService.DEBUG, "PermissionsManager - Getting servant results");
            Object[] results = session.servant.getResults();
            if (results != null && results.length > 0) {
                IAuthorizationPrincipal[] iap = new IAuthorizationPrincipal[results.length];
                for (int i = 0; i < results.length; ++i) {
                    IGroupMember gm = (IGroupMember)results[i];
                    iap[i] = AuthorizationService.instance().newPrincipal(gm);
                }
                session.principals = iap;
                LogService.log(LogService.DEBUG, "PermissionsManager - Getting rid of Servant");
                session.servant = null;
                PermissionsXML.populatePrincipals(session);
            } else {
                LogService.log(LogService.DEBUG, "PermissionsManager - Group Servant yielded no results, assuming abort and running Cancel");
                IPermissionCommand cmd = CommandFactory.get("Cancel");
                cmd.execute(session);
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public void receiveEvent(PortalEvent portalEvent) {
    }

    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    public void renderXML(ContentHandler out) {
        try {
            long time1 = Calendar.getInstance().getTime().getTime();
            if (this.session.view.equals("Select Principals") && this.session.isAuthorized) {
                try {
                    LogService.log(LogService.DEBUG, "PermissionsManager - Calling servant renderXML");
                    this.session.servant.renderXML(out);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "CPermissionsManager: failed to use servant" + e);
                }
            }
            if (!this.session.view.equals("Select Principals") || !this.session.isAuthorized) {
                long time2 = Calendar.getInstance().getTime().getTime();
                XSLT xslt = XSLT.getTransformer(this, this.session.runtimeData.getLocales());
                xslt.setXML(PermissionsXML.getViewDoc(this.session));
                xslt.setTarget(out);
                xslt.setStylesheetParameter("baseActionURL", this.session.runtimeData.getBaseActionURL());
                xslt.setStylesheetParameter("prmView", this.session.view);
                if (this.session.runtimeData.get("commandResponse") != null) {
                    xslt.setStylesheetParameter("commandResponse", this.session.runtimeData.getParameter("commandResponse"));
                }
                xslt.setXSL("CPermissionsManager.ssl", "CPermissions", this.session.runtimeData.getBrowserInfo());
                this.transform(xslt);
                long time3 = Calendar.getInstance().getTime().getTime();
                LogService.log(LogService.DEBUG, "CPermissionsManager timer: " + String.valueOf(time3 - time1) + " ms total, xsl took " + String.valueOf(time3 - time2) + " ms for view " + this.session.view);
                LogService.log(LogService.DEBUG, "CPermissionsManager timer: " + String.valueOf(time3 - this.session.startRD) + " since start RD");
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    protected void transform(XSLT xslt) {
        try {
            if (this.session.isAuthorized) {
                xslt.setStylesheetParameter("isAdminUser", "true");
            }
            xslt.transform();
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public void setStaticData(ChannelStaticData sD) {
        this.session = new PermissionsSessionData();
        this.session.staticData = sD;
        try {
            IEntityGroup admin = GroupService.getDistinguishedGroup("org.jasig.portal.security.IPerson.PortalAdministrators");
            IGroupMember me = AuthorizationService.instance().getGroupMember(this.session.staticData.getAuthorizationPrincipal());
            if (admin.deepContains(me)) {
                this.session.isAuthorized = true;
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        this.session.isFinished = false;
    }

    public ChannelCacheKey generateKey() {
        ChannelCacheKey cck;
        if (this.session.servant == null) {
            cck = new ChannelCacheKey();
            cck.setKey(this.session.staticData.getChannelPublishId() + "-" + this.session.staticData.getChannelSubscribeId() + "-" + String.valueOf(this.session.staticData.getPerson().getID()));
            cck.setKeyValidity(this.session.runtimeData.getParameter("prmView"));
            LogService.log(LogService.DEBUG, "CPermissionsManager.generateKey() : set validity to " + this.session.runtimeData.getParameter("prmView"));
        } else {
            cck = ((ICacheable)((Object)this.session.servant)).generateKey();
        }
        return cck;
    }

    public boolean isCacheValid(Object validity) {
        boolean valid = false;
        if (this.session.servant == null) {
            if (validity != null && validity.equals(this.session.runtimeData.getParameter("prmView")) && this.session.runtimeData.get("commandResponse") == null) {
                valid = true;
            }
            long time3 = Calendar.getInstance().getTime().getTime();
            LogService.log(LogService.DEBUG, "CPermissionsManager.isCacheValid() time since setRD: " + String.valueOf(time3 - this.session.startRD) + ", valid=" + valid);
        } else {
            valid = ((ICacheable)((Object)this.session.servant)).isCacheValid(validity);
        }
        return valid;
    }
}

