/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.webproxy;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.IMultithreadedChannel;
import org.jasig.portal.IMultithreadedMimeResponse;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.channels.webproxy.CWebProxyURLFilter;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.LocalConnectionContext;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.AbsoluteURLFilter;
import org.jasig.portal.utils.CookieCutter;
import org.jasig.portal.utils.DTDResolver;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.xml.sax.ContentHandler;

public class CWebProxy
implements IMultithreadedChannel,
IMultithreadedCacheable,
IMultithreadedMimeResponse {
    Map stateTable = Collections.synchronizedMap(new HashMap());
    static final String systemCacheId = "org.jasig.portal.channels.webproxy.CWebProxy";

    public void setStaticData(ChannelStaticData sd, String uid) {
        ChannelState state = new ChannelState();
        state.id = sd.getPerson().getID();
        state.iperson = sd.getPerson();
        state.person = sd.getParameter("cw_person");
        String personAllow = sd.getParameter("cw_personAllow");
        if (personAllow != null && !personAllow.trim().equals("")) {
            state.personAllow = personAllow;
        }
        if (state.personAllow != null && !state.personAllow.trim().equals("!*")) {
            state.personAllow_set = new HashSet();
            StringTokenizer st = new StringTokenizer(state.personAllow, ",");
            if (st != null) {
                while (st.hasMoreElements()) {
                    String pName = st.nextToken();
                    if (pName == null || (pName = pName.trim()).equals("")) continue;
                    state.personAllow_set.add(pName);
                }
            }
        }
        state.xmlUri = sd.getParameter("cw_xml");
        state.sslUri = sd.getParameter("cw_ssl");
        state.xslTitle = sd.getParameter("cw_xslTitle");
        state.xslUri = sd.getParameter("cw_xsl");
        state.fullxmlUri = sd.getParameter("cw_xml");
        state.passThrough = sd.getParameter("cw_passThrough");
        state.tidy = sd.getParameter("cw_tidy");
        state.infoUri = sd.getParameter("cw_info");
        state.helpUri = sd.getParameter("cw_help");
        state.editUri = sd.getParameter("cw_edit");
        state.key = state.xmlUri;
        String cacheMode = sd.getParameter("cw_cacheDefaultMode");
        if (cacheMode != null && !cacheMode.trim().equals("")) {
            state.cacheDefaultMode = cacheMode;
        }
        if ((cacheMode = sd.getParameter("cw_cacheMode")) != null && !cacheMode.trim().equals("")) {
            state.cacheMode = cacheMode;
        } else {
            state.cacheMode = state.cacheDefaultMode;
        }
        String cacheTimeout = sd.getParameter("cw_cacheDefaultTimeout");
        if (cacheTimeout != null && !cacheTimeout.trim().equals("")) {
            state.cacheDefaultTimeout = Long.parseLong(cacheTimeout);
        }
        if ((cacheTimeout = sd.getParameter("cw_cacheTimeout")) != null && !cacheTimeout.trim().equals("")) {
            state.cacheTimeout = Long.parseLong(cacheTimeout);
        } else {
            state.cacheTimeout = state.cacheDefaultTimeout;
        }
        String connContext = sd.getParameter("upc_localConnContext");
        if (connContext != null && !connContext.trim().equals("")) {
            try {
                state.localConnContext = (LocalConnectionContext)Class.forName(connContext).newInstance();
                state.localConnContext.init(sd);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "CWebProxy: Cannot initialize LocalConnectionContext: " + e);
            }
        }
        this.stateTable.put(uid, state);
    }

    public void setRuntimeData(ChannelRuntimeData rd, String uid) {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CWebProxy:setRuntimeData() : attempting to access a non-established channel! setStaticData() hasn't been called on uid=\"" + uid + "\"");
        } else {
            state.runtimeData = rd;
            if (rd.isEmpty() && state.refresh != -1) {
                if (state.buttonxmlUri != null) {
                    state.key = state.buttonxmlUri;
                    state.fullxmlUri = state.buttonxmlUri;
                    state.refresh = 0;
                } else {
                    if (state.refresh == 0) {
                        state.key = state.fullxmlUri;
                    }
                    state.fullxmlUri = state.xmlUri;
                    state.refresh = 1;
                }
            } else {
                String cacheMode;
                String cacheTimeout;
                String helpUri;
                String editUri;
                String infoUri;
                String tidy;
                String person;
                String passThrough;
                String xslUri;
                String xslTitle;
                String sslUri;
                state.refresh = 0;
                String xmlUri = state.runtimeData.getParameter("cw_xml");
                if (xmlUri != null) {
                    state.xmlUri = xmlUri;
                    state.buttonxmlUri = null;
                }
                if ((sslUri = state.runtimeData.getParameter("cw_ssl")) != null) {
                    state.sslUri = sslUri;
                }
                if ((xslTitle = state.runtimeData.getParameter("cw_xslTitle")) != null) {
                    state.xslTitle = xslTitle;
                }
                if ((xslUri = state.runtimeData.getParameter("cw_xsl")) != null) {
                    state.xslUri = xslUri;
                }
                if ((passThrough = state.runtimeData.getParameter("cw_passThrough")) != null) {
                    state.passThrough = passThrough;
                }
                if ((person = state.runtimeData.getParameter("cw_person")) != null) {
                    state.person = person;
                }
                if ((tidy = state.runtimeData.getParameter("cw_tidy")) != null) {
                    state.tidy = tidy;
                }
                if ((infoUri = state.runtimeData.getParameter("cw_info")) != null) {
                    state.infoUri = infoUri;
                }
                if ((editUri = state.runtimeData.getParameter("cw_edit")) != null) {
                    state.editUri = editUri;
                }
                if ((helpUri = state.runtimeData.getParameter("cw_help")) != null) {
                    state.helpUri = helpUri;
                }
                if ((cacheTimeout = state.runtimeData.getParameter("cw_cacheDefaultTimeout")) != null) {
                    state.cacheDefaultTimeout = Long.parseLong(cacheTimeout);
                }
                if ((cacheTimeout = state.runtimeData.getParameter("cw_cacheTimeout")) != null) {
                    state.cacheTimeout = Long.parseLong(cacheTimeout);
                } else {
                    state.cacheTimeout = state.cacheDefaultTimeout;
                }
                String cacheDefaultMode = state.runtimeData.getParameter("cw_cacheDefaultMode");
                if (cacheDefaultMode != null) {
                    state.cacheDefaultMode = cacheDefaultMode;
                }
                if ((cacheMode = state.runtimeData.getParameter("cw_cacheMode")) != null) {
                    state.cacheMode = cacheMode;
                } else {
                    state.cacheMode = state.cacheDefaultMode;
                }
                String reset = state.runtimeData.getParameter("cw_reset");
                if (reset != null && reset.equalsIgnoreCase("return")) {
                    state.buttonxmlUri = null;
                }
                if (state.buttonxmlUri != null) {
                    state.fullxmlUri = state.buttonxmlUri;
                } else {
                    StringTokenizer st;
                    StringBuffer newXML = new StringBuffer();
                    String appendchar = "";
                    if (state.person != null && state.personAllow_set != null && (st = new StringTokenizer(state.person, ",")) != null) {
                        while (st.hasMoreElements()) {
                            String pName = st.nextToken();
                            if (pName == null || pName.trim().equals("")) continue;
                            if (state.personAllow.trim().equals("*") || state.personAllow_set.contains(pName)) {
                                newXML.append(appendchar);
                                appendchar = "&";
                                newXML.append(pName);
                                newXML.append("=");
                                String pVal = (String)state.iperson.getAttribute(pName);
                                if (pVal == null) continue;
                                newXML.append(URLEncoder.encode(pVal));
                                continue;
                            }
                            LogService.log(LogService.INFO, "CWebProxy: request to pass " + pName + " denied.");
                        }
                    }
                    if (state.passThrough != null && !state.passThrough.equalsIgnoreCase("none") && (state.passThrough.equalsIgnoreCase("all") || state.passThrough.equalsIgnoreCase("application") || rd.getParameter("cw_inChannelLink") != null)) {
                        String keywords = rd.getKeywords();
                        if (keywords != null) {
                            if (appendchar.equals("&")) {
                                newXML.append("&keywords=" + keywords);
                            } else {
                                newXML.append(keywords);
                            }
                        } else {
                            Enumeration e = rd.getParameterNames();
                            if (e != null) {
                                while (e.hasMoreElements()) {
                                    String pName = (String)e.nextElement();
                                    if (pName.startsWith("cw_") || pName.startsWith("upc_") || pName.trim().equals("")) continue;
                                    String[] value_array = rd.getParameterValues(pName);
                                    int i = 0;
                                    while (i < value_array.length) {
                                        newXML.append(appendchar);
                                        appendchar = "&";
                                        newXML.append(pName);
                                        newXML.append("=");
                                        newXML.append(URLEncoder.encode(value_array[i++].trim()));
                                    }
                                }
                            }
                        }
                    }
                    state.reqParameters = newXML.toString();
                    state.fullxmlUri = state.xmlUri;
                    if (!state.runtimeData.getHttpRequestMethod().equals("POST")) {
                        if (state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                            appendchar = state.xmlUri.indexOf(63) == -1 ? "?" : "&";
                            state.fullxmlUri = state.fullxmlUri + appendchar + state.reqParameters;
                        }
                        state.reqParameters = null;
                    }
                }
                if (!state.runtimeData.getHttpRequestMethod().equals("POST")) {
                    state.key = state.fullxmlUri;
                } else {
                    state.key = String.valueOf(new Date().getTime());
                }
            }
        }
    }

    public void receiveEvent(PortalEvent ev, String uid) {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CWebProxy:receiveEvent() : attempting to access a non-established channel! setStaticData() hasn't been called on uid=\"" + uid + "\"");
        } else {
            int evnum = ev.getEventNumber();
            switch (evnum) {
                case 3: {
                    if (state.editUri == null) break;
                    state.buttonxmlUri = state.editUri;
                    break;
                }
                case 4: {
                    if (state.helpUri == null) break;
                    state.buttonxmlUri = state.helpUri;
                    break;
                }
                case 5: {
                    if (state.infoUri == null) break;
                    state.buttonxmlUri = state.infoUri;
                    break;
                }
                case 1: {
                    this.stateTable.remove(uid);
                    break;
                }
            }
        }
    }

    public ChannelRuntimeProperties getRuntimeProperties(String uid) {
        ChannelRuntimeProperties rp = new ChannelRuntimeProperties();
        if (this.stateTable.get(uid) == null) {
            rp.setWillRender(false);
            LogService.log(LogService.ERROR, "CWebProxy:getRuntimeProperties() : attempting to access a non-established channel! setStaticData() hasn't been called on uid=\"" + uid + "\"");
        }
        return rp;
    }

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CWebProxy:renderXML() : attempting to access a non-established channel! setStaticData() hasn't been called on uid=\"" + uid + "\"");
        } else {
            Document xml = null;
            String tidiedXml = null;
            try {
                if (state.tidy != null && state.tidy.equals("on")) {
                    tidiedXml = this.getTidiedXml(state.fullxmlUri, state);
                } else {
                    xml = this.getXml(state.fullxmlUri, state);
                }
            }
            catch (Exception e) {
                throw new GeneralRenderingException("Problem retrieving contents of " + state.fullxmlUri + ".  Please restart channel. ", e, false, true);
            }
            state.runtimeData.put("baseActionURL", state.runtimeData.getBaseActionURL());
            state.runtimeData.put("downloadActionURL", state.runtimeData.getBaseWorkerURL("download"));
            if (state.xmlUri != null) {
                state.runtimeData.put("cw_xml", state.xmlUri);
            }
            if (state.sslUri != null) {
                state.runtimeData.put("cw_ssl", state.sslUri);
            }
            if (state.xslTitle != null) {
                state.runtimeData.put("cw_xslTitle", state.xslTitle);
            }
            if (state.xslUri != null) {
                state.runtimeData.put("cw_xsl", state.xslUri);
            }
            if (state.passThrough != null) {
                state.runtimeData.put("cw_passThrough", state.passThrough);
            }
            if (state.tidy != null) {
                state.runtimeData.put("cw_tidy", state.tidy);
            }
            if (state.infoUri != null) {
                state.runtimeData.put("cw_info", state.infoUri);
            }
            if (state.helpUri != null) {
                state.runtimeData.put("cw_help", state.helpUri);
            }
            if (state.editUri != null) {
                state.runtimeData.put("cw_edit", state.editUri);
            }
            if (state.person != null) {
                state.runtimeData.put("cw_person", state.person);
            }
            if (state.personAllow != null) {
                state.runtimeData.put("cw_personAllow", state.personAllow);
            }
            XSLT xslt = XSLT.getTransformer(this, state.runtimeData.getLocales());
            if (tidiedXml != null) {
                xslt.setXML(tidiedXml);
            } else {
                xslt.setXML(xml);
            }
            if (state.xslUri != null && !state.xslUri.trim().equals("")) {
                xslt.setXSL(state.xslUri);
            } else {
                xslt.setXSL(state.sslUri, state.xslTitle, state.runtimeData.getBrowserInfo());
            }
            MediaManager mm = new MediaManager();
            String media = mm.getMedia(state.runtimeData.getBrowserInfo());
            String mimeType = mm.getReturnMimeType(media);
            CWebProxyURLFilter filter2 = CWebProxyURLFilter.newCWebProxyURLFilter(mimeType, state.runtimeData, out);
            AbsoluteURLFilter filter1 = AbsoluteURLFilter.newAbsoluteURLFilter(mimeType, state.xmlUri, filter2);
            xslt.setTarget(filter1);
            xslt.setStylesheetParameters(state.runtimeData);
            xslt.transform();
        }
    }

    private Document getXml(String uri, ChannelState state) throws Exception {
        URLConnection urlConnect = this.getConnection(uri, state);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        DTDResolver dtdResolver = new DTDResolver();
        docBuilder.setEntityResolver(dtdResolver);
        return docBuilder.parse(urlConnect.getInputStream());
    }

    private String getTidiedXml(String uri, ChannelState state) throws Exception {
        PrintWriter pw;
        int i;
        URLConnection urlConnect = this.getConnection(uri, state);
        String encoding = null;
        String ct = urlConnect.getContentType();
        if (ct != null && (i = ct.indexOf("charset=")) != -1) {
            encoding = ct.substring(i + 8).trim();
            if ((i = encoding.indexOf(";")) != -1) {
                encoding = encoding.substring(0, i).trim();
            }
            if (encoding.indexOf("\"") != -1) {
                encoding = encoding.substring(1, encoding.length() + 1);
            }
        }
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setDocType("omit");
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setNumEntities(true);
        tidy.setWord2000(true);
        if (encoding != null) {
            if (encoding.toLowerCase().equals("iso-8859-1")) {
                tidy.setCharEncoding(2);
            } else if (encoding.toLowerCase().equals("iso-2022-jp")) {
                tidy.setCharEncoding(4);
            } else {
                tidy.setCharEncoding(3);
            }
        } else {
            tidy.setCharEncoding(3);
        }
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            pw = new PrintWriter(new FileOutputStream("nul"));
            tidy.setErrout(pw);
        } else {
            pw = new PrintWriter(new FileOutputStream("/dev/null"));
            tidy.setErrout(pw);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
        BufferedOutputStream out = new BufferedOutputStream(stream);
        tidy.parse(urlConnect.getInputStream(), (OutputStream)out);
        pw.close();
        String tidiedXml = stream.toString();
        stream.close();
        out.close();
        if (tidy.getParseErrors() > 0) {
            throw new GeneralRenderingException("Unable to convert input document to XHTML");
        }
        return tidiedXml;
    }

    private URLConnection getConnection(String uri, ChannelState state) throws Exception {
        if ((uri = uri.trim()).indexOf(" ") != -1) {
            int i;
            StringBuffer sbuff = new StringBuffer();
            while ((i = uri.indexOf(" ")) != -1) {
                sbuff.append(uri.substring(0, i));
                sbuff.append("%20");
                uri = uri.substring(i + 1);
            }
            sbuff.append(uri);
            uri = sbuff.toString();
        }
        URL url = state.localConnContext != null ? ResourceLoader.getResourceAsURL(this.getClass(), state.localConnContext.getDescriptor(uri, state.runtimeData)) : ResourceLoader.getResourceAsURL(this.getClass(), uri);
        String domain = url.getHost().trim();
        String path = url.getPath();
        if (path.indexOf("/") != -1 && path.lastIndexOf("/") != 0) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        String port = Integer.toString(url.getPort());
        URLConnection urlConnect = url.openConnection();
        String protocol = url.getProtocol();
        if ((protocol.equals("http") || protocol.equals("https")) && domain != null && path != null) {
            HttpURLConnection httpUrlConnect = (HttpURLConnection)urlConnect;
            httpUrlConnect.setInstanceFollowRedirects(false);
            if (state.cookieCutter.cookiesExist()) {
                state.cookieCutter.sendCookieHeader(httpUrlConnect, domain, path, port);
            }
            if (state.runtimeData.getHttpRequestMethod().equals("POST") && state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                httpUrlConnect.setRequestMethod("POST");
                httpUrlConnect.setAllowUserInteraction(false);
                httpUrlConnect.setDoOutput(true);
            }
            if (state.localConnContext != null) {
                try {
                    state.localConnContext.sendLocalData(httpUrlConnect, state.runtimeData);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "CWebProxy: Unable to send data through " + state.runtimeData.getParameter("upc_localConnContext") + ": " + e.getMessage());
                }
            }
            if (state.runtimeData.getHttpRequestMethod().equals("POST") && state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                PrintWriter post = new PrintWriter(httpUrlConnect.getOutputStream());
                post.print(state.reqParameters);
                post.flush();
                post.close();
                state.reqParameters = null;
            }
            state.cookieCutter.storeCookieHeader(httpUrlConnect, domain, path, port);
            int status = httpUrlConnect.getResponseCode();
            String location = httpUrlConnect.getHeaderField("Location");
            switch (status) {
                case 404: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 404: Not Found");
                }
                case 403: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 403: Forbidden");
                }
                case 500: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 500: Internal Server Error");
                }
                case 204: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 204: No Content");
                }
                case 302: {
                    httpUrlConnect.disconnect();
                    httpUrlConnect = (HttpURLConnection)this.getConnection(location, state);
                    break;
                }
                case 303: {
                    httpUrlConnect.disconnect();
                    httpUrlConnect = (HttpURLConnection)this.getConnection(location, state);
                    break;
                }
                case 301: {
                    if (state.runtimeData.getHttpRequestMethod().equals("GET")) {
                        httpUrlConnect.disconnect();
                        httpUrlConnect = (HttpURLConnection)this.getConnection(location, state);
                        break;
                    }
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 301: POST Redirection currently not supported");
                }
            }
            return httpUrlConnect;
        }
        return urlConnect;
    }

    public ChannelCacheKey generateKey(String uid) {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CWebProxy:generateKey() : attempting to access a non-established channel! setStaticData() hasn't been called on uid=\"" + uid + "\"");
            return null;
        }
        if (state.cacheMode.equalsIgnoreCase("none")) {
            return null;
        }
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        k.setKeyScope(0);
        sbKey.append("sslUri:").append(state.sslUri).append(", ");
        String xslUriForKey = state.xslUri;
        try {
            if (xslUriForKey == null) {
                String sslUri = ResourceLoader.getResourceAsURLString(this.getClass(), state.sslUri);
                xslUriForKey = XSLT.getStylesheetURI(sslUri, state.runtimeData.getBrowserInfo());
            }
        }
        catch (Exception e) {
            xslUriForKey = "Not attainable: " + e;
        }
        sbKey.append("xslUri:").append(xslUriForKey).append(", ");
        sbKey.append("key:").append(state.key).append(", ");
        sbKey.append("passThrough:").append(state.passThrough).append(", ");
        sbKey.append("tidy:").append(state.tidy).append(", ");
        sbKey.append("person:").append(state.person);
        k.setKey(sbKey.toString());
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    public boolean isCacheValid(Object validity, String uid) {
        if (!(validity instanceof Long)) {
            return false;
        }
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CWebProxy:isCacheValid() : attempting to access a non-established channel! setStaticData() hasn't been called on uid=\"" + uid + "\"");
            return false;
        }
        return System.currentTimeMillis() - (Long)validity < state.cacheTimeout * 1000L;
    }

    public String getContentType(String uid) {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        return state.connHolder.getContentType();
    }

    public InputStream getInputStream(String uid) throws IOException {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        InputStream rs = state.connHolder.getInputStream();
        state.connHolder = null;
        return rs;
    }

    public void downloadData(OutputStream out, String uid) throws IOException {
        throw new IOException("CWebProxy: donloadData method not supported - use getInputStream only");
    }

    public String getName(String uid) {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        return "proxyDL";
    }

    public Map getHeaders(String uid) {
        ChannelState state = (ChannelState)this.stateTable.get(uid);
        try {
            state.connHolder = this.getConnection(state.fullxmlUri, state);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        HashMap<String, String> rhdrs = new HashMap<String, String>();
        int i = 0;
        while (state.connHolder.getHeaderFieldKey(i) != null) {
            rhdrs.put(state.connHolder.getHeaderFieldKey(i), state.connHolder.getHeaderField(i));
            ++i;
        }
        return rhdrs;
    }

    public void reportDownloadError(Exception e) {
        LogService.log(LogService.ERROR, "CWebProxy::reportDownloadError(): " + e.getMessage());
    }

    private class ChannelState {
        private int id = 0;
        private IPerson iperson = null;
        private String person;
        private String personAllow;
        private HashSet personAllow_set;
        private String fullxmlUri = null;
        private String buttonxmlUri = null;
        private String xmlUri = null;
        private String key = null;
        private String passThrough = null;
        private String tidy = null;
        private String sslUri = null;
        private String xslTitle = null;
        private String xslUri = null;
        private String infoUri = null;
        private String helpUri = null;
        private String editUri = null;
        private String cacheDefaultMode;
        private String cacheMode = null;
        private String reqParameters;
        private long cacheDefaultTimeout;
        private long cacheTimeout = this.cacheDefaultTimeout = PropertiesManager.getPropertyAsLong("org.jasig.portal.channels.webproxy.CWebProxy.cache_default_timeout");
        private ChannelRuntimeData runtimeData = null;
        private CookieCutter cookieCutter;
        private URLConnection connHolder;
        private LocalConnectionContext localConnContext = null;
        private int refresh = -1;

        public ChannelState() {
            this.cacheMode = this.cacheDefaultMode = PropertiesManager.getProperty("org.jasig.portal.channels.webproxy.CWebProxy.cache_default_mode");
            this.personAllow = PropertiesManager.getProperty("org.jasig.portal.channels.webproxy.CWebProxy.person_allow");
            this.cookieCutter = new CookieCutter();
        }
    }
}

