/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.sql.Timestamp;
import java.util.Map;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCache;
import org.jasig.portal.concurrency.caching.LRUCache;
import org.jasig.portal.services.LogService;

public class ReferenceEntityCache
implements IEntityCache {
    protected Map cache;
    protected Class entityType;
    protected String simpleTypeName;
    protected static int threadID = 0;
    protected int sweepIntervalMillis = 60000;
    protected Thread cleanupThread = null;

    public ReferenceEntityCache(Class type, int maxSize, int maxUnusedTime, int sweepInterval) throws CachingException {
        this.initializeEntityType(type);
        this.entityType = type;
        this.sweepIntervalMillis = sweepInterval;
        this.setCache(new LRUCache(maxSize, maxUnusedTime));
        String threadName = "uPortal ReferenceEntityCache sweeper thread #" + ++threadID;
        this.cleanupThread = new Thread((Runnable)new CacheSweeper(), threadName);
        this.cleanupThread.start();
    }

    public void add(IBasicEntity entity) throws CachingException {
        if (!this.getEntityType().isAssignableFrom(entity.getEntityIdentifier().getType())) {
            throw new CachingException("Problem adding " + entity + ": entity type is incompatible with cache.");
        }
        this.getCache().put(entity.getEntityIdentifier().getKey(), entity);
    }

    private void initializeEntityType(Class type) throws CachingException {
        try {
            EntityTypes.addIfNecessary(type, "Added by ReferenceEntityCache");
        }
        catch (Exception ex) {
            throw new CachingException("Problem adding entity type " + type + " : " + ex.getMessage());
        }
    }

    public void cleanupCache() {
        int before = this.size();
        this.debug("ENTERING ReferenceEntityCache.cleanupCache() for " + this.getSimpleTypeName() + " : number of entries: " + before);
        ((LRUCache)this.getCache()).sweepCache();
        this.debug("LEAVING ReferenceEntityCache.cleanupCache() for " + this.getSimpleTypeName() + " : removed " + (before - this.size()) + " cache entries.");
    }

    public void clearCache() {
        this.getCache().clear();
    }

    void debug(String msg) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        LogService.log(LogService.DEBUG, ts + " : " + msg);
    }

    public IBasicEntity get(String key) {
        return (IBasicEntity)this.getCache().get(key);
    }

    protected Map getCache() {
        return this.cache;
    }

    public final Class getEntityType() {
        return this.entityType;
    }

    public void remove(String key) throws CachingException {
        this.cache.remove(key);
    }

    protected void setCache(Map newCache) {
        this.cache = newCache;
    }

    public int size() {
        return this.getCache().size();
    }

    public String toString() {
        return "ReferenceEntityCache for " + this.getSimpleTypeName();
    }

    private String getSimpleTypeName() {
        if (this.simpleTypeName == null) {
            String name = this.getEntityType().getName();
            while (name.indexOf(46) >= 0) {
                name = name.substring(name.indexOf(46) + 1);
            }
            this.simpleTypeName = name;
        }
        return this.simpleTypeName;
    }

    public void update(IBasicEntity entity) throws CachingException {
        this.add(entity);
    }

    protected class CacheSweeper
    implements Runnable {
        protected CacheSweeper() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(ReferenceEntityCache.this.sweepIntervalMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ReferenceEntityCache.this.cleanupCache();
            }
        }
    }
}

