/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupConstants;

public class CompositeEntityIdentifier
extends EntityIdentifier
implements IGroupConstants {
    protected static Properties props = new Properties();
    protected static String separator;
    protected Name compositeKey;

    public CompositeEntityIdentifier(String entityKey, Class entityType) throws GroupsException {
        super(entityKey, entityType);
        try {
            this.compositeKey = CompositeEntityIdentifier.getParser().parse(entityKey);
        }
        catch (NamingException ne) {
            throw new GroupsException("Error in group key: " + ne.getMessage());
        }
    }

    protected Name getCompositeKey() {
        return this.compositeKey;
    }

    public String getKey() {
        return this.getCompositeKey().toString();
    }

    public String getLocalKey() {
        return this.getCompositeKey().get(this.size() - 1).toString();
    }

    protected static NameParser getParser() {
        return new NameParser(){

            public Name parse(String s) throws InvalidNameException {
                int start = 0;
                int separatorLength = separator.length();
                int end = s.indexOf(separator, start);
                Name name = CompositeEntityIdentifier.newCompoundName();
                while (end != -1) {
                    name.add(s.substring(start, end));
                    start = end + separatorLength;
                    end = s.indexOf(separator, start);
                }
                return name.add(s.substring(start));
            }
        };
    }

    public Name getServiceName() {
        return this.size() < 2 ? null : this.getCompositeKey().getPrefix(this.size() - 1);
    }

    public static Name newCompoundName() throws InvalidNameException {
        return new CompoundName("", props);
    }

    public String popNode() throws InvalidNameException {
        return (String)this.getCompositeKey().remove(0);
    }

    public Name pushNode(String newNode) throws InvalidNameException {
        return this.getCompositeKey().add(0, newNode);
    }

    public void setCompositeKey(Name newCompositeKey) {
        this.compositeKey = newCompositeKey;
    }

    public void setServiceName(Name newServiceName) throws InvalidNameException {
        Name newKey = CompositeEntityIdentifier.newCompoundName().addAll(newServiceName).add(this.getLocalKey());
        this.setCompositeKey(newKey);
    }

    protected int size() {
        return this.getCompositeKey().size();
    }

    public String toString() {
        return "CompositeEntityIdentifier (" + this.type + "(" + this.getKey() + "))";
    }

    public static Name parseCompoundKey(String key) throws NamingException {
        return CompositeEntityIdentifier.getParser().parse(key);
    }

    static {
        try {
            separator = GroupServiceConfiguration.getConfiguration().getNodeSeparator();
        }
        catch (Exception ex) {
            separator = ".";
        }
        props.put("jndi.syntax.separator", separator);
        props.put("jndi.syntax.direction", "left_to_right");
    }
}

