/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.restrictions;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.restrictions.DepthRestriction;
import org.jasig.portal.layout.restrictions.GroupRestriction;
import org.jasig.portal.layout.restrictions.HiddenRestriction;
import org.jasig.portal.layout.restrictions.IUserLayoutRestriction;
import org.jasig.portal.layout.restrictions.ImmutableRestriction;
import org.jasig.portal.layout.restrictions.PriorityRestriction;
import org.jasig.portal.layout.restrictions.UnremovableRestriction;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;

public class UserLayoutRestrictionFactory {
    public static IUserLayoutRestriction createRestriction(int restrictionType, String restrictionValue, String restrictionPath) throws PortalException {
        UserLayoutRestriction restriction = null;
        switch (restrictionType) {
            case 2: {
                restriction = new DepthRestriction(restrictionPath);
                break;
            }
            case 4: {
                restriction = new GroupRestriction(restrictionPath);
                break;
            }
            case 32: {
                restriction = new HiddenRestriction(restrictionPath);
                break;
            }
            case 8: {
                restriction = new ImmutableRestriction(restrictionPath);
                break;
            }
            case 1: {
                restriction = new PriorityRestriction(restrictionPath);
                break;
            }
            case 16: {
                restriction = new UnremovableRestriction(restrictionPath);
                break;
            }
            default: {
                restriction = new UnremovableRestriction(restrictionPath);
            }
        }
        restriction.setRestrictionExpression(restrictionValue);
        return restriction;
    }
}

