/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IAuthorizationServiceFactory;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.services.LogService;

public class AuthorizationService {
    private static AuthorizationService m_instance;
    protected IAuthorizationService m_authorization = m_Factory.getAuthorization();
    protected static String s_factoryName;
    protected static IAuthorizationServiceFactory m_Factory;
    static /* synthetic */ Class class$org$jasig$portal$services$AuthorizationService;

    private AuthorizationService() throws AuthorizationException {
    }

    public IGroupMember getGroupMember(IAuthorizationPrincipal principal) throws GroupsException {
        return this.m_authorization.getGroupMember(principal);
    }

    public static final synchronized AuthorizationService instance() throws AuthorizationException {
        if (m_instance == null) {
            m_instance = new AuthorizationService();
        }
        return m_instance;
    }

    public IPermissionManager newPermissionManager(String owner) throws AuthorizationException {
        return this.m_authorization.newPermissionManager(owner);
    }

    public IAuthorizationPrincipal newPrincipal(String key, Class type) throws AuthorizationException {
        return this.m_authorization.newPrincipal(key, type);
    }

    public IAuthorizationPrincipal newPrincipal(IGroupMember groupMember) throws GroupsException {
        return this.m_authorization.newPrincipal(groupMember);
    }

    public IAuthorizationPrincipal newPrincipal(IPermission permission) throws AuthorizationException {
        return this.m_authorization.getPrincipal(permission);
    }

    public IUpdatingPermissionManager newUpdatingPermissionManager(String owner) throws AuthorizationException {
        return this.m_authorization.newUpdatingPermissionManager(owner);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_factoryName = null;
        m_Factory = null;
        InputStream secprops = (class$org$jasig$portal$services$AuthorizationService == null ? (class$org$jasig$portal$services$AuthorizationService = AuthorizationService.class$("org.jasig.portal.services.AuthorizationService")) : class$org$jasig$portal$services$AuthorizationService).getResourceAsStream("/properties/security.properties");
        Properties pr = new Properties();
        try {
            pr.load(secprops);
            secprops.close();
            s_factoryName = pr.getProperty("authorizationProvider");
            if (s_factoryName == null) {
                LogService.log(LogService.ERROR, new PortalSecurityException("AuthorizationProvider not specified or incorrect in security.properties"));
            } else {
                try {
                    m_Factory = (IAuthorizationServiceFactory)Class.forName(s_factoryName).newInstance();
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, new PortalSecurityException("Failed to instantiate " + s_factoryName));
                }
            }
        }
        catch (IOException e) {
            LogService.log(LogService.ERROR, new PortalSecurityException(e.getMessage()));
        }
    }
}

