/*
 * Created on 31 janv. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.cocoon.actions;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.rmi.ServerException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;


import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.methods.DepthSupport;
import org.injac.utils.WebdavConnection;
import org.w3c.dom.Element;

import org.injac.utils.*;

/**
 * @author shoam
 * 
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class DisplayFileAction extends InjacAction {

	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(DisplayFileAction.class);

	/**
	 * Connection with session management
	 * 
	 * @uml.property name="webdavConnection"
	 * @uml.associationEnd multiplicity="(0 1)"
	 */
	private WebdavConnection webdavConnection;

	
	/**
	 *  space + doc path 
	 */
	private String path;
	/**
	 * file name
	 */
	private String file;
	/**
	 * root node ex : /slide/file/injacRoot
	 */
	private String rootpath;
	/**
	 * Credentials
	 */
	private String login;
	private String password;
	
	private String injacType=null;
	private String rootdocname=null;
	private String rootfilename=null;
	/**
	 * Boolean for bypass check
	 */
	private boolean noCheck=false;
	/**
	 * Vector with requested MD name
	 */
	private Vector mdVector;
	
	
	
	/**
	 * Action testant les MD passs dans le paramtre reqparams selon la rgle suivante :
	 * - md1 : injac-type
	 * - md2 : root-doc-name
	 * - md3 : root-file-name
	 */
	public Map act (Redirector redirector, 
            SourceResolver resolver, 
            Map objectModel, 
            String source, 
            Parameters params) throws Exception{
		
		String reqparams;

		Map sitemapParams = new HashMap();
		mdVector = new Vector();
		webdavConnection = new WebdavConnection(objectModel);
		try {
			webdavpath= (String)params.getParameter("webdav-path");		
			int index = webdavpath.indexOf("/slide/");
			// no slide context case
			if(index==-1)
				index = webdavpath.indexOf("/files");
			
			rootpath = webdavpath.substring(index);
			
			//rootpath = webdavpath.substring(webdavpath.indexOf("/slide"));
			
			
			path= (String)params.getParameter("path");
			if(path.equals("/"))
				path="";
			path = checkRootInPath(path);
			file= (String)params.getParameter("file");
			try {
				reqparams=(String)params.getParameter("reqparams");
				// parsing des MD demands
				logger.debug("reqparams: "+reqparams);
            	if(reqparams.equals(""))
            	{
            		// MD par dfaut
    				logger.debug("reqparams: vide");
                	mdVector.add("D:injac-type");
                    mdVector.add("D:root-doc-name");
                    mdVector.add("D:root-file-name");
            	}else
            	{
            		for(StringTokenizer ST = new StringTokenizer(reqparams, " ");ST.hasMoreTokens(); )
            		{
            			mdVector.add(ST.nextToken());
            		}
            	}
				
			}catch(ParameterException pe)
			{
				// MD par dfaut
				logger.debug("reqparams: null");
				mdVector.add("D:injac-type");
                mdVector.add("D:root-file-name");
                mdVector.add("D:root-doc-name");
			}
			// Rcupration des credentials
			try {
				login=(String)params.getParameter("login");
				password=(String)params.getParameter("password");
			}
			catch(Exception e)
			{
				login=null;
				password=null;
			}
//			param to bypass validation check
			try {
				String nocheckStr=(String)params.getParameter("nocheck");
				logger.debug("nocheck :["+nocheckStr+"]");
				noCheck = nocheckStr.equals("true");
				
			}
			catch(Exception e)
			{
				noCheck=false;
			}
			logger.debug("DisplayFileAction::Act params : \t-path : "+path+"\t-file : "+file);
			if(webdavpath != null)
			{
				logger.debug("connecting to webdav-path : "+webdavpath);
				connect(webdavpath);
               	logger.debug("DisplayFileAction::Act : connection ressource : "+webdavpath+ " okay");
			}
			else
			{
				String msg = "DisplayFileAction::act : pas de chemin pass en argument.\n parma manquant : webdav-path";
				logger.error(msg);
				throw new Exception(msg);
			}
			
		} catch (Exception e) {

			throw new Exception("DisplayFileAction::act : problme de paramtres.\n webdavpath :"+webdavpath+"\nlogin: "+login, e);
		}
		buildResponse(sitemapParams);
		logger.debug("DisplayFileAction::Act : connection ressource : "+webdavpath+ " ok");
		logger.debug("return value :"+sitemapParams); 
		if(sitemapParams.isEmpty())
			return null;
		return sitemapParams;
	}
	/** Warning : no prefix are set, just namespaces  
	 * 
	 * @param prop
	 * @param sitemapParams
	 */
	void parseProperty(Property prop)
	{
		Element el=prop.getElement();
		String tagname =el.getNodeName();
		// get value for the prop
		String value="";
		if(el.hasChildNodes())
			value=el.getFirstChild().getNodeValue();
		
		String mapname=tagname.substring(tagname.indexOf(":")+1);
		// test of injac-type
		if(mapname.equals(((String)mdVector.elementAt(0)).substring(((String)mdVector.elementAt(0)).indexOf(":")+1)))
			injacType=value;
		// case of a space 
		if(mapname.equals(((String)mdVector.elementAt(1)).substring(((String)mdVector.elementAt(1)).indexOf(":")+1)))
			rootdocname=value;
		// case of a document
		if(mapname.equals(((String)mdVector.elementAt(2)).substring(((String)mdVector.elementAt(2)).indexOf(":")+1)))
			rootfilename=value;
		logger.debug("tagname : "+tagname+" mapname : "+mapname+" value : "+value);
			
	}
	
	public void buildResponse(Map sitemapParams)throws Exception
	{
		Enumeration resp_enum=null;
	    
        Enumeration md = getProperty(path,mdVector);
        logger.debug("DisplayFileAction::buildResponse : PropFind methode ok");
        logger.debug("enum 1 count:"+md.toString());
		try
		{
			int i=0;
			           
			while(md.hasMoreElements())
			{
				Object resp_element =md.nextElement();
				logger.debug("class resp_element : "+resp_element.getClass()+" resp_element.toString : "+resp_element.toString());
				if(resp_element.getClass().getName().equals("org.apache.webdav.lib.BaseProperty"))
				{
					org.apache.webdav.lib.BaseProperty prop = (org.apache.webdav.lib.BaseProperty)resp_element;
					logger.debug("property : "+prop.getName());
					logger.debug("--> : "+prop);
					parseProperty(prop);
					logger.debug("parseProperty ok");
				}
				i++;
            }
			logger.debug("DisplayFileAction::buildresponse: injacType : "+ injacType+"\nrootdocname :"+rootdocname+"\nrootfilename :"+rootfilename);
			// 1. space
			if(injacType.equals("space"))
			{
				if(rootdocname.equals(""))
				{
//					1.1 space with non doc
					sitemapParams.put("file", "void.xml");
					sitemapParams.put("filepath", "");
				}
				else
				{
//					1.2 space with default doc 
					//test if doc is published
					if(CheckDocPublished(rootdocname))
					{
						fetchRootFileName(path+"/"+rootdocname);
						sitemapParams.put("file", rootfilename);
						sitemapParams.put("filepath", path+"/"+rootdocname);
						// add the doc path to sitemap
						sitemapParams.put("root-doc", "/"+rootdocname);
					}
					else
					{
						sitemapParams.put("file", "error-unpublished-doc.xml");
						sitemapParams.put("filepath", "");
					}
					
				}
			}
			// 2. document
			else if(injacType.equals("document"))
			{
				if(CheckDocPublished(""))
				{	
					// 2.1 a file is specified
					if((file !=null) && (!file.equals("")))
					{
						sitemapParams.put("file", file);
						sitemapParams.put("filepath", path);
					}
				// 	2.2 ... we take default file
					else
					{
						fetchRootFileName(path);
						sitemapParams.put("file", rootfilename);
						sitemapParams.put("filepath", path);
					}
				}
				else {
					sitemapParams.put("file", "error-unpublished-doc.xml");
					sitemapParams.put("filepath", "");
					
				}
					
			}
			
			// no file to render as document
			if(sitemapParams.isEmpty())
			{
				sitemapParams.put("file", "void.xml");
				sitemapParams.put("filepath", "");
			}
			
			logger.debug("DisplayFileAction::buildresponse: sitemapParams : "+ sitemapParams);
            logger.debug("nombre d'enum de premier niveau : "+i);
		}catch (Exception e) {
			
			throw new Exception("DisplayFileAction::buildResponse : impossible de retrouver les mtadonnes.\n webdavpath :"+webdavpath, e);
		}
	}
	/**
	 * fetch file-root-name of doc	 
	 * @throws URIException, IOException
	 */	
	private void fetchRootFileName(String docpath)throws URIException, IOException 
	{
		Vector rootv = new Vector();
		rootv.add(mdVector.elementAt(2));
		Enumeration md = getProperty(docpath, rootv);
		if(md.hasMoreElements())
		{	
			org.apache.webdav.lib.BaseProperty prop = (org.apache.webdav.lib.BaseProperty)md.nextElement();
			parseProperty(prop);
			if(rootfilename.equals(""))
			{
				setDefaultRootFileName(docpath);
			}
			logger.debug("DisplayFileAction::fetchRootFileName: root-file-name("+docpath+") :"+rootfilename+"\nprop :"+prop);
			
		}
		else
		{	
			logger.debug("DisplayFileAction::fetchRootFileName: no root-file-name for doc :"+docpath+"\n--->  taking root-doc-name as file name.");
			setDefaultRootFileName(docpath);
		}	
	}
	private void setDefaultRootFileName(String docpath){
		int slash = docpath.substring(1).lastIndexOf("/");
		if(slash!=-1)
			rootfilename=docpath.substring(1).substring(slash+1);
		else
		{
			rootfilename=docpath.substring(1);
		}
	}
	private boolean CheckDocPublished(String docname)
	{
		if(noCheck)
			return true;
		boolean result=true;
		boolean published = false;
		boolean checkdate = false;
		String begin="";
		String end="";
		
		try
		{
			logger.debug("CheckDoc : " + rootpath+path+"/"+docname);
			Enumeration md;
			if(docname.equals(""))
				md= webdavConnection.getProperties(rootpath+path, 0);
			else
				md= webdavConnection.getProperties(rootpath+path+"/"+docname, 0);
			while(md.hasMoreElements())
			{
				BaseProperty prop = (BaseProperty)md.nextElement();
				Element el=prop.getElement();
				String tagname =el.getNodeName();
				String value="";
				if(el.hasChildNodes())
					value=el.getFirstChild().getNodeValue();
				String mapname=tagname.substring(tagname.indexOf(":")+1);

//			  publication validity 
				if(mapname.equals("document-state"))
				{
					published= value.equals("published");
					logger.debug("document-state : "+  value);
				}
				if(mapname.equals("publication-date-begin"))
				{
					if(!value.equals(""))
						begin = value;
					logger.debug("publication-date-begin : "+  value);
					
				}
				if(mapname.equals("publication-date-end"))
				{
					if(!value.equals(""))
						end = value;
					logger.debug("publication-date-end : "+  value);
				}
				
			}
			checkdate = DateChecker.checkDate(begin, end);
			result = (published && checkdate);
			
		}
		catch(Exception ex)
		{
			result = false;
		}
		return result;
	
	}
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString) throws Exception
	{
		logger.debug("ConnexionString : "+ connexionString);
		try 
		{
				if((login!=null) && (password!=null))
				{	
					webdavConnection.connect(connexionString, login, password);	
				}
				else
				{
					webdavConnection.connect(connexionString);	
				}
			}
		catch (Exception ex) 
		{	
			logger.error("error connecting to webdav resource : "+ connexionString+"\ncause : "+ex.getCause());	
	        throw ex;
	    }
		logger.debug("Connect : end");			
	}


/**
 * Give the property of resource
 * @return the array of properties
 */
private Enumeration getProperty(Vector properties) throws URIException, IOException 
{
	
	return getProperty("", properties);
 
}

private Enumeration getProperty(String subpath,Vector properties) throws URIException, IOException 
{
	logger.debug("properties :"+ properties);
	logger.debug("PROPFIND webdavpath :"+ webdavpath);
	logger.debug("PROPFIND path :"+ subpath);
	logger.debug("PROPFIND rootpath :"+ rootpath);
	logger.debug("PROPFIND propfindpath :"+rootpath+subpath);
	return webdavConnection.getProperties(rootpath+subpath, DepthSupport.DEPTH_0, properties);
}

		
}


