<!--?xml version="1.0" encoding="UTF-8"? -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">
   	<xsl:import href="../docbook-xsl-1.65.1/xhtml/docbook.xsl" />
   	<xsl:param name="cssfile" />
    	
	<xsl:template match="page">
		<xsl:apply-templates />
	</xsl:template>	
   	
	<xsl:template match="styleCss">
	<div id="listeCSS">
        	<form>
            		<select name="stylesheetList" onchange="javascript:location.href=(this.options[this.selectedIndex].value)">
               			<xsl:apply-templates select="cssName" />
            		</select>
         	</form>
      	</div>
   	</xsl:template>

   	<xsl:template match="cssName">
      	<option value=".?cssfile={.}">
         	<xsl:value-of select="."/>
      	</option>
   	</xsl:template>
  	<!-- structure principale --> 
   	<!-- 1. Elements du Header-->
	<xsl:template match="injacHeader">
      		<div id="iHeader">
		<div id="iSchoolLogo">
			<img src="{./logos/@school}" alt=""/> 
	      	</div>
		<div id="iInjacLogo">
	      		<img src="{./logos/@injac}" alt=""/>	
	      	</div>
		</div>
   	</xsl:template>

	<!-- 2. Elements lies a la navigation -->
	<xsl:template match="injacNav">
		<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="injacNavPan">
      	<div id="iNavPan">
		<ul type="disc" id="currentFolder">
         		<xsl:apply-templates />
		</ul>
	</div>
   	</xsl:template>
	
	<xsl:template match="injacNavBar">
      	<div id="iNavBar">
		
		<div id="iCurrentLoc"><xsl:value-of select="currentloc"/></div>
		
		<div id="iBackUri"><a href="{./backUri}">Retour</a></div>
      	</div>
   	</xsl:template>

	<!-- 3. Elements lies au document -->
	<xsl:template match="injacDoc">
		<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="injacDocRender">
      	<div id="iDocRender">
		<xsl:value-of select="/child::node()" />
	</div>
   	</xsl:template>
	
	<xsl:template match="injacRelDocs">
      	<div id="iRelDocs">
		<tr>
		<xsl:for-each select="reldoc" >
		<td><href src="{.}" ><xsl:value-of select="./@path"/></href><xsl:value-of select="./@name"/></td>
		<td/>
		</xsl:for-each>
		</tr>
      	</div>
   	</xsl:template>

	<!-- Elements de repertoire -->
	
	<xsl:template match="current">   	  
	<div id="current" ><h4>Collection courante : <xsl:value-of select="name"/></h4></div>
   	</xsl:template>
   
   	<xsl:template match="directories">
	<div ><h4>Collections :</h4></div>
	<xsl:apply-templates />
   	</xsl:template>
	
   	<xsl:template match="files">
	<div ><h4>Resources :</h4></div>
	<xsl:apply-templates />
   	</xsl:template>

 
 
   	<xsl:template match="directory">
       	<li class="directory">		
		<a href="./publications/{name}/?cssfile={$cssfile}">
			<xsl:value-of select="name" />
		</a>
		<ul type="circle">
			<li id="fileDate">creation : <xsl:value-of select="date" /></li>
			<!--li id="fileDate">modification : <xsl:value-of select="lastModified" /></li-->
		</ul>
      	</li>
   	</xsl:template>

   	<xsl:template match="file">
      	<li class="file">
		<a href="./{name}?cssfile={$cssfile}&amp;path={name}">
			<xsl:value-of select="name" />
		</a>
        	<ul type="circle">
			<li id="fileDate">creation : <xsl:value-of select="date" /></li>
			<!--li id="fileDate">modification : <xsl:value-of select="lastModified" /></li-->
			<li id="fileSize">taille : <xsl:value-of select="size" /> octets</li>
		</ul>
      	</li>
   	</xsl:template>
   
   	<xsl:template match="article">
   		 <div id="docbookDocument">
   		 	<xsl:apply-imports/>
         	</div>
   	</xsl:template>    
</xsl:stylesheet>

