<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">

   

   <xsl:template match="dir:directory">
         <current>
            <name>
               <xsl:value-of select="@name" />
            </name>

            <size>
               <xsl:value-of select="@size" />
            </size>

            <lastModified>
               <xsl:value-of select="@lastModified" />
            </lastModified>

            <date>
               <xsl:value-of select="@date" />
            </date>
         </current>

         <xsl:apply-templates />
   </xsl:template>

   <xsl:template match="dir:directory/dir:directory">
      <directory>
         <name>
            <xsl:value-of select="@name" />
         </name>

         <size>
            <xsl:value-of select="@size" />
         </size>

         <lastModified>
            <xsl:value-of select="@lastModified" />
         </lastModified>

         <date>
            <xsl:value-of select="@date" />
         </date>
      </directory>
   </xsl:template>

   <xsl:template match="dir:directory/dir:file">
      <file>
         <name>
            <xsl:value-of select="@name" />
         </name>

         <size>
            <xsl:value-of select="@size" />
         </size>

         <lastModified>
            <xsl:value-of select="@lastModified" />
         </lastModified>

         <date>
            <xsl:value-of select="@date" />
         </date>
      </file>
   </xsl:template>
</xsl:stylesheet>

