<?xml version="1.0" encoding="iso-8859-1"?>
<!-- xmlns:dir="http://apache.org/cocoon/directory/2.0" -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			      xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
     	<xsl:param name="sitemapAsBase" />
    	<xsl:param name="path" />
	<xsl:param name="baselink" />	
	<xsl:param name="user" />
	<xsl:param name="logoutURL" select="'logout'"/>		
	<!-- Elements du Header-->
	<xsl:template match="MDREP/skin/header">
            <!--
                    <td ><img src="frame/{substring-before(../../@skinname, '.xml')}/header/LT.jpeg"/></td><td><img src="frame/{substring-before(../../@skinname, '.xml')}/header/MT.jpeg" id="headerMT"/><div id="headerMT"/></td><td id="headerRT"/>
                
             </div-->
            <xsl:if test="framesvg">
                 <xsl:call-template name="insertFrame">
                    <xsl:with-param name="parent" select="'header'"/>
                </xsl:call-template>
                
            </xsl:if>
            <xsl:if test="header-title">
                <div id="header-title"/>
            </xsl:if>
			<xsl:apply-templates select="logos"/>
      		
		<div id="headerlinks"><table><tr>
		<xsl:for-each select="links/link">
		<td>
			<a class="headerlink" href="{@href}" title="{@text}">
				<xsl:value-of select="@text"/>
			</a>
		</td>
		</xsl:for-each>
		</tr></table></div>
		<xsl:choose>
		<xsl:when test="$user != ''">
			<div id="user">
			  <i18n:text>Welcome</i18n:text>, <xsl:value-of select="$user"/> !
			</div>
			<div id="login">
				<a  href="{$baselink}logout" >Logout</a>
			</div>
		</xsl:when>
		<xsl:otherwise>
        		<div id="login">
                		<a  href="{$baselink}auth" ><i18n:text>Login</i18n:text></a>
                        </div>
		</xsl:otherwise>
		</xsl:choose>
            <!--/div-->
	</xsl:template>
	
	<xsl:template match="logos">
		<xsl:for-each select="logo">

		<xsl:choose>
			<xsl:when test="@filter='none'">
<div id="{@id}">				
	<img src="_images/{@src}" alt=""/> 
</div>
			</xsl:when>
			<xsl:otherwise>
	<xsl:call-template name="insertMaskimg">
					<xsl:with-param name="parent" select="'header-logos'"/>
                    <xsl:with-param name="id" select="@id"/>
					<xsl:with-param name="skinname" select="substring-before(../../../../@skinname, '.xml')"/>
    </xsl:call-template>				
			</xsl:otherwise>
		</xsl:choose>	

		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="user">
		<div id="user"><xsl:copy-of select="."/>
		<xsl:apply-templates /></div>
	</xsl:template>
	<!--xsl:template match="authentication">
		Bienvenue, <xsl:value-of select="session:ID"/>
	</xsl:template-->
	
		
	

   	
</xsl:stylesheet>

