<?xml version="1.0" encoding="UTF-8"?>
<!--
  Conversion d'une reponse du WebdavGenerator en éléments inJac
  comportement: 
  si vide, @title est remplacé par @name
-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:collection="http://apache.org/cocoon/collection/1.0"
		xmlns:MD="http://esup-portail.org/injac">

<xsl:param name="currentloc"/>
<xsl:param name="backUri"/>
<xsl:param name="upnode"/>
<xsl:param name="display-upnode"/>

<xsl:template match="*[@name=/MD:response/@directory]">
<metadatas>
	<skin>
		<xsl:value-of select="@skin"/>
	</skin>	
</metadatas>
</xsl:template>

<xsl:template match="/MD:response">
<xsl:variable name="parent">
	<xsl:choose>
		<xsl:when test="@directory=$upnode">
			<xsl:value-of select="''"/>
		</xsl:when>
		<xsl:when test="@seldoc!='' and contains($currentloc, @seldoc)">
			<xsl:value-of select="substring-before($currentloc, concat('/',@seldoc))"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$currentloc"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:variable>	
<xsl:variable name="directory-title">
	<xsl:choose>
		<xsl:when test="MD:resource[@name=/MD:response/@directory]/@title != ''">
			<xsl:value-of select="MD:resource[@name=/MD:response/@directory]/@title"/>
		</xsl:when>
		<xsl:when test="@directory=$upnode">
			<xsl:value-of select="$display-upnode"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="MD:resource[@name=/MD:response/@directory]/@name"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:variable>
<xsl:apply-templates select="*[@name=/MD:response/@directory]"/>
<!--metadatas>
	<skin>
		<xsl:value-of select="*[@name=/MD:response/@directory]/@skin"/>
	</skin>	
</metadatas-->

<injacNavPan>  
  <current>
    <name>
    	<xsl:value-of select="$directory-title"/>
    </name>
    <seldoc>
    	<xsl:value-of select="@seldoc"/>
    </seldoc>
  </current>
  <spaces parent="{$parent}" parent-title="{$directory-title}">
  <!-- boucle sur tous les répertoires à l'exclusion du parent -->
  <xsl:for-each select="*[@resourcetype='D'][@name!=/MD:response/@directory][@injac-type='space']">
  <xsl:sort select="@name"/>
  <space>
  	<name>
    		<xsl:value-of select="@name"/>
    </name>
  	<encname>
    		<xsl:value-of select="@encname"/>
    </encname>
  	
	
	
  	<lastModified>
    		<xsl:value-of select="@getlastmodified"/>
    	</lastModified>
	<date>
    		<xsl:value-of select="@creationdate"/>
    	</date>
	<size>
    		<xsl:value-of select="@getcontentlength"/>
    	</size>
	<title>
		<xsl:choose>
			<xsl:when test="@title!=''">
				<xsl:value-of select="@title"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@name"/>
			</xsl:otherwise>
		</xsl:choose>
		
	</title>
	<root-doc-name>
            <xsl:value-of select="@root-doc-name"/>
        </root-doc-name> 
        <description>
            <xsl:value-of select="@description"/>
        </description>   
  </space> 
  </xsl:for-each>
  </spaces>
  <!-- composites -->
  <documents parent="{$parent}" parent-title="{$directory-title}" >
   <xsl:for-each select="*[@resourcetype='D'][@name!=/MD:response/@directory][@injac-type='document']">
   <xsl:sort select="@name"/>
   <document>
   	<name><xsl:value-of select="@name"/></name>
	<lastModified>
	    	<xsl:value-of select="@getlastmodified"/>
	</lastModified>
	<date>
		<xsl:value-of select="@creationdate"/>
	</date>
	<size>
	    	<xsl:value-of select="@getcontentlength"/>
	</size>
	<title>
		<xsl:choose>
		<xsl:when test="@title!=''"><xsl:value-of select="@title"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
		</xsl:choose>
	</title>
	<root-file-name><xsl:value-of select="@root-file-name"/></root-file-name>
	<document-state>
		<xsl:value-of select="@document-state"/>
	</document-state>
        <description>
            <xsl:value-of select="@description"/>
        </description>
   </document>
   </xsl:for-each>
  </documents> 
</injacNavPan> 
<injacNavBar>
  	<currentloc>
		<xsl:choose>
	    		<xsl:when test="/MD:response/@seldoc !='' and not(contains($currentloc, /MD:response/@seldoc))">
				<xsl:value-of select="concat($currentloc, concat('/',/MD:response/@seldoc))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$currentloc" />
			</xsl:otherwise>
		</xsl:choose>	
	</currentloc>
	<current-title>
	    <xsl:choose>
	    	<xsl:when test="/MD:response/@seldoc !=''">
			<xsl:value-of select="/MD:response/*[contains(@name, /MD:response/@seldoc)]/@title"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$directory-title"/>
		</xsl:otherwise>
	    </xsl:choose>		
	</current-title>
	<upnode>
		<xsl:value-of select="$display-upnode" /> 
 	</upnode>
	<backUri>
		<xsl:value-of select="$backUri" /> 
	</backUri>
</injacNavBar>

</xsl:template>
   


</xsl:stylesheet>
