<?xml version="1.0" encoding="UTF-8"?>
<!--xmlns:dir="http://apache.org/cocoon/directory/2.0"-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
    <xsl:param name="cssfile" />
    <xsl:param name="localURI" />
    <xsl:param name="doc" />
    <xsl:param name="baselink" select="''"/>
    <!-- deprecated -->
    <xsl:param name="extdocs" select="'pdf doc rtf ppt sxw'"/>
    <xsl:param name="intdocs" select="'xml html htm txt jpg png gif XML HTML HTM TXT JPG PNG GIF'"/>
    <xsl:variable name="cocoonURI" select="substring-before($localURI, '/injac')" />
   
	
  	<!-- structure principale --> 
   
	<!-- Elements principaux -->
	<xsl:template match="injacNav">
		<xsl:apply-templates select="injacNavBar"/>
        <xsl:apply-templates select="injacNavPan"/>
	</xsl:template>
	
    <xsl:template match="injacNavBar">
	<xsl:param name="currentloc" select="currentloc"/>
      	<div id="iNavBar">
		<div id="iCurrentLoc">
			<a href="{$localURI}/nav/"><xsl:value-of select="./upnode"/></a>
			<xsl:call-template name="create-linked-path">
				<xsl:with-param name="currentloc" select="currentloc"/>
                                <xsl:with-param name="colltitle" select="current-title"/>
	    		</xsl:call-template>
                 </div>
      	</div>
   	</xsl:template>
        
	<xsl:template match="injacNavPan">
      	<!-- TODO : extraire la generation des balises html dans une feuille de genskin -->
        <div id="iNavPan">
             <div id="iCurrentPan">
                <xsl:call-template name="insertFrame">
                    <xsl:with-param name="parent" select="'navpan'"/>
                </xsl:call-template>
        	<xsl:apply-templates select="current"/>
		<div class="ispaces">
                    <xsl:apply-templates select="spaces"/>
                </div>
                <div class="idocs">
                    <xsl:apply-templates select="documents"/>
                </div>
             </div>
	</div>
   	</xsl:template>
	
            
        
	
	<!-- Elements de injacNavPan -->
	
	<xsl:template match="current">   	  
	<div id="current-title" class="gennavpan" ><xsl:value-of select="name"/></div>
   	</xsl:template>
   
   	<xsl:template match="spaces">
            <xsl:if test="count(space) &gt; 0">
            <ul>
                <xsl:apply-templates >
		    	<xsl:sort select="title"/>
		</xsl:apply-templates>
            </ul>
            </xsl:if>
   	</xsl:template>
	
   	<xsl:template match="documents">
            <xsl:if test="count(document) &gt; 0">
            <ul>
                <xsl:apply-templates >
			<xsl:sort select="title"/>
		</xsl:apply-templates>
            </ul>
            </xsl:if>
   	</xsl:template>

 
 
   	<xsl:template match="space">
       	<li class="ispace">
		<xsl:choose><!--xsl:when test="string-length(../@parent) != 1"-->
			<xsl:when test="root-doc-name != ''">
				<a class="navpanlink" href="{$localURI}/nav{../@parent}/{name}/{root-doc-name}" title="{description}">
				<!--a class="navpanlink" href="{$localURI}?path={../@parent}{name}&amp;doc=/{root-doc-name}" title="{description}"-->
					<xsl:value-of select="title" />
				</a>
				
			</xsl:when>
			<xsl:otherwise>
				<a class="navpanlink" href="{$localURI}/nav{../@parent}/{name}" title="{description}">
					<xsl:value-of select="title" />
				</a>
			</xsl:otherwise>
		</xsl:choose>
		</li>
	</xsl:template>

   	<xsl:template match="document">
	<xsl:variable name="filename">
		<xsl:choose>
			<xsl:when test="root-file-name !=''">
				<xsl:value-of select="root-file-name"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	
	<xsl:variable name="docclass">
		<xsl:choose>
			<xsl:when test="/page/injacNavPan/current/seldoc = name">
				<xsl:value-of select="'iseldoc'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'idoc'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	
      	<li class="{$docclass}">
	<!-- Test des types de document au rendu externe -->
	<xsl:choose>
			<!-- extern rendering link (with filename appended)-->
            <xsl:when test="not(contains($intdocs, substring-after($filename, '.')))">
                <xsl:choose>
                    <!-- Test pour eliminer le slash-->
                    <xsl:when test="string-length(../@parent) != 1">
                        <a class="navpanlink" href="{$localURI}/ext{../@parent}/{name}/{$filename}" title="{description}" >						
						<xsl:value-of select="title" /></a>
                    </xsl:when>
                    <xsl:otherwise>
						<a class="navpanlink" href="{$localURI}/ext/{name}/{$filename}" title="{description}">
						<!--a class="navpanlink" href="{$localURI}/ext/{name}?path=/{name}&amp;file={name}" title="{description}"-->
                        <xsl:value-of select="title" /></a>
                    </xsl:otherwise>
                </xsl:choose>
             </xsl:when>
			 <!-- intern rendering link (without file name)-->
             <xsl:otherwise>
                <xsl:choose>
                    <!-- Test pour eliminer le slash-->
                    <xsl:when test="string-length(../@parent) != 1">
                        <a class="navpanlink" href="{$localURI}/nav{../@parent}/{name}" title="{description}">
                            <xsl:value-of select="title" />
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
			<!--a href="{$localURI}{$auth}?{name}&amp;path=" title="{document-state}"-->
                        <a class="navpanlink" href="{$localURI}/nav/{name}" title="{description}">
				<xsl:value-of select="title" />
			</a>
                    </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
        </xsl:choose>
      	</li>
   	</xsl:template>
	
	
	<!-- Template recursif pour decomposer en liens le chemin courant-->
	<xsl:template name="create-linked-path">
  		<xsl:param name="currentloc"/>
                <xsl:param name="colltitle"/>
		<xsl:param name="fullpath" select="$currentloc"/>
			<xsl:choose>
			<xsl:when test="contains($currentloc, '/')">
				<xsl:call-template name="create-linked-path">
      					<xsl:with-param name="currentloc">
						<xsl:call-template name="remove-last-rep">
							<xsl:with-param name="breloc" select="$currentloc" />
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="fullpath" select="$fullpath"/>
                                        <xsl:with-param name="colltitle" select="$colltitle"/>
				</xsl:call-template>
				<xsl:choose>
				<xsl:when test="$fullpath = $currentloc">
					<xsl:call-template name="last-rep">
						<xsl:with-param name="last-rep-uri" select="$currentloc" />
						<xsl:with-param name="title" select="$colltitle"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				<a href="{$localURI}/nav{$currentloc}">
					<xsl:call-template name="last-rep">
						<xsl:with-param name="last-rep-uri" select="$currentloc" />
						<xsl:with-param name="title" select="''"/>
					</xsl:call-template>
				</a>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$currentloc != ''">
				<a href="{$localURI}/nav{$currentloc}"><xsl:value-of select="$colltitle" /></a>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- sous-template recursif otant le dernier rep du path -->
	<xsl:template name="remove-last-rep" >
		<xsl:param name="breloc" />
		<xsl:param name="last-rep-uri" select="$breloc" />
		<xsl:choose>
			<xsl:when test="contains($last-rep-uri, '/')">
			<xsl:call-template name="remove-last-rep">
      				<xsl:with-param name="last-rep-uri" select="substring-after($last-rep-uri, '/')"/>
				<xsl:with-param name="breloc" select="$breloc"/>
	    		</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text/><xsl:value-of select="substring-before($breloc, concat('/', $last-rep-uri))" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>		
	
		
	<!-- sous-template recursif simulant la fonction lastOf() -->
	<xsl:template name="last-rep" >
		<xsl:param name="last-rep-uri"/>
		<xsl:param name="title"/>
                <!--DEBUG3 : <xsl:value-of select="$title" /-->
		<xsl:choose>
			<xsl:when test="contains($last-rep-uri, '/')">
			<xsl:call-template name="last-rep">
      				<xsl:with-param name="last-rep-uri" select="substring-after($last-rep-uri, '/')"/>
                                <xsl:with-param name="title" select="$title"/>
	    			</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$title = ''" >
						/<xsl:value-of select="$last-rep-uri" />
					</xsl:when>
					<xsl:otherwise>
						/<xsl:value-of select="$title" />
					</xsl:otherwise>
				</xsl:choose>
				
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>		
	
    
</xsl:stylesheet>

