<?xml version="1.0" encoding="UTF-8"?>   
<!--Changes :
    2/2/2005 : retrait de Doc2HTML qui est traité dans le pipeline de la sitemap TestDoc
-->
<!--xmlns:dir="http://apache.org/cocoon/directory/2.0"
			xmlns:dasl="http://cocoon.apache.org/webdav/dasl/1.0"
			xmlns:D="DAV:" -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
    <xsl:output encoding="UTF-8"/>
	<xsl:include href="../../genskin/stylesheets/xsl/skin2html.xsl" />
   	<xsl:include href="Header2html.xsl" />
	<xsl:include href="Navgen2html.xsl" />
	<!--xsl:include href="Doc2html.xsl" /-->
	<xsl:include href="Tools2html.xsl" />
    <xsl:include href="footer2html.xsl" />
	<xsl:param name ="cssfile"/>
        <xsl:param name="path"/>
	<xsl:param name="file"/>
	<xsl:param name="localURI" /> 
	<xsl:param name="cocoonURI"/>
	<xsl:param name="logoutURL"/>
	<xsl:param name="baselink" select="''"/>
	
	<xsl:template match="/page">
      	<html>
        	<head>
			<xsl:call-template name="MDREP" />
			<title>INJAC</title>
        	</head>
		<body>
			<xsl:apply-templates select="MDREP/skin/header"/>
                        <xsl:apply-templates select="injacNavPan"/>
                        <xsl:apply-templates select="injacNavBar"/>
                        <xsl:apply-templates select="injacDoc|results|advsearch"/>
                        <!--xsl:apply-templates select="results"/-->
                        <xsl:apply-templates select="MDREP/skin/tools"/>
                        <xsl:apply-templates select="MDREP/skin/footer"/> 
        </body> 
      	</html>
   	</xsl:template>
<!-- espace IDocRender -->    
    <!-- document -->    
	<xsl:template match="injacDoc">
        <xsl:copy-of select="./*"/>
    </xsl:template>
	<!-- advanced search -->
    <xsl:template match="advsearch">
        <div id="iDocRender"><xsl:copy-of select="./*"/></div>
    </xsl:template>
	<!-- search results -->
	<xsl:template match="results">
		<div id="iDocRender">
			<xsl:copy-of select="./*"/>
		</div>
	</xsl:template>
	<!-- espace IDocRender END -->     
	<xsl:template name="MDREP">
        <style type="text/css" media="all">@import "<xsl:value-of select="$baselink"/>genskin/gencss/<xsl:value-of select="/page/MDREP/@skinname"/>.css";</style>
	<style type="text/css" media="all">@import "<xsl:value-of select="$baselink"/><xsl:value-of select="substring-before(/page/MDREP/@skinname, 'xml')"/>css";</style>
        <xsl:if test="/page/MDREP/CSSFILE != ''">
                        <style type="text/css" media="all">@import "<xsl:value-of select="$baselink"/><xsl:value-of select="/page/MDREP/CSSFILE"/>";</style>
	</xsl:if>
	</xsl:template>
	<!--xsl:template match="@*"/>
	<xsl:template match="*"/-->
	
</xsl:stylesheet>

