<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:param name="elem" select="''"/>    
<xsl:param name="frameid" select="'none'"/>



<!-- parametrage pour framesvg MUSTMATCH skin2.css -->  
<xsl:variable name="tile-width" select="50"/>
<xsl:variable name="tile-height" select="22"/>
<xsl:variable name="pattern-width" select="150"/>
<xsl:variable name="pattern-height" select="56"/>
  
<xsl:output
        version="1.0"
        standalone="yes"
        indent="no"/>
    <xsl:strip-space elements="skin header linls link logos logo navpan title tools tool"/>
    
    <xsl:template match="skin">
        <xsl:choose>
            <xsl:when test="$frameid='none'">
                <xsl:choose>
                    <xsl:when test="$elem = 'navpan'">
                        <xsl:apply-templates select="navpan/gensvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'header-title'">
                        <xsl:apply-templates select="header/header-title/gensvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'header'">
                        <xsl:apply-templates select="header/gensvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'header-links'">
                        <xsl:apply-templates select="header/links/gensvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'doc-title'">
                        <xsl:apply-templates select="doc/doc-title/gensvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'doc-element'">
                        <xsl:apply-templates select="doc/doc-element/gensvg"/>
                   </xsl:when>
                </xsl:choose>
             </xsl:when>
             <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$elem = 'navpan'">
                        <xsl:apply-templates select="navpan/framesvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'header'">
                        <xsl:apply-templates select="header/framesvg"/>
                   </xsl:when>
                   <xsl:when test="$elem = 'doc'">
                        <xsl:apply-templates select="doc/framesvg"/>
                   </xsl:when>
                </xsl:choose>
             </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="insert-filters">
        <filter id="blur1">
            <feGaussianBlur stdDeviation="3"/>
	</filter>
	<filter id="blur2">
            <feGaussianBlur stdDeviation="1"/>
	</filter>
        <filter id="ompor">
            <feGaussianBlur in="SourceAlpha" stdDeviation="2" result="flou"/>
            <feOffset in="flou" dx="4" dy="6" result="flouDécalé"/>
            <feMerge>
                <feMergeNode in="flouDécalé"/>
                <feMergeNode in="SourceGraphic"/>
            </feMerge>
        </filter>
    </xsl:template>
    
    <xsl:template name="insert-paths">
        <path id="bezier-path1"
            d="M 8 40 C 50 10, 70 10, 120 35 S 150 0, 210 40"
            style="stroke: gray; fill: none;"/>
    </xsl:template>
    <xsl:template name="create-bezier-path">
        <xsl:param name="num"/>
        <xsl:param name="left"/>
        <xsl:param name="top"/>
        <xsl:param name="width"/>
        <xsl:param name="height"/>
        <!-- 
        d="M 8 40 C 50 10, 70 10, 120 35 S 150 0, 210 40"
        -->
        <xsl:choose>
            <xsl:when test="$num='1'">
        <path id="bezier-path1"
            d="M {$left} {$top} C {round($width div 3)} 10, {$width div 2} 10, {$width * 0.8} {$height - 5} S {$width - 50} 0, {$width} {$height div 3}"
            style="stroke: gray; fill: none;"/>
            </xsl:when>
            <xsl:when test="$num='2'">
        <path id="bezier-path2"
            d="M {$left} {$top} C {round($width div 12)} {$height}, {round(($width div 12) * 11)} {$height}, {round($width - $left)} {$top}"
            style="stroke: gray; fill: none;"/>
            </xsl:when>
        </xsl:choose>
         
    </xsl:template>
    <xsl:template match="gensvg">
        <xsl:variable name="swidth">
            <xsl:choose>
                <xsl:when test="@x &lt; 0">
                    <xsl:value-of select="@width - @x*2"/>
                </xsl:when>
                <xsl:when test="@gfilter = 'ompor'">
                    <xsl:value-of select="@width - (@stroke-width + 6)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@width - (@stroke-width)"/>
                </xsl:otherwise>
           </xsl:choose>
        </xsl:variable>
        <xsl:variable name="sheight">
            <xsl:choose>
                <xsl:when test="@gfilter = 'ompor'">
                    <xsl:value-of select="@height - (@stroke-width + 2)"/>
                </xsl:when>
                <xsl:otherwise>
                    
                    <xsl:value-of select="@height -(@stroke-width)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
	<svg  width="{@width}" height="{@height}" viewBox="0 0 {@width} {@height}">
            <defs>
                <xsl:call-template name="insert-filters"/>
                <!--xsl:call-template name="insert-paths"/-->
        <xsl:if test="textsvg">
            <xsl:if test="textsvg/@path != 'none'">
                <xsl:if test="contains(textsvg/@path, 'bezier-path')">
                <xsl:call-template name="create-bezier-path">
                    <xsl:with-param name="num" select="substring-after(textsvg/@path, 'bezier-path')"/>
                    <xsl:with-param name="left" select="@stroke-width * 2"/>
                    <xsl:with-param name="top" select="@stroke-width * 2"/>
                    <xsl:with-param name="width" select="$swidth"/>
                    <xsl:with-param name="height" select="$sheight"/>
                </xsl:call-template>
                
                </xsl:if>
            </xsl:if>
         </xsl:if>
                <g id="rectangle">
                    <xsl:if test="@gfilter != 'none'">
                        <xsl:attribute name="filter">url(#<xsl:value-of select="@gfilter"/>)</xsl:attribute>
                    </xsl:if>
                    <rect
                        style="fill:{@color};stroke:{@stroke};stroke-width:{@stroke-width};"
                        x="{@x + (@stroke-width div 2) }" y="{@y + (@stroke-width div 2)}" rx="{@rx}" ry="{@ry}" width="{$swidth}" height="{$sheight}">
                        <xsl:if test="@filter != 'none'">
                            <xsl:attribute name="filter">url(#<xsl:value-of select="@filter"/>)</xsl:attribute>
                        </xsl:if>
                    </rect>
                </g>
            </defs>
                        
            <g xmlns:xlink="http://www.w3.org/1999/xlink" title="{$elem}" style="fill: {@bgcolor};">
                <rect style="fill: {@bgcolor};stroke:{@bgcolor};"
                x="{0}" y="{0}" width="{@width}" height="{@height}"/>
                <use xlink:href="#rectangle" x="0" y="0"/>    
                <xsl:apply-templates select="textsvg"/>
            </g>
        </svg>
    </xsl:template>
    <xsl:template match="textsvg">
	<text 
        xmlns:xlink="http://www.w3.org/1999/xlink"
        style="{@style}">
        <xsl:if test="@path != 'none'">
            <textPath xlink:href="#{@path}">
                <xsl:apply-templates />
            </textPath>
        </xsl:if>
	</text>
    </xsl:template>
    <xsl:template match="framesvg">
	<xsl:choose>
            <xsl:when test="$frameid='LT'">
                 <svg preserveAspectRatio="xMinYMin slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="'0'"/>
                            <xsl:with-param name="y" select="'0'"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='MT'">
                 <svg preserveAspectRatio="xMidYMin slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="-$tile-width"/>
                            <xsl:with-param name="y" select="'0'"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='RT'">
                 <svg preserveAspectRatio="xMaxYMin slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="-($tile-width * 2)-40"/>
                            <xsl:with-param name="y" select="'0'"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='ML'">
                 <svg preserveAspectRatio="xMinYMid slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="'0'"/>
                            <xsl:with-param name="y" select="-$tile-height"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='MM'">
                 <svg preserveAspectRatio="xMidYMid slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="-$tile-width"/>
                            <xsl:with-param name="y" select="-$tile-height"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='MR'">
                 <svg preserveAspectRatio="xMaxYMid slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="-($tile-width * 2)-40"/>
                            <xsl:with-param name="y" select="-$tile-height"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='LB'">
                 <svg preserveAspectRatio="xMinYMax slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="'0'"/>
                            <xsl:with-param name="y" select="-($tile-height* 2)"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='MB'">
                 <svg preserveAspectRatio="xMidYMax slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="-$tile-width"/>
                            <xsl:with-param name="y" select="-($tile-height*2)"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
            <xsl:when test="$frameid='RB'">
                 <svg preserveAspectRatio="xMaxYMax slice"
                      viewBox="0 0 {$tile-width} {$tile-height}"
                      width="{$tile-width}" height="{$tile-height}">
			<xsl:call-template name="make-frame">
                            <xsl:with-param name="rx" select="@rx"/>
                            <xsl:with-param name="ry" select="@ry"/>
                            <xsl:with-param name="x" select="-($tile-width * 2)-40"/>
                            <xsl:with-param name="y" select="-($tile-height* 2)"/>
                            <xsl:with-param name="bgcolor" select="@bgcolor"/>
                            <xsl:with-param name="color" select="@color"/>
                            <xsl:with-param name="stroke" select="@stroke"/>
                            <xsl:with-param name="stroke-width" select="@stroke-width"/>
                            <xsl:with-param name="filter" select="@filter"/>
                        </xsl:call-template>
                 </svg>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="make-frame">
        <xsl:param name="rx"/>
        <xsl:param name="ry"/>
        <xsl:param name="x"/>
        <xsl:param name="y"/>
        <xsl:param name="bgcolor"/>
        <xsl:param name="color"/>
        <xsl:param name="stroke"/>
        <xsl:param name="stroke-width"/>
        <xsl:param name="filter"/>
        <defs>
            <filter id="blur1">
                <feGaussianBlur stdDeviation="3" result="flou"/>
                
            </filter>
            <filter id="blur2">
            <!-- in="BackgroundAlpha"-->
                <feGaussianBlur  stdDeviation="2" result="flou2"/>
                <feMerge>
                    <feMergeNode in="flou2"/>
                    <feMergeNode in="SourceGraphic"/>
                </feMerge>
            </filter>
	</defs>
	<g title="{$elem}-{$frameid}">
             <rect style="fill: {$bgcolor};stroke:{$bgcolor};"
                    x="{$x}" y="{$y}" width="{$pattern-width+$stroke-width}" height="{$pattern-height+$stroke-width}"/>
             <rect 
             style="background-color:{$bgcolor}; fill:{$color};stroke:{$stroke};stroke-width:{$stroke-width};filter:url(#{$filter});"
             x="{$x}" y="{$y}" rx="{$rx}" ry="{$ry}" width="{$pattern-width}" height="{$pattern-height}"/>
             
        </g>
     </xsl:template>
</xsl:stylesheet>
