/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ScriptGenerator
extends ServiceableGenerator
implements Configurable {
    protected BSFLanguage[] additionalLanguages;
    private Source inputSource;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration languagesToAdd = conf.getChild("add-languages");
            Configuration[] languages = languagesToAdd.getChildren("language");
            this.additionalLanguages = new BSFLanguage[languages.length];
            for (int i = 0; i < languages.length; ++i) {
                Configuration language = languages[i];
                BSFLanguage bsfLanguage = new BSFLanguage();
                bsfLanguage.name = language.getAttribute("name");
                bsfLanguage.engineSrc = language.getAttribute("src");
                this.getLogger().debug("Configuring ScriptGenerator with additional BSF language " + bsfLanguage.name);
                this.getLogger().debug("Configuring ScriptGenerator with BSF engine " + bsfLanguage.engineSrc);
                Configuration[] extensions = language.getChildren("extension");
                bsfLanguage.extensions = new String[extensions.length];
                for (int j = 0; j < extensions.length; ++j) {
                    bsfLanguage.extensions[j] = extensions[j].getValue();
                    this.getLogger().debug("Configuring ScriptGenerator with lang extension " + bsfLanguage.extensions[j]);
                }
                this.additionalLanguages[i] = bsfLanguage;
            }
        }
    }

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws ProcessingException {
        SAXParser parser = null;
        try {
            block13: {
                try {
                    this.getLogger().debug("processing file [" + this.source + "]");
                    this.inputSource = this.resolver.resolveURI(this.source);
                    this.getLogger().debug("file resolved to [" + this.inputSource.getURI() + "]");
                    InputStreamReader in = new InputStreamReader(this.inputSource.getInputStream());
                    BSFManager mgr = new BSFManager();
                    if (this.additionalLanguages != null) {
                        for (int i = 0; i < this.additionalLanguages.length; ++i) {
                            this.getLogger().debug("adding BSF language " + this.additionalLanguages[i].name + " with engine " + this.additionalLanguages[i].engineSrc);
                            BSFManager.registerScriptingEngine((String)this.additionalLanguages[i].name, (String)this.additionalLanguages[i].engineSrc, (String[])this.additionalLanguages[i].extensions);
                        }
                    }
                    StringBuffer output = new StringBuffer();
                    mgr.registerBean("resolver", (Object)this.resolver);
                    mgr.registerBean("source", (Object)this.source);
                    mgr.registerBean("objectModel", (Object)this.objectModel);
                    mgr.registerBean("parameters", (Object)this.parameters);
                    mgr.registerBean("logger", (Object)this.getLogger());
                    mgr.registerBean("output", (Object)output);
                    mgr.registerBean("contentHandler", (Object)this.contentHandler);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("BSFManager execution begining (" + this.inputSource.getURI() + ")");
                    }
                    mgr.exec(BSFManager.getLangFromFilename((String)this.inputSource.getURI()), this.inputSource.getURI(), 0, 0, (Object)IOUtils.getStringFromReader((Reader)in));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("BSFManager execution complete");
                    }
                    if (output.length() > 0) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Using String output provided by script (" + output.toString() + ")");
                        }
                        InputSource xmlInput = new InputSource(new StringReader(output.toString()));
                        parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                        parser.parse(xmlInput, (ContentHandler)this.xmlConsumer);
                        break block13;
                    }
                    if (!this.getLogger().isDebugEnabled()) break block13;
                    this.getLogger().debug("Script provided no String output, content should have been written to contentHandler");
                }
                catch (SourceException se) {
                    throw SourceUtil.handle((SourceException)se);
                }
                catch (FileNotFoundException e) {
                    throw new ResourceNotFoundException("Could not load script " + this.inputSource.getURI(), (Throwable)e);
                }
                catch (BSFException e) {
                    throw new ProcessingException("BSFException in ScriptGenerator.generate()", (Throwable)e);
                }
                catch (Exception e) {
                    throw new ProcessingException("Exception in ScriptGenerator.generate()", (Throwable)e);
                }
            }
            Object var7_11 = null;
            if (parser == null) return;
            this.manager.release(parser);
            return;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (parser == null) throw throwable;
            this.manager.release(parser);
            throw throwable;
        }
    }

    protected static class BSFLanguage {
        public String name;
        public String engineSrc;
        public String[] extensions;

        protected BSFLanguage() {
        }
    }
}

