/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class JavaScriptException
extends Exception {
    Object value;
    Vector stackTrace;
    static /* synthetic */ Class class$java$lang$Throwable;

    public JavaScriptException(Object value) {
        super(ScriptRuntime.toString(value));
        this.value = value;
    }

    static JavaScriptException wrapException(Scriptable scope, Throwable exn) {
        if (exn instanceof InvocationTargetException) {
            exn = ((InvocationTargetException)exn).getTargetException();
        }
        if (exn instanceof JavaScriptException) {
            return (JavaScriptException)exn;
        }
        Object wrapper = NativeJavaObject.wrap(scope, exn, class$java$lang$Throwable == null ? (class$java$lang$Throwable = JavaScriptException.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        return new JavaScriptException(wrapper);
    }

    public Object getValue() {
        if (this.value != null && this.value instanceof Wrapper) {
            return ((Wrapper)this.value).unwrap();
        }
        return this.value;
    }

    public void setJSStackTrace(Vector stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Vector getJSStackTrace() {
        return this.stackTrace;
    }

    public String getMessage() {
        String result = "";
        if (this.stackTrace != null) {
            for (int i = this.stackTrace.size() - 1; i >= 0; i -= 3) {
                String sourceName = (String)this.stackTrace.elementAt(i - 2);
                String funName = (String)this.stackTrace.elementAt(i - 1);
                if (funName == null) {
                    funName = "top-level script";
                }
                Integer lineNum = (Integer)this.stackTrace.elementAt(i);
                result = result + "\nat " + funName + " (" + sourceName + ", Line " + lineNum + ")";
            }
            result = result + ":\n";
        }
        result = result + super.getMessage();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

