/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.continuations;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.continuations.ContinuationException;
import org.mozilla.javascript.continuations.ContinuationParser;
import org.mozilla.javascript.continuations.Interpreted;
import org.mozilla.javascript.continuations.InterpretedFunctionImpl;
import org.mozilla.javascript.continuations.InterpretedScriptImpl;
import org.mozilla.javascript.continuations.InterpreterStack;
import org.mozilla.javascript.continuations.InterpreterState;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public class ContinuationInterpreter
extends Interpreter {
    static final int START_PC = 6;
    static final int LAST_INSN = 254;
    static final int TAIL_CALL = 254;
    static final int NON_TAIL_CALL = 253;
    static final int XGETVAR = 252;
    static final int XENUMNEXT = 251;
    static final int XUSETEMP = 250;
    static final int END_RESTORE_CONTINUATION = 249;
    static final int END_SAVE_CONTINUATION = 248;
    static final int END_RETURN_CONTINUATION = 247;
    Vector itsBefore;
    Vector itsAfter;
    Vector itsReturn;
    static /* synthetic */ Class class$org$mozilla$javascript$continuations$Continuation;
    static /* synthetic */ Class class$org$mozilla$javascript$continuations$ContinuationException;

    public Parser createParser(TokenStream ts, ClassNameHelper nameHelper, Scriptable scope) {
        return new ContinuationParser(this.createIRFactory(ts, null, scope));
    }

    static InterpreterState newInterpreterState(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) {
        InterpreterState result = ContinuationInterpreter.newInterpreterState();
        result.init(cx, scope, thisObj, args, fnOrScript, theData);
        return result;
    }

    static InterpreterState newInterpreterState() {
        return new InterpreterState();
    }

    public static void init(Context cx, ScriptableObject scope, boolean sealed) {
        new LazilyLoadedCtor(scope, "Continuation", "org.mozilla.javascript.continuations.Continuation", sealed);
    }

    public static Object interpret(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) throws JavaScriptException {
        if (theData.isFunction) {
            if (fnOrScript.itsClosure != null) {
                scope = fnOrScript.itsClosure;
            } else if (!theData.itsUseDynamicScope) {
                scope = fnOrScript.getParentScope();
            }
            if (theData.itsCheckThis) {
                thisObj = ScriptRuntime.getThis(thisObj);
            }
            if (theData.itsNeedsActivation) {
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
        } else {
            scope = ScriptRuntime.initScript(cx, scope, fnOrScript, thisObj, theData.itsFromEvalCode);
        }
        InterpreterState state = ContinuationInterpreter.newInterpreterState(cx, scope, thisObj, args, fnOrScript, theData);
        return ContinuationInterpreter.interpret(cx, state);
    }

    static String tokenToName(int ic) {
        String t;
        switch (ic) {
            case 252: {
                t = "xgetvar";
                break;
            }
            case 251: {
                t = "xenumnext";
                break;
            }
            case 250: {
                t = "xusetemp";
                break;
            }
            case 254: {
                t = "tail-call";
                break;
            }
            case 253: {
                t = "non-tail-call";
                break;
            }
            case 249: {
                t = "end-catch-continue";
                break;
            }
            case 248: {
                t = "end-catch-break";
                break;
            }
            case 247: {
                t = "end-catch-return";
                break;
            }
            default: {
                t = Interpreter.icodeToName(ic);
            }
        }
        return t;
    }

    public static Object interpret(Context cx, InterpreterState startState) throws JavaScriptException {
        return ContinuationInterpreter.interpret(cx, startState, false);
    }

    static DebugFrame enterFrame(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, DebuggableScript fnOrScript, InterpreterData itsData) {
        if (itsData.itsLineNumberTable != null) {
            return cx.getDebugger().enterFrame(cx, scope, thisObj, args, fnOrScript);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object interpret(Context cx, InterpreterState startState, boolean continuation) throws JavaScriptException {
        InterpreterState state;
        Object DBL_MRK = Interpreter.DBL_MRK;
        Scriptable undefined = Undefined.instance;
        Scriptable topScope = ScriptableObject.getTopLevelScope(startState.scope);
        Scriptable Function_prototype = ScriptableObject.getClassPrototype(topScope, "Function");
        Function Function_call = (Function)Function_prototype.get("call", Function_prototype);
        Function Function_apply = (Function)Function_prototype.get("apply", Function_prototype);
        Function Function_eval = (Function)ScriptableObject.getProperty(topScope, "eval");
        Scriptable Continuation_prototype = ScriptableObject.getClassPrototype(topScope, "Continuation");
        if (Continuation_prototype == null) {
            try {
                ScriptableObject.defineClass(Function_eval.getParentScope(), class$org$mozilla$javascript$continuations$Continuation == null ? (class$org$mozilla$javascript$continuations$Continuation = ContinuationInterpreter.class$("org.mozilla.javascript.continuations.Continuation")) : class$org$mozilla$javascript$continuations$Continuation);
                ScriptableObject.defineClass(Function_eval.getParentScope(), class$org$mozilla$javascript$continuations$ContinuationException == null ? (class$org$mozilla$javascript$continuations$ContinuationException = ContinuationInterpreter.class$("org.mozilla.javascript.continuations.ContinuationException")) : class$org$mozilla$javascript$continuations$ContinuationException);
            }
            catch (Exception e) {
                throw WrappedException.wrapException(e);
            }
        }
        Scriptable ContinuationException_prototype = ScriptableObject.getClassPrototype(topScope, "ContinuationException");
        Continuation_prototype = (Function)ScriptableObject.getClassPrototype(topScope, "Continuation");
        Object Continuation_ctor = ScriptableObject.getProperty(Continuation_prototype, "constructor");
        Object ContinuationException_ctor = ScriptableObject.getProperty(ContinuationException_prototype, "constructor");
        NativeCall caller = null;
        NativeCall callee = null;
        InterpreterState s = startState;
        while (s != null) {
            NativeCall tmp;
            if (s.scope instanceof NativeCall && (tmp = (NativeCall)s.scope) != caller) {
                tmp.caller = caller;
                caller = tmp;
                if (callee == null) {
                    callee = tmp;
                }
            }
            s = s.caller;
        }
        if (cx.getDebugger() != null) {
            s = startState;
            while (s != null) {
                s.frame = ContinuationInterpreter.enterFrame(cx, s.scope, s.thisObj, s.getArguments(), (DebuggableScript)((Object)s.fnOrScript), s.theData);
                if (continuation) break;
                s = s.caller;
            }
        }
        if (caller != null && ContinuationInterpreter.getCurrentActivation(cx) != callee) {
            caller.caller = ContinuationInterpreter.getCurrentActivation(cx);
            ContinuationInterpreter.setCurrentActivation(cx, callee);
        }
        InterpreterStack stk = new InterpreterStack();
        stk.replace(startState);
        Object result = undefined;
        ContinuationException continuationException = null;
        Continuation currentContinuation = null;
        block108: while ((state = stk.top()) != null) {
            block255: {
                topScope = ScriptableObject.getTopLevelScope(state.scope);
                ContinuationInterpreter.setInterpreterSourceFile(cx, state.theData.itsSourceFile);
                byte[] iCode = state.theData.itsICode;
                String[] strings = state.theData.itsStringTable;
                int iCodeLength = state.theData.itsICodeTop;
                String name = null;
                int LOCAL_SHFT = state.LOCAL_SHFT();
                int TRY_SCOPE_SHFT = state.TRY_SCOPE_SHFT();
                currentContinuation = null;
                try {
                    block109: while (true) {
                        if (continuationException != null) {
                            Object exc = continuationException.getException();
                            continuationException = null;
                            throw new JavaScriptException(exc);
                        }
                        int ic = iCode[state.pc] & 0xFF;
                        switch (ic) {
                            case 247: 
                            case 248: 
                            case 249: {
                                if (state.scope instanceof NativeCall) {
                                    ScriptRuntime.popActivation(cx);
                                }
                                if (cx.getDebugger() == null || state.frame == null) return null;
                                state.frame.onExit(cx, false, Undefined.instance);
                                state.frame = null;
                                return null;
                            }
                            case 76: {
                                int tryStackTop = state.tryStackTop + TRY_SCOPE_SHFT;
                                if (tryStackTop >= 0 && tryStackTop < state.stack.length) {
                                    state.stack[state.tryStackTop + TRY_SCOPE_SHFT] = null;
                                }
                                --state.tryStackTop;
                                break;
                            }
                            case 75: {
                                int i = ContinuationInterpreter.getTarget(iCode, state.pc + 1);
                                if (i == state.pc) {
                                    i = 0;
                                }
                                state.catchStack[state.tryStackTop * 2] = i;
                                i = ContinuationInterpreter.getTarget(iCode, state.pc + 3);
                                if (i == state.pc + 2) {
                                    i = 0;
                                }
                                state.catchStack[state.tryStackTop * 2 + 1] = i;
                                state.stack[TRY_SCOPE_SHFT + state.tryStackTop] = state.scope;
                                ++state.tryStackTop;
                                state.pc += 4;
                                break;
                            }
                            case 19: {
                                boolean valBln;
                                double lDbl;
                                double rDbl;
                                Object rhs = state.stack[state.stackTop];
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                    rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop + 1);
                                    lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                    valBln = rDbl == rDbl && lDbl == lDbl && rDbl <= lDbl;
                                } else {
                                    valBln = 1 == ScriptRuntime.cmp_LE(rhs, lhs);
                                }
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 17: {
                                boolean valBln;
                                double lDbl;
                                double rDbl;
                                --state.stackTop;
                                Object rhs = state.stack[state.stackTop + 1];
                                Object lhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                    rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop + 1);
                                    lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                    valBln = rDbl == rDbl && lDbl == lDbl && lDbl <= rDbl;
                                } else {
                                    valBln = 1 == ScriptRuntime.cmp_LE(lhs, rhs);
                                }
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 18: {
                                boolean valBln;
                                double lDbl;
                                double rDbl;
                                --state.stackTop;
                                Object rhs = state.stack[state.stackTop + 1];
                                Object lhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                    rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop + 1);
                                    lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                    valBln = rDbl == rDbl && lDbl == lDbl && rDbl < lDbl;
                                } else {
                                    valBln = 1 == ScriptRuntime.cmp_LT(rhs, lhs);
                                }
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 16: {
                                boolean valBln;
                                double lDbl;
                                double rDbl;
                                --state.stackTop;
                                Object rhs = state.stack[state.stackTop + 1];
                                Object lhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                    rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop + 1);
                                    lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                    valBln = rDbl == rDbl && lDbl == lDbl && lDbl < rDbl;
                                } else {
                                    valBln = 1 == ScriptRuntime.cmp_LT(lhs, rhs);
                                }
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 63: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                boolean valBln = ScriptRuntime.in(lhs, rhs, state.scope);
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 64: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                boolean valBln = ScriptRuntime.instanceOf(state.scope, lhs, rhs);
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 14: {
                                --state.stackTop;
                                boolean valBln = ContinuationInterpreter.do_eq(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 15: {
                                --state.stackTop;
                                boolean valBln = !ContinuationInterpreter.do_eq(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 53: {
                                --state.stackTop;
                                boolean valBln = ContinuationInterpreter.do_sheq(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 54: {
                                --state.stackTop;
                                boolean valBln = !ContinuationInterpreter.do_sheq(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                                break;
                            }
                            case 8: {
                                double valDbl;
                                Object val = state.stack[state.stackTop];
                                boolean valBln = val != DBL_MRK ? !ScriptRuntime.toBoolean(val) : (valDbl = state.sDbl[state.stackTop]) != valDbl || valDbl == 0.0;
                                --state.stackTop;
                                if (valBln) {
                                    state.pc = ContinuationInterpreter.getTarget(iCode, state.pc + 1);
                                    continue block109;
                                }
                                state.pc += 2;
                                break;
                            }
                            case 7: {
                                double valDbl;
                                Object val = state.stack[state.stackTop];
                                boolean valBln = val != DBL_MRK ? ScriptRuntime.toBoolean(val) : (valDbl = state.sDbl[state.stackTop]) == valDbl && valDbl != 0.0;
                                --state.stackTop;
                                if (valBln) {
                                    state.pc = ContinuationInterpreter.getTarget(iCode, state.pc + 1);
                                    continue block109;
                                }
                                state.pc += 2;
                                break;
                            }
                            case 6: {
                                state.pc = ContinuationInterpreter.getTarget(iCode, state.pc + 1);
                                continue block109;
                            }
                            case 65: {
                                state.sDbl[++state.stackTop] = state.pc + 3;
                                state.pc = ContinuationInterpreter.getTarget(iCode, state.pc + 1);
                                continue block109;
                            }
                            case 66: {
                                int slot = iCode[state.pc + 1] & 0xFF;
                                state.pc = (int)state.varDbl[LOCAL_SHFT + slot];
                                continue block109;
                            }
                            case 57: {
                                --state.stackTop;
                                break;
                            }
                            case 9: {
                                state.stack[state.stackTop + 1] = state.stack[state.stackTop];
                                state.sDbl[state.stackTop + 1] = state.sDbl[state.stackTop];
                                ++state.stackTop;
                                break;
                            }
                            case 2: {
                                result = state.stack[state.stackTop];
                                if (result == DBL_MRK) {
                                    result = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                break;
                            }
                            case 5: {
                                result = state.stack[state.stackTop];
                                if (result == DBL_MRK) {
                                    result = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                break block255;
                            }
                            case 152: {
                                result = undefined;
                            }
                            case 153: {
                                break block255;
                            }
                            case 28: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = ~rIntValue;
                                break;
                            }
                            case 13: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                int lIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lIntValue & rIntValue;
                                break;
                            }
                            case 11: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                int lIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lIntValue | rIntValue;
                                break;
                            }
                            case 12: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                int lIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lIntValue ^ rIntValue;
                                break;
                            }
                            case 20: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                int lIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lIntValue << rIntValue;
                                break;
                            }
                            case 21: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                int lIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lIntValue >> rIntValue;
                                break;
                            }
                            case 22: {
                                int rIntValue = ContinuationInterpreter.stack_int32(state.stack, state.sDbl, state.stackTop) & 0x1F;
                                --state.stackTop;
                                double lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                                break;
                            }
                            case 23: {
                                --state.stackTop;
                                ContinuationInterpreter.do_add(state.stack, state.sDbl, state.stackTop);
                                break;
                            }
                            case 24: {
                                double rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                double lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lDbl - rDbl;
                                break;
                            }
                            case 29: {
                                double rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = -rDbl;
                                break;
                            }
                            case 58: {
                                double rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = rDbl;
                                break;
                            }
                            case 25: {
                                double rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                double lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lDbl * rDbl;
                                break;
                            }
                            case 26: {
                                double rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                double lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lDbl / rDbl;
                                break;
                            }
                            case 27: {
                                double rDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                --state.stackTop;
                                double lDbl = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop);
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = lDbl % rDbl;
                                break;
                            }
                            case 61: {
                                name = strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)];
                                state.stack[++state.stackTop] = ScriptRuntime.bind(state.scope, name);
                                state.pc += 2;
                                break;
                            }
                            case 71: {
                                name = strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)];
                                state.stack[++state.stackTop] = ScriptRuntime.getBase(state.scope, name);
                                state.pc += 2;
                                break;
                            }
                            case 10: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                state.stack[state.stackTop] = ScriptRuntime.setName((Scriptable)lhs, rhs, state.scope, strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)]);
                                state.pc += 2;
                                break;
                            }
                            case 31: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.delete(lhs, rhs);
                                break;
                            }
                            case 39: {
                                name = (String)state.stack[state.stackTop];
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs instanceof Arguments && name.equals("continuation")) {
                                    if (currentContinuation == null) {
                                        InterpreterState caller2 = state.caller;
                                        if (caller2 != null) {
                                            caller2.readLock();
                                        }
                                        Continuation cont = new Continuation(cx, caller2);
                                        cont.setParentScope(caller2 == null ? ScriptableObject.getTopLevelScope(state.scope) : ScriptableObject.getTopLevelScope(caller2.scope));
                                        cont.setPrototype(Continuation_prototype);
                                        currentContinuation = cont;
                                    }
                                    state.stack[state.stackTop] = currentContinuation;
                                    break;
                                }
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.getProp(lhs, name, state.scope);
                                break;
                            }
                            case 40: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                name = (String)state.stack[state.stackTop];
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.setProp(lhs, name, rhs, state.scope);
                                break;
                            }
                            case 41: {
                                double valDbl;
                                int i;
                                Object lhs = state.stack[state.stackTop - 1];
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK && lhs instanceof String && (double)(i = (int)(valDbl = state.sDbl[state.stackTop])) == valDbl) {
                                    result = undefined;
                                    String str = (String)lhs;
                                    if (i >= 0 && i < str.length()) {
                                        result = str.substring(i, i + 1);
                                    }
                                    state.stack[--state.stackTop] = result;
                                    break;
                                }
                                ContinuationInterpreter.do_getElem(cx, state.stack, state.sDbl, state.stackTop, state.scope);
                                --state.stackTop;
                                break;
                            }
                            case 42: {
                                ContinuationInterpreter.do_setElem(cx, state.stack, state.sDbl, state.stackTop, state.scope);
                                state.stackTop -= 2;
                                break;
                            }
                            case 34: {
                                name = (String)state.stack[state.stackTop];
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.postIncrement(lhs, name, state.scope);
                                break;
                            }
                            case 37: {
                                name = (String)state.stack[state.stackTop];
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.postDecrement(lhs, name, state.scope);
                                break;
                            }
                            case 35: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.postIncrementElem(lhs, rhs, state.scope);
                                break;
                            }
                            case 38: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.postDecrementElem(lhs, rhs, state.scope);
                                break;
                            }
                            case 68: {
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.getThis((Scriptable)lhs);
                                break;
                            }
                            case 69: {
                                int slot = iCode[++state.pc] & 0xFF;
                                state.vars[LOCAL_SHFT + slot] = state.stack[state.stackTop];
                                state.varDbl[LOCAL_SHFT + slot] = state.sDbl[state.stackTop];
                                break;
                            }
                            case 70: {
                                int slot = iCode[++state.pc] & 0xFF;
                                ++state.stackTop;
                                state.stack[state.stackTop] = state.vars[LOCAL_SHFT + slot];
                                state.sDbl[state.stackTop] = state.varDbl[LOCAL_SHFT + slot];
                                break;
                            }
                            case 67: {
                                InterpretedScriptImpl script;
                                int lineNum;
                                int i;
                                state.lineno = lineNum = ContinuationInterpreter.getShort(iCode, state.pc + 1);
                                ContinuationInterpreter.setInterpreterLine(cx, lineNum);
                                name = strings[ContinuationInterpreter.getShort(iCode, state.pc + 3)];
                                int count = ContinuationInterpreter.getShort(iCode, state.pc + 5);
                                Object[] outArgs = ContinuationInterpreter.getArgsArray(state.stack, state.sDbl, state.stackTop, count);
                                state.stackTop -= count;
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                for (i = state.stackTop; i < state.theData.itsMaxStack; ++i) {
                                    state.stack[i] = null;
                                }
                                if (lhs == Function_eval && (script = InterpretedScriptImpl.createEvalSpecial(cx, state.scope, rhs, outArgs, name, lineNum)) != null) {
                                    InterpreterState calleeState = ContinuationInterpreter.newInterpreterState();
                                    script.init(calleeState, cx, rhs, new Object[0], state.scope);
                                    state.pc += 7;
                                    stk.push(calleeState);
                                    if (cx.getDebugger() == null) continue block108;
                                    calleeState.frame = ContinuationInterpreter.enterFrame(cx, calleeState.scope, calleeState.thisObj, calleeState.getArguments(), (DebuggableScript)((Object)calleeState.fnOrScript), calleeState.theData);
                                    continue block108;
                                }
                                String popFile = ContinuationInterpreter.getInterpreterSourceFile(cx);
                                int popLine = ContinuationInterpreter.getInterpreterLine(cx);
                                state.stack[state.stackTop] = ScriptRuntime.callSpecial(cx, lhs, rhs, outArgs, state.thisObj, state.scope, name, lineNum);
                                ContinuationInterpreter.setInterpreterSourceFile(cx, popFile);
                                ContinuationInterpreter.setInterpreterLine(cx, popLine);
                                state.pc += 6;
                                break;
                            }
                            case 43: 
                            case 253: 
                            case 254: {
                                InterpreterState caller3;
                                Object arg;
                                boolean interp;
                                int i;
                                int count = ContinuationInterpreter.getShort(iCode, state.pc + 3);
                                Object[] outArgs = ContinuationInterpreter.getArgsArray(state.stack, state.sDbl, state.stackTop, count);
                                state.stackTop -= count;
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                if (lhs == undefined && (i = ContinuationInterpreter.getShort(iCode, state.pc + 1)) != -1) {
                                    lhs = strings[i];
                                }
                                Scriptable calleeScope = state.scope;
                                if (state.theData.itsNeedsActivation) {
                                    calleeScope = topScope;
                                }
                                if (!(interp = lhs instanceof Interpreted)) {
                                    Scriptable s2;
                                    Object[] newArgs;
                                    Scriptable newThis;
                                    Object defval;
                                    Object[] args;
                                    Scriptable scope;
                                    if (Function_call == lhs) {
                                        scope = calleeScope;
                                        Scriptable thisObj = (Scriptable)rhs;
                                        args = outArgs;
                                        defval = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
                                        newThis = thisObj;
                                        newArgs = outArgs;
                                        if (args.length == 0) {
                                            s2 = ScriptRuntime.toObject(cx, scope, defval);
                                            newThis = scope = s2.getParentScope();
                                        } else {
                                            newThis = args[0] == null ? topScope : ScriptRuntime.toObject(cx, scope, args[0]);
                                            newArgs = new Object[args.length - 1];
                                            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                                        }
                                        lhs = defval;
                                        rhs = newThis;
                                        outArgs = newArgs;
                                        calleeScope = scope;
                                    } else if (Function_apply == lhs) {
                                        scope = calleeScope;
                                        Scriptable thisObj = (Scriptable)rhs;
                                        args = outArgs;
                                        defval = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
                                        newThis = thisObj;
                                        newArgs = outArgs;
                                        if (args.length < 2) {
                                            if (args.length == 0) {
                                                s2 = ScriptRuntime.toObject(cx, scope, defval);
                                                newThis = scope = s2.getParentScope();
                                            } else {
                                                newThis = args[0] == null ? topScope : ScriptRuntime.toObject(cx, scope, args[0]);
                                                newArgs = new Object[args.length - 1];
                                                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                                            }
                                        } else {
                                            Scriptable scriptable = newThis = args[0] == null ? ScriptableObject.getTopLevelScope(thisObj) : ScriptRuntime.toObject(cx, scope, args[0]);
                                            if (args.length > 1) {
                                                if (!(args[1] instanceof NativeArray) && !(args[1] instanceof Arguments)) throw NativeGlobal.typeError0("msg.arg.isnt.array", thisObj);
                                                newArgs = cx.getElements((Scriptable)args[1]);
                                            } else {
                                                newArgs = ScriptRuntime.emptyArgs;
                                            }
                                        }
                                        lhs = defval;
                                        rhs = newThis;
                                        outArgs = newArgs;
                                        calleeScope = scope;
                                    }
                                    if (lhs instanceof Continuation) {
                                        arg = outArgs.length < 1 ? undefined : outArgs[0];
                                        InterpreterState s3 = state;
                                        while (s3 != null) {
                                            if (s3.theData.itsNeedsActivation) {
                                                ScriptRuntime.popActivation(cx);
                                            }
                                            s3 = s3.caller;
                                        }
                                        if (cx.getDebugger() != null) {
                                            s3 = state;
                                            while (s3 != null) {
                                                if (s3.frame != null) {
                                                    s3.frame.onExit(cx, false, Undefined.instance);
                                                    s3.frame = null;
                                                }
                                                s3 = s3.caller;
                                            }
                                        }
                                        state.writeUnlock();
                                        InterpreterState.terminate(cx, state);
                                        Continuation cont = (Continuation)lhs;
                                        InterpreterState dup = cont.getInterpreterState(cx);
                                        if (dup == null) {
                                            return arg;
                                        }
                                        dup = dup.writeLock();
                                        if (dup.ctor && (!(arg instanceof Scriptable) || arg == undefined)) {
                                            arg = dup.thisObj;
                                        }
                                        if (dup.stackTop >= 0) {
                                            dup.stack[dup.stackTop] = arg;
                                        }
                                        stk.replace(dup);
                                        s3 = dup;
                                        NativeCall caller4 = null;
                                        NativeCall callee2 = null;
                                        while (s3 != null) {
                                            NativeCall tmp;
                                            if (s3.scope instanceof NativeCall && (tmp = (NativeCall)s3.scope) != caller4) {
                                                tmp.caller = caller4;
                                                caller4 = tmp;
                                                if (callee2 == null) {
                                                    callee2 = tmp;
                                                }
                                            }
                                            s3 = s3.caller;
                                        }
                                        if (cx.getDebugger() != null) {
                                            s3 = dup;
                                            while (s3 != null) {
                                                s3.frame = ContinuationInterpreter.enterFrame(cx, s3.scope, s3.thisObj, s3.getArguments(), (DebuggableScript)((Object)s3.fnOrScript), s3.theData);
                                                s3 = s3.caller;
                                            }
                                        }
                                        if (caller4 != null && ContinuationInterpreter.getCurrentActivation(cx) != callee2) {
                                            caller4.caller = ContinuationInterpreter.getCurrentActivation(cx);
                                            ContinuationInterpreter.setCurrentActivation(cx, callee2);
                                        }
                                        dup.writeUnlock();
                                        if (!(arg instanceof ContinuationException)) continue block108;
                                        continuationException = (ContinuationException)arg;
                                        continue block108;
                                    }
                                    interp = lhs instanceof Interpreted;
                                }
                                if (interp) {
                                    int op = ic;
                                    switch (op) {
                                        case 253: 
                                        case 254: {
                                            break;
                                        }
                                        default: {
                                            if (cx.getDebugger() != null) break;
                                            op = state.checkTail();
                                        }
                                    }
                                    if (op == 254) {
                                        if (state.theData.itsNeedsActivation) {
                                            ScriptRuntime.popActivation(cx);
                                        }
                                        state.ctor = false;
                                        if (lhs instanceof InterpretedFunctionImpl) {
                                            ((InterpretedFunctionImpl)lhs).init(state, cx, rhs, outArgs, calleeScope);
                                        } else {
                                            ((InterpretedScriptImpl)lhs).init(state, cx, rhs, outArgs, calleeScope);
                                        }
                                        state.writeUnlock();
                                        continue block108;
                                    }
                                    state.clearStack();
                                    InterpreterState callee3 = ContinuationInterpreter.newInterpreterState();
                                    if (lhs instanceof InterpretedFunctionImpl) {
                                        ((InterpretedFunctionImpl)lhs).init(callee3, cx, rhs, outArgs, calleeScope);
                                    } else {
                                        ((InterpretedScriptImpl)lhs).init(callee3, cx, rhs, outArgs, calleeScope);
                                    }
                                    state.pc += 5;
                                    if (cx.getDebugger() != null) {
                                        callee3.frame = ContinuationInterpreter.enterFrame(cx, callee3.scope, callee3.thisObj, callee3.getArguments(), (DebuggableScript)((Object)callee3.fnOrScript), callee3.theData);
                                    }
                                    stk.push(callee3);
                                    continue block108;
                                }
                                if (lhs == Continuation_ctor) {
                                    if (currentContinuation == null) {
                                        caller3 = state.caller;
                                        if (caller3 != null) {
                                            caller3.readLock();
                                        }
                                        Continuation cont = new Continuation(cx, caller3);
                                        cont.setParentScope(caller3 == null ? ScriptableObject.getTopLevelScope(state.scope) : ScriptableObject.getTopLevelScope(caller3.scope));
                                        cont.setPrototype(Continuation_prototype);
                                        currentContinuation = cont;
                                    }
                                    state.stack[state.stackTop] = currentContinuation;
                                    state.pc += 5;
                                    continue block109;
                                }
                                if (lhs == ContinuationException_ctor) {
                                    arg = undefined;
                                    if (outArgs.length > 0) {
                                        arg = outArgs[0];
                                    }
                                    ContinuationException obj = new ContinuationException(arg);
                                    obj.setParentScope(topScope);
                                    obj.setPrototype(ContinuationException_prototype);
                                    state.stack[state.stackTop] = obj;
                                    state.pc += 5;
                                    continue block109;
                                }
                                state.clearStack();
                                String popFile = ContinuationInterpreter.getInterpreterSourceFile(cx);
                                int popLine = ContinuationInterpreter.getInterpreterLine(cx);
                                state.stack[state.stackTop] = ScriptRuntime.call(cx, lhs, rhs, outArgs, calleeScope);
                                ContinuationInterpreter.setInterpreterSourceFile(cx, popFile);
                                ContinuationInterpreter.setInterpreterLine(cx, popLine);
                                state.pc += 4;
                                break;
                            }
                            case 30: {
                                InterpreterState caller3;
                                int count = ContinuationInterpreter.getShort(iCode, state.pc + 3);
                                Object[] outArgs = ContinuationInterpreter.getArgsArray(state.stack, state.sDbl, state.stackTop, count);
                                state.stackTop -= count;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.clearStack();
                                if (lhs == undefined && ContinuationInterpreter.getShort(iCode, state.pc + 1) != -1) {
                                    lhs = strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)];
                                } else {
                                    if (lhs == Continuation_ctor) {
                                        if (currentContinuation == null) {
                                            caller3 = state.caller;
                                            if (caller3 != null) {
                                                caller3.readLock();
                                            }
                                            Continuation cont = new Continuation(cx, caller3);
                                            cont.setParentScope(caller3 == null ? ScriptableObject.getTopLevelScope(state.scope) : ScriptableObject.getTopLevelScope(caller3.scope));
                                            cont.setPrototype(Continuation_prototype);
                                            currentContinuation = cont;
                                        }
                                        state.stack[state.stackTop] = currentContinuation;
                                        state.pc += 5;
                                        continue block109;
                                    }
                                    if (lhs == ContinuationException_ctor) {
                                        if (outArgs.length < 1) {
                                            throw new JavaScriptException((Object)"expected an argument");
                                        }
                                        ContinuationException obj = new ContinuationException(outArgs[0]);
                                        obj.setParentScope(topScope);
                                        obj.setPrototype(ContinuationException_prototype);
                                        state.stack[state.stackTop] = obj;
                                        state.pc += 5;
                                        continue block109;
                                    }
                                    if (lhs instanceof InterpretedFunctionImpl) {
                                        InterpretedFunctionImpl f = (InterpretedFunctionImpl)lhs;
                                        InterpreterState calleeState = ContinuationInterpreter.newInterpreterState();
                                        f.newInstance(calleeState, cx, state.scope, outArgs);
                                        state.pc += 5;
                                        if (cx.getDebugger() != null) {
                                            calleeState.frame = ContinuationInterpreter.enterFrame(cx, calleeState.scope, calleeState.thisObj, calleeState.getArguments(), (DebuggableScript)((Object)calleeState.fnOrScript), calleeState.theData);
                                        }
                                        stk.push(calleeState);
                                        continue block108;
                                    }
                                }
                                state.stack[state.stackTop] = ScriptRuntime.newObject(cx, lhs, outArgs, state.scope);
                                state.pc += 4;
                                break;
                            }
                            case 32: {
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.typeof(lhs);
                                break;
                            }
                            case 78: {
                                name = strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)];
                                state.stack[++state.stackTop] = ScriptRuntime.typeofName(state.scope, name);
                                state.pc += 2;
                                break;
                            }
                            case 46: {
                                state.stack[++state.stackTop] = strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)];
                                state.pc += 2;
                                break;
                            }
                            case 150: {
                                ++state.stackTop;
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = ContinuationInterpreter.getShort(iCode, state.pc + 1);
                                state.pc += 2;
                                break;
                            }
                            case 151: {
                                ++state.stackTop;
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = ContinuationInterpreter.getInt(iCode, state.pc + 1);
                                state.pc += 4;
                                break;
                            }
                            case 45: {
                                ++state.stackTop;
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = state.theData.itsDoubleTable[ContinuationInterpreter.getShort(iCode, state.pc + 1)];
                                state.pc += 2;
                                break;
                            }
                            case 44: {
                                state.stack[++state.stackTop] = ScriptRuntime.name(state.scope, strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)]);
                                state.pc += 2;
                                break;
                            }
                            case 33: {
                                state.stack[++state.stackTop] = ScriptRuntime.postIncrement(state.scope, strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)]);
                                state.pc += 2;
                                break;
                            }
                            case 36: {
                                state.stack[++state.stackTop] = ScriptRuntime.postDecrement(state.scope, strings[ContinuationInterpreter.getShort(iCode, state.pc + 1)]);
                                state.pc += 2;
                                break;
                            }
                            case 73: {
                                int slot = iCode[++state.pc] & 0xFF;
                                state.vars[slot] = state.stack[state.stackTop];
                                state.varDbl[slot] = state.sDbl[state.stackTop];
                                break;
                            }
                            case 252: {
                                Object val;
                                int slot = iCode[++state.pc] & 0xFF;
                                ++state.stackTop;
                                state.stack[state.stackTop] = val = state.vars[slot];
                                state.vars[slot] = null;
                                state.sDbl[state.stackTop] = state.varDbl[slot];
                                break;
                            }
                            case 251: {
                                int slot = iCode[++state.pc] & 0xFF;
                                Object val = state.vars[slot += LOCAL_SHFT];
                                ++state.stackTop;
                                state.stack[state.stackTop] = ScriptRuntime.nextEnum((Enumeration)val);
                                state.stack[slot] = null;
                                break;
                            }
                            case 250: {
                                Object val;
                                int slot = iCode[++state.pc] & 0xFF;
                                ++state.stackTop;
                                state.stack[state.stackTop] = val = state.vars[slot += LOCAL_SHFT];
                                state.vars[slot] = null;
                                state.sDbl[state.stackTop] = state.varDbl[slot];
                                break;
                            }
                            case 72: {
                                int slot = iCode[++state.pc] & 0xFF;
                                ++state.stackTop;
                                state.stack[state.stackTop] = state.vars[slot];
                                state.sDbl[state.stackTop] = state.varDbl[slot];
                                break;
                            }
                            case 59: {
                                int slot = iCode[++state.pc] & 0xFF;
                                ++state.stackTop;
                                state.stack[state.stackTop] = state.vars[slot];
                                state.sDbl[state.stackTop] = state.varDbl[slot];
                                state.vars[slot] = DBL_MRK;
                                state.varDbl[slot] = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop) + 1.0;
                                break;
                            }
                            case 60: {
                                int slot = iCode[++state.pc] & 0xFF;
                                ++state.stackTop;
                                state.stack[state.stackTop] = state.vars[slot];
                                state.sDbl[state.stackTop] = state.varDbl[slot];
                                state.vars[slot] = DBL_MRK;
                                state.varDbl[slot] = ContinuationInterpreter.stack_double(state.stack, state.sDbl, state.stackTop) - 1.0;
                                break;
                            }
                            case 47: {
                                ++state.stackTop;
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = 0.0;
                                break;
                            }
                            case 48: {
                                ++state.stackTop;
                                state.stack[state.stackTop] = DBL_MRK;
                                state.sDbl[state.stackTop] = 1.0;
                                break;
                            }
                            case 49: {
                                state.stack[++state.stackTop] = null;
                                break;
                            }
                            case 50: {
                                state.stack[++state.stackTop] = state.thisObj;
                                break;
                            }
                            case 87: {
                                state.stack[++state.stackTop] = state.fnOrScript;
                                break;
                            }
                            case 51: {
                                state.stack[++state.stackTop] = Boolean.FALSE;
                                break;
                            }
                            case 52: {
                                state.stack[++state.stackTop] = Boolean.TRUE;
                                break;
                            }
                            case 74: {
                                state.stack[++state.stackTop] = Undefined.instance;
                                break;
                            }
                            case 62: {
                                result = state.stack[state.stackTop];
                                if (result == DBL_MRK) {
                                    result = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                throw new JavaScriptException(result);
                            }
                            case 88: {
                                result = state.stack[state.stackTop];
                                --state.stackTop;
                                if (!(result instanceof JavaScriptException)) throw (RuntimeException)result;
                                throw (JavaScriptException)result;
                            }
                            case 3: {
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                state.scope = ScriptRuntime.enterWith(lhs, state.scope);
                                break;
                            }
                            case 4: {
                                state.scope = ScriptRuntime.leaveWith(state.scope);
                                break;
                            }
                            case 77: {
                                state.stack[++state.stackTop] = ScriptRuntime.newScope();
                                break;
                            }
                            case 79: {
                                int slot = iCode[++state.pc] & 0xFF;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                state.vars[LOCAL_SHFT + slot] = ScriptRuntime.initEnum(lhs, state.scope);
                                break;
                            }
                            case 80: {
                                int slot = iCode[++state.pc] & 0xFF;
                                Object val = state.vars[LOCAL_SHFT + slot];
                                ++state.stackTop;
                                state.stack[state.stackTop] = ScriptRuntime.nextEnum((Enumeration)val);
                                break;
                            }
                            case 81: {
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.getProto(lhs, state.scope);
                                break;
                            }
                            case 82: {
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.getParent(lhs);
                                break;
                            }
                            case 86: {
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.getParent(lhs, state.scope);
                                break;
                            }
                            case 83: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.setProto(lhs, rhs, state.scope);
                                break;
                            }
                            case 84: {
                                Object rhs = state.stack[state.stackTop];
                                if (rhs == DBL_MRK) {
                                    rhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                --state.stackTop;
                                Object lhs = state.stack[state.stackTop];
                                if (lhs == DBL_MRK) {
                                    lhs = ContinuationInterpreter.doubleWrap(state.sDbl[state.stackTop]);
                                }
                                state.stack[state.stackTop] = ScriptRuntime.setParent(lhs, rhs, state.scope);
                                break;
                            }
                            case 85: {
                                state.stack[++state.stackTop] = state.scope;
                                break;
                            }
                            case 55: {
                                int i = ContinuationInterpreter.getShort(iCode, state.pc + 1);
                                Scriptable closureScope = state.scope;
                                if (closureScope.getParentScope() == null) {
                                    closureScope = null;
                                }
                                state.stack[++state.stackTop] = new InterpretedFunctionImpl(state.theData.itsNestedFunctions[i], closureScope, cx);
                                ContinuationInterpreter.createFunctionObject((InterpretedFunction)state.stack[state.stackTop], state.scope, state.theData.itsNestedFunctions[i].getPrototype(), state.theData.itsFromEvalCode, true);
                                state.pc += 2;
                                break;
                            }
                            case 56: {
                                int i = ContinuationInterpreter.getShort(iCode, state.pc + 1);
                                state.stack[++state.stackTop] = state.theData.itsRegExpLiterals[i];
                                state.pc += 2;
                                break;
                            }
                            case 148: {
                                ContinuationInterpreter.setInterpreterSourceFile(cx, state.theData.itsSourceFile);
                                break;
                            }
                            case 147: 
                            case 149: {
                                int i;
                                state.lineno = i = ContinuationInterpreter.getShort(iCode, state.pc + 1);
                                ContinuationInterpreter.setInterpreterLine(cx, i);
                                if (state.frame != null) {
                                    state.frame.onLineChange(cx, i, ic == 149);
                                }
                                state.pc += 2;
                                break;
                            }
                            default: {
                                ContinuationInterpreter.dumpICode(state.theData);
                                throw new Error("Unknown icode : " + (iCode[state.pc] & 0xFF) + " @ state.pc : " + state.pc);
                            }
                        }
                        ++state.pc;
                    }
                }
                catch (Throwable ex) {
                    int exType;
                    Object errObj;
                    block256: {
                        block257: {
                            boolean SCRIPT_THROW = false;
                            boolean ECMA = true;
                            int RUNTIME = 2;
                            int OTHER = 3;
                            while (true) {
                                if (ex instanceof JavaScriptException) {
                                    errObj = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)ex);
                                    if (errObj instanceof NativeError) {
                                        NativeError err = (NativeError)errObj;
                                        Object sourceName = err.get("sourceName", (Scriptable)err);
                                        Object lineNum = err.get("lineNumber", (Scriptable)err);
                                        ex = new EcmaError(err, Context.toString(sourceName), (int)Context.toNumber(lineNum), 0, null);
                                        exType = 1;
                                    } else {
                                        exType = 0;
                                    }
                                    break block256;
                                }
                                if (ex instanceof EcmaError) {
                                    EcmaError ecmaErr = (EcmaError)ex;
                                    Scriptable nativeErr = ecmaErr.getErrorObject();
                                    nativeErr.put("sourceName", nativeErr, (Object)ecmaErr.getSourceName());
                                    nativeErr.put("lineNumber", nativeErr, (Object)new Integer(ecmaErr.getLineNumber()));
                                    errObj = nativeErr;
                                    exType = 1;
                                    break block256;
                                }
                                if (!(ex instanceof WrappedException)) break block257;
                                Object w = ((WrappedException)ex).unwrap();
                                if (!(w instanceof Throwable)) break;
                                ex = (Throwable)w;
                            }
                            errObj = ex;
                            exType = 2;
                            break block256;
                        }
                        if (ex instanceof RuntimeException) {
                            errObj = ex;
                            exType = 2;
                        } else {
                            errObj = ex;
                            exType = 3;
                        }
                    }
                    if (exType != 3 && state.frame != null) {
                        state.frame.onExceptionThrown(cx, ex);
                    }
                    if (continuation) {
                        state.writeUnlock();
                        if (ex instanceof JavaScriptException) {
                            throw (JavaScriptException)ex;
                        }
                        if (!(ex instanceof RuntimeException)) throw (Error)ex;
                        throw (RuntimeException)ex;
                    }
                    boolean rethrow = true;
                    Vector<Object> stackTrace = new Vector<Object>();
                    if (exType != 3) {
                        do {
                            if (state.tryStackTop > 0) {
                                --state.tryStackTop;
                                break;
                            }
                            if (state.theData.itsNeedsActivation) {
                                ScriptRuntime.popActivation(cx);
                            }
                            if (state.frame != null) {
                                state.frame.onExit(cx, true, ex);
                                state.frame = null;
                            }
                            stackTrace.addElement(state.theData.itsSourceFile);
                            stackTrace.addElement(state.theData.itsName);
                            stackTrace.addElement(new Integer(state.lineno));
                            stk.pop();
                        } while ((state = stk.top()) != null);
                        if (state != null) {
                            if (exType == 0 || exType == 1) {
                                state.pc = state.catchStack[state.tryStackTop * 2];
                                if (state.pc != 0) {
                                    rethrow = false;
                                }
                            }
                            if (rethrow) {
                                state.pc = state.catchStack[state.tryStackTop * 2 + 1];
                                if (state.pc != 0) {
                                    rethrow = false;
                                    errObj = ex;
                                }
                            }
                        }
                    }
                    if (rethrow) {
                        while (state != null) {
                            if (state.theData.itsNeedsActivation) {
                                ScriptRuntime.popActivation(cx);
                            }
                            if (state.frame != null) {
                                state.frame.onExit(cx, true, ex);
                                state.frame = null;
                            }
                            stackTrace.addElement(state.theData.itsSourceFile);
                            stackTrace.addElement(state.theData.itsName);
                            stackTrace.addElement(new Integer(state.lineno));
                            stk.pop();
                            state = stk.top();
                        }
                        cx.setInterpreterStackTrace(stackTrace);
                        if (exType == 0) {
                            JavaScriptException jsex = (JavaScriptException)ex;
                            jsex.setJSStackTrace(stackTrace);
                            throw jsex;
                        }
                        if (!(ex instanceof RuntimeException)) throw (Error)ex;
                        throw (RuntimeException)ex;
                    }
                    state.scope = (Scriptable)state.stack[state.TRY_SCOPE_SHFT() + state.tryStackTop];
                    for (int j = state.TRY_SCOPE_SHFT() + state.tryStackTop; j < state.stack.length; ++j) {
                        state.stack[j] = null;
                    }
                    state.stackTop = 0;
                    state.stack[0] = errObj;
                    state.writeUnlock();
                    ContinuationInterpreter.setInterpreterSourceFile(cx, state.theData.itsSourceFile);
                    ContinuationInterpreter.setInterpreterLine(cx, state.lineno);
                    continue;
                }
            }
            if (state.theData.itsNeedsActivation) {
                ScriptRuntime.popActivation(cx);
            }
            if (state.frame != null) {
                state.frame.onExit(cx, false, result);
                state.frame = null;
            }
            if (state.ctor && (!(result instanceof Scriptable) || result == undefined)) {
                result = state.thisObj;
            }
            stk.pop();
            state = stk.top();
            if (state == null) continue;
            if (state.stackTop >= 0) {
                state.stack[state.stackTop] = result;
            }
            state.writeUnlock();
            ContinuationInterpreter.setInterpreterSourceFile(cx, state.theData.itsSourceFile);
            ContinuationInterpreter.setInterpreterLine(cx, state.lineno);
        }
        return result;
    }

    protected InterpretedFunction newInterpretedFunction(Context cx, InterpreterData itsData, String[] argNames, short argCount) {
        InterpretedFunctionImpl res = new InterpretedFunctionImpl(cx, itsData, argNames, argCount);
        return res;
    }

    protected InterpretedScript newInterpretedScript(Context cx, InterpreterData itsData, String[] argNames, short argCount) {
        InterpretedScriptImpl res = new InterpretedScriptImpl(cx, itsData, argNames, argCount);
        return res;
    }

    protected Interpreter newInterpreter() {
        return new ContinuationInterpreter();
    }

    static void createFunctionObjects(InterpretedFunction[] fn, Scriptable scope) {
        Scriptable proto = ScriptableObject.getClassPrototype(scope, "Function");
        for (int i = 0; i < fn.length; ++i) {
            ContinuationInterpreter.createFunctionObject(fn[i], scope, proto, fn[i].itsData.itsFromEvalCode, false);
        }
    }

    static void createFunctionObject(InterpretedFunction fn, Scriptable scope, Scriptable proto, boolean fromEvalCode, boolean fromClosureInsn) {
        InterpreterData id = fn.itsData;
        fn.setPrototype(proto);
        fn.setParentScope(scope);
        if (id.itsName.length() == 0) {
            return;
        }
        boolean callSetProp = false;
        if (id.itsFunctionType == 1 && (fn.itsClosure == null || fromClosureInsn)) {
            if (fromEvalCode) {
                callSetProp = true;
            } else {
                try {
                    ((ScriptableObject)scope).defineProperty(fn.itsData.itsName, fn, 4);
                }
                catch (ClassCastException e) {
                    callSetProp = true;
                }
            }
        }
        if (id.itsFunctionType == 3 && fn.itsClosure != null) {
            callSetProp = true;
        }
        if (callSetProp) {
            ScriptRuntime.setProp(scope, fn.itsData.itsName, fn, scope);
        }
    }

    static void initFunctionObjects(InterpretedFunction[] fn, Scriptable scope) {
        Scriptable proto = ScriptableObject.getClassPrototype(scope, "Function");
        for (int i = 0; i < fn.length; ++i) {
            ContinuationInterpreter.initFunctionObject(fn[i], scope, proto, fn[i].itsData.itsFromEvalCode);
        }
    }

    static void initFunctionObject(InterpretedFunction fn, Scriptable scope, Scriptable proto, boolean fromEvalCode) {
        InterpreterData id = fn.itsData;
        if (id.itsName.length() == 0) {
            return;
        }
        boolean callSetProp = false;
        if (id.itsFunctionType == 1 && fn.itsClosure == null) {
            if (fromEvalCode) {
                callSetProp = true;
            } else {
                try {
                    ((ScriptableObject)scope).defineProperty(fn.itsData.itsName, fn, 4);
                }
                catch (ClassCastException e) {
                    callSetProp = true;
                }
            }
        }
        if (id.itsFunctionType == 3 && fn.itsClosure != null) {
            callSetProp = true;
        }
        if (callSetProp) {
            ScriptRuntime.setProp(scope, fn.itsData.itsName, fn, scope);
        }
    }

    public Object compile(Context cx, Scriptable scope, Node tree, Object securityDomain, SecuritySupport securitySupport, ClassNameHelper nameHelper) throws IOException {
        Object result = super.compile(cx, scope, tree, securityDomain, securitySupport, nameHelper);
        if (result instanceof InterpretedScriptImpl) {
            InterpreterData theData = ((InterpretedScriptImpl)result).itsData;
        }
        return result;
    }

    protected InterpretedFunction generateFunctionICode(Context cx, Scriptable scope, FunctionNode theFunction, Object securityDomain) {
        InterpretedFunction result = super.generateFunctionICode(cx, scope, theFunction, securityDomain);
        if (result instanceof InterpretedFunctionImpl) {
            InterpreterData theData = ((InterpretedFunctionImpl)result).itsData;
        }
        return result;
    }

    protected void generateICodeFromTree(Node tree, VariableTable varTable, boolean needsActivation, Object securityDomain) {
        int theICodeTop = 0;
        this.itsVariableTable = varTable;
        this.itsData.itsNeedsActivation = needsActivation;
        this.itsBefore = new Vector();
        this.itsAfter = new Vector();
        this.itsReturn = new Vector();
        theICodeTop = this.addShort(0, theICodeTop);
        theICodeTop = this.addShort(0, theICodeTop);
        theICodeTop = this.addShort(0, theICodeTop);
        theICodeTop = this.generateICode(tree, theICodeTop);
        if (!this.itsData.isFunction) {
            theICodeTop = this.addByte(153, theICodeTop);
        }
        Vector before = this.itsBefore;
        Vector after = this.itsAfter;
        Vector ret = this.itsReturn;
        this.itsBefore = null;
        this.itsAfter = null;
        int beforeTarget = theICodeTop;
        if (before.size() + after.size() > 0) {
            ++this.itsData.itsMaxStack;
        }
        if (before.size() > 0) {
            Enumeration e = before.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                theICodeTop = this.updateLineNumber(n, theICodeTop);
                theICodeTop = this.generateICode(n.getFirstChild().getNextSibling(), theICodeTop);
            }
        }
        int afterTarget = theICodeTop = this.addByte(249, theICodeTop);
        if (after.size() > 0) {
            Enumeration e = after.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                theICodeTop = this.updateLineNumber(n, theICodeTop);
                theICodeTop = this.generateICode(n.getFirstChild().getNextSibling(), theICodeTop);
            }
        }
        int returnTarget = theICodeTop = this.addByte(248, theICodeTop);
        if (ret.size() > 0) {
            Enumeration e = ret.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                theICodeTop = this.updateLineNumber(n, theICodeTop);
                theICodeTop = this.generateICode(n.getFirstChild().getNextSibling(), theICodeTop);
            }
        }
        theICodeTop = this.addByte(247, theICodeTop);
        for (int i = 0; i < this.itsLabelTableTop; ++i) {
            this.itsLabelTable[i].fixGotos(this.itsData.itsICode);
        }
        this.setShort(0, beforeTarget);
        this.setShort(2, afterTarget);
        this.setShort(4, returnTarget);
        this.itsData.itsICodeTop = theICodeTop;
        if (this.itsData.itsICode.length != theICodeTop) {
            byte[] tmp = new byte[theICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, theICodeTop);
            this.itsData.itsICode = tmp;
        }
        this.itsData.itsMaxVars = this.itsVariableTable.size();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxTryDepth + this.itsData.itsMaxStack;
    }

    void setShort(int pc, int i) {
        this.itsData.itsICode[pc] = (byte)(i >>> 8 & 0xFF);
        this.itsData.itsICode[pc + 1] = (byte)(i >>> 0 & 0xFF);
    }

    protected int generateICode(Node node, int iCodeTop) {
        int type = node.getType();
        switch (type) {
            case 5: {
                if (this.itsBefore != null) break;
                String message = Context.getMessage("msg.bad.return", null);
                Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                return iCodeTop;
            }
            case 125: {
                Node child = node.getFirstChild();
                Node block = child.getNextSibling();
                if (child.getType() == 122) {
                    if (this.itsBefore == null) {
                        String message = Context.getMessage("msg.continue.outside", null);
                        Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                        return iCodeTop;
                    }
                    this.itsBefore.addElement(node);
                } else if (child.getType() == 121) {
                    if (this.itsAfter == null) {
                        String message = Context.getMessage("msg.bad.break", null);
                        Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                        return iCodeTop;
                    }
                    this.itsAfter.addElement(node);
                } else {
                    if (this.itsReturn == null) {
                        String message = Context.getMessage("msg.bad.return", null);
                        Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                        return iCodeTop;
                    }
                    this.itsReturn.addElement(node);
                }
                return iCodeTop;
            }
        }
        return super.generateICode(node, iCodeTop);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

