/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Vector;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptVariableTable;

public class OptFunctionNode
extends FunctionNode {
    private String itsClassName;
    private boolean itsIsTargetOfDirectCall;
    private boolean itsContainsCalls;
    private boolean[] itsContainsCallsCount = new boolean[4];
    private boolean itsParameterNumberContext;
    private Vector itsDirectCallTargets;

    public OptFunctionNode(String name, Node left, Node right, ClassNameHelper nameHelper) {
        super(name, left, right);
        this.itsVariableTable = new OptVariableTable();
        OptClassNameHelper nh = (OptClassNameHelper)nameHelper;
        this.itsClassName = nh.getJavaScriptClassName(name, false);
    }

    public String getDirectCallParameterSignature() {
        StringBuffer parameterSig = new StringBuffer("(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        int pCount = this.itsVariableTable.getParameterCount();
        for (int i = 0; i < pCount; ++i) {
            parameterSig.append("Ljava/lang/Object;D");
        }
        parameterSig.append("[Ljava/lang/Object;)");
        return parameterSig.toString();
    }

    public String getClassName() {
        return this.itsClassName;
    }

    public boolean isTargetOfDirectCall() {
        return this.itsIsTargetOfDirectCall;
    }

    public void addDirectCallTarget(FunctionNode target) {
        if (this.itsDirectCallTargets == null) {
            this.itsDirectCallTargets = new Vector();
        }
        for (int i = 0; i < this.itsDirectCallTargets.size(); ++i) {
            if ((FunctionNode)this.itsDirectCallTargets.elementAt(i) != target) continue;
            return;
        }
        this.itsDirectCallTargets.addElement(target);
    }

    public Vector getDirectCallTargets() {
        return this.itsDirectCallTargets;
    }

    public void setIsTargetOfDirectCall() {
        this.itsIsTargetOfDirectCall = true;
    }

    public void setParameterNumberContext(boolean b) {
        this.itsParameterNumberContext = b;
    }

    public boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    public boolean containsCalls(int argCount) {
        if (argCount < this.itsContainsCallsCount.length && argCount >= 0) {
            return this.itsContainsCallsCount[argCount];
        }
        return this.itsContainsCalls;
    }

    public void setContainsCalls(int argCount) {
        if (argCount < this.itsContainsCallsCount.length) {
            this.itsContainsCallsCount[argCount] = true;
        }
        this.itsContainsCalls = true;
    }

    public void incrementLocalCount() {
        int localCount = this.getIntProp(22, 0);
        this.putIntProp(22, localCount + 1);
    }
}

