/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Stack;
import org.mozilla.javascript.Node;

public class StmtNodeIterator {
    private Stack itsStack = new Stack();
    private Node itsStart;
    private Node itsCurrentNode;

    public StmtNodeIterator(Node start) {
        this.itsStart = start;
    }

    private Node findFirstInterestingNode(Node theNode) {
        if (theNode == null) {
            return null;
        }
        if (theNode.getType() == 133 || theNode.getType() == 138 || theNode.getType() == 110) {
            if (theNode.getFirst() == null) {
                return this.findFirstInterestingNode(theNode.getNext());
            }
            this.itsStack.push(theNode);
            return this.findFirstInterestingNode(theNode.getFirst());
        }
        return theNode;
    }

    public Node nextNode() {
        if (this.itsCurrentNode == null) {
            this.itsCurrentNode = this.findFirstInterestingNode(this.itsStart);
            return this.itsCurrentNode;
        }
        this.itsCurrentNode = this.itsCurrentNode.getNext();
        if (this.itsCurrentNode == null) {
            while (!this.itsStack.isEmpty()) {
                Node n = (Node)this.itsStack.pop();
                if (n.getNext() == null) continue;
                this.itsCurrentNode = this.findFirstInterestingNode(n.getNext());
                return this.itsCurrentNode;
            }
            return null;
        }
        this.itsCurrentNode = this.findFirstInterestingNode(this.itsCurrentNode);
        return this.itsCurrentNode;
    }
}

