/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.GreedyState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptable
implements Function {
    public static final int GLOB = 1;
    public static final int FOLD = 2;
    public static final int MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    static final int JS_BITS_PER_BYTE = 8;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_END = 43;
    private static final int REOP_FLATLEN_MAX = 255;
    private static int level;
    private static String[] reopname;
    static final String metachars = "|^${*+?().[\\";
    static final String closurechars = "{*+?";
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 6;
    private static final int Id_toString = 7;
    private static final int Id_exec = 8;
    private static final int Id_test = 9;
    private static final int Id_prefix = 10;
    private static final int MAX_PROTOTYPE_ID = 10;
    private boolean prototypeFlag;
    private String source;
    private int lastIndex;
    private int parenCount;
    private byte flags;
    private byte[] program;
    RENode ren;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeRegExp proto = new NativeRegExp();
        proto.prototypeFlag = true;
        proto.setMaxId(10);
        proto.setSealFunctionsFlag(sealed);
        proto.setFunctionParametrs(cx);
        proto.setParentScope(scope);
        proto.setPrototype(NativeRegExp.getObjectPrototype(scope));
        NativeRegExpCtor ctor = new NativeRegExpCtor();
        ctor.setPrototype(NativeRegExp.getClassPrototype(scope, "Function"));
        ctor.setParentScope(scope);
        ctor.setImmunePrototypeProperty(proto);
        if (sealed) {
            proto.sealObject();
            ctor.sealObject();
        }
        NativeRegExp.defineProperty(scope, "RegExp", ctor, 2);
    }

    public NativeRegExp(Context cx, Scriptable scope, String source, String global, boolean flat) {
        this.setMaxId(5);
        this.init(cx, scope, source, global, flat);
    }

    public void init(Context cx, Scriptable scope, String source, String global, boolean flat) {
        this.source = source;
        this.flags = 0;
        if (global != null) {
            for (int i = 0; i < global.length(); ++i) {
                char c = global.charAt(i);
                if (c == 'g') {
                    this.flags = (byte)(this.flags | 1);
                    continue;
                }
                if (c == 'i') {
                    this.flags = (byte)(this.flags | 2);
                    continue;
                }
                if (c == 'm') {
                    this.flags = (byte)(this.flags | 4);
                    continue;
                }
                Object[] errArgs = new Object[]{new Character(c)};
                throw NativeGlobal.constructError(cx, "SyntaxError", ScriptRuntime.getMessage("msg.invalid.re.flag", errArgs), scope);
            }
        }
        CompilerState state = new CompilerState(source, this.flags, cx, scope);
        if (flat) {
            int len;
            this.ren = null;
            int index = 0;
            for (int sourceLen = source.length(); sourceLen > 0; sourceLen -= len) {
                len = sourceLen;
                if (len > 255) {
                    len = 255;
                }
                RENode ren2 = new RENode(state, len == 1 ? (byte)22 : 21, new Integer(index));
                ren2.flags = (byte)4;
                if (len > 1) {
                    ren2.kid2 = index + len;
                } else {
                    ren2.flags = (byte)(ren2.flags | 2);
                    ren2.chr = state.source[index];
                }
                index += len;
                if (this.ren == null) {
                    this.ren = ren2;
                    continue;
                }
                this.setNext(state, this.ren, ren2);
            }
        } else {
            this.ren = this.parseRegExp(state);
        }
        if (this.ren == null) {
            return;
        }
        RENode end = new RENode(state, 43, null);
        this.setNext(state, this.ren, end);
        this.lastIndex = 0;
        this.parenCount = state.parenCount;
        scope = NativeRegExp.getTopLevelScope(scope);
        this.setPrototype(NativeRegExp.getClassPrototype(scope, "RegExp"));
        this.setParentScope(scope);
    }

    public String getClassName() {
        return "RegExp";
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this.execSub(cx, scope, args, 1);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return (Scriptable)this.call(cx, scope, null, args);
    }

    Scriptable compile(Context cx, Scriptable scope, Object[] args) {
        if (args.length > 0 && args[0] instanceof NativeRegExp) {
            if (args.length > 1 && args[1] != Undefined.instance) {
                throw NativeGlobal.constructError(cx, "TypeError", "only one argument may be specified if the first argument is a RegExp object", scope);
            }
            NativeRegExp thatObj = (NativeRegExp)args[0];
            this.source = thatObj.source;
            this.lastIndex = thatObj.lastIndex;
            this.parenCount = thatObj.parenCount;
            this.flags = thatObj.flags;
            this.program = thatObj.program;
            this.ren = thatObj.ren;
            return this;
        }
        String s = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
        String global = args.length > 1 && args[1] != Undefined.instance ? ScriptRuntime.toString(args[1]) : null;
        this.init(cx, scope, s, global, false);
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('/');
        buf.append(this.source);
        buf.append('/');
        if ((this.flags & 1) != 0) {
            buf.append('g');
        }
        if ((this.flags & 2) != 0) {
            buf.append('i');
        }
        if ((this.flags & 4) != 0) {
            buf.append('m');
        }
        return buf.toString();
    }

    NativeRegExp() {
        this.setMaxId(5);
    }

    private static RegExpImpl getImpl(Context cx) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }

    private Object execSub(Context cx, Scriptable scopeObj, Object[] args, int matchType) {
        String str;
        RegExpImpl reImpl = NativeRegExp.getImpl(cx);
        if (args.length == 0) {
            str = reImpl.input;
            if (str == null) {
                Object[] errArgs = new Object[]{this.toString()};
                throw NativeGlobal.constructError(cx, "SyntaxError", ScriptRuntime.getMessage("msg.no.re.input.for", errArgs), scopeObj);
            }
        } else {
            str = ScriptRuntime.toString(args[0]);
        }
        int i = (this.flags & 1) != 0 ? this.lastIndex : 0;
        int[] indexp = new int[]{i};
        Object rval = this.executeRegExp(cx, scopeObj, reImpl, str, indexp, matchType);
        if ((this.flags & 1) != 0) {
            this.lastIndex = rval == null || rval == Undefined.instance ? 0 : indexp[0];
        }
        return rval;
    }

    private Object exec(Context cx, Scriptable scopeObj, Object[] args) {
        return this.execSub(cx, scopeObj, args, 1);
    }

    private Object test(Context cx, Scriptable scopeObj, Object[] args) {
        Object rval = this.execSub(cx, scopeObj, args, 0);
        if (rval == null || !rval.equals(Boolean.TRUE)) {
            rval = Boolean.FALSE;
        }
        return rval;
    }

    private Object prefix(Context cx, Scriptable scopeObj, Object[] args) {
        return this.execSub(cx, scopeObj, args, 2);
    }

    private String getPrintableString(String str) {
        return "";
    }

    private void dumpRegExp(CompilerState state, RENode ren) {
    }

    private void fixNext(CompilerState state, RENode ren1, RENode ren2, RENode oldnext) {
        RENode next;
        boolean goodnext;
        boolean bl = goodnext = ren2 != null && (ren2.flags & 8) == 0;
        while ((next = ren1.next) != null && next != oldnext) {
            if (ren1.op == 1) {
                RENode kid = (RENode)ren1.kid;
                if (kid.op != 23) {
                    RENode ren = kid;
                    while (ren.next != null) {
                        if (ren.op == 1) {
                            throw new RuntimeException("REOP_ALT not expected");
                        }
                        ren = ren.next;
                    }
                    ren.next = new RENode(state, 23, null);
                    ren.next.flags = (byte)(ren.next.flags | 8);
                    ren.flags = (byte)(ren.flags | 0x10);
                    this.fixNext(state, kid, ren2, oldnext);
                }
            }
            ren1 = next;
        }
        if (ren2 != null) {
            ren2.flags = (ren2.flags & 8) == 0 ? (byte)(ren2.flags | 8) : (byte)(ren2.flags | 0x20);
        }
        ren1.next = ren2;
        if (goodnext) {
            ren1.flags = (byte)(ren1.flags | 0x10);
        }
        switch (ren1.op) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 39: 
            case 41: 
            case 42: {
                this.fixNext(state, (RENode)ren1.kid, ren2, oldnext);
                break;
            }
        }
    }

    private void setNext(CompilerState state, RENode ren1, RENode ren2) {
        this.fixNext(state, ren1, ren2, null);
    }

    private RENode parseRegExp(CompilerState state) {
        RENode ren = this.parseAltern(state);
        if (ren == null) {
            return null;
        }
        int index = state.index;
        char[] source = state.source;
        if (index < source.length && source[index] == '|') {
            RENode kid = ren;
            if ((ren = new RENode(state, 1, kid)) == null) {
                return null;
            }
            ren.flags = (byte)(kid.flags & 5);
            RENode ren1 = ren;
            do {
                state.index = ++index;
                if (index < source.length && (source[index] == '|' || source[index] == ')')) {
                    kid = new RENode(state, 0, null);
                } else {
                    kid = this.parseAltern(state);
                    index = state.index;
                }
                if (kid == null) {
                    return null;
                }
                RENode ren2 = new RENode(state, 1, kid);
                if (ren2 == null) {
                    return null;
                }
                ren1.next = ren2;
                ren1.flags = (byte)(ren1.flags | 0x10);
                ren2.flags = (byte)(kid.flags & 5 | 8);
                ren1 = ren2;
            } while (index < source.length && source[index] == '|');
        }
        return ren;
    }

    private RENode parseAltern(CompilerState state) {
        char c;
        RENode ren = this.parseItem(state);
        if (ren == null) {
            return null;
        }
        RENode ren1 = ren;
        int flags = 0;
        char[] source = state.source;
        int index = state.index;
        while (index != source.length && (c = source[index]) != '|' && c != ')') {
            RENode ren2 = this.parseItem(state);
            if (ren2 == null) {
                return null;
            }
            this.setNext(state, ren1, ren2);
            flags |= ren2.flags;
            ren1 = ren2;
            index = state.index;
        }
        ren.flags = (byte)(ren.flags | flags & 4);
        return ren;
    }

    /*
     * WARNING - void declaration
     */
    RENode parseItem(CompilerState state) {
        int index = state.index;
        char[] source = state.source;
        switch (index < source.length ? source[index] : 0) {
            case 94: {
                state.index = index + 1;
                RENode ren = new RENode(state, 2, null);
                ren.flags = (byte)(ren.flags | 1);
                return ren;
            }
            case 36: {
                state.index = index + 1;
                return new RENode(state, (byte)(index == state.indexBegin || (source[index - 1] == '(' || source[index - 1] == '|') && (index - 1 == state.indexBegin || source[index - 2] != '\\') ? 26 : 3), null);
            }
            case 92: {
                void var3_6;
                switch (++index < source.length ? source[index] : 0) {
                    case 98: {
                        int op = 4;
                        break;
                    }
                    case 66: {
                        int op = 5;
                        break;
                    }
                    default: {
                        return this.parseQuantAtom(state);
                    }
                }
                state.index = index + 1;
                RENode ren = new RENode(state, (byte)var3_6, null);
                ren.flags = (byte)(ren.flags | 4);
                return ren;
            }
        }
        return this.parseQuantAtom(state);
    }

    RENode parseQuantAtom(CompilerState state) {
        RENode ren = this.parseAtom(state);
        if (ren == null) {
            return null;
        }
        char[] source = state.source;
        int index = state.index;
        block6: while (index < source.length) {
            switch (source[index]) {
                case '{': {
                    int max;
                    char c;
                    if (++index == source.length || !NativeRegExp.isDigit(c = source[index])) {
                        this.reportError("msg.bad.quant", String.valueOf(source[state.index]), state);
                        return null;
                    }
                    int min = NativeRegExp.unDigit(c);
                    while (++index < source.length && NativeRegExp.isDigit(c = source[index])) {
                        if ((min = 10 * min + NativeRegExp.unDigit(c)) >> 16 == 0) continue;
                        this.reportError("msg.overlarge.max", this.tail(source, index), state);
                        return null;
                    }
                    if (source[index] == ',') {
                        int up = ++index;
                        if (NativeRegExp.isDigit(source[index])) {
                            max = NativeRegExp.unDigit(source[index]);
                            while (NativeRegExp.isDigit(c = source[++index])) {
                                if ((max = 10 * max + NativeRegExp.unDigit(c)) >> 16 == 0) continue;
                                this.reportError("msg.overlarge.max", String.valueOf(source[up]), state);
                                return null;
                            }
                            if (max == 0) {
                                this.reportError("msg.zero.quant", this.tail(source, state.index), state);
                                return null;
                            }
                            if (min > max) {
                                this.reportError("msg.max.lt.min", this.tail(source, up), state);
                                return null;
                            }
                        } else {
                            max = 0;
                        }
                    } else {
                        if (min == 0) {
                            this.reportError("msg.zero.quant", this.tail(source, state.index), state);
                            return null;
                        }
                        max = min;
                    }
                    if (source[index] != '}') {
                        this.reportError("msg.unterm.quant", String.valueOf(source[state.index]), state);
                        return null;
                    }
                    ++index;
                    RENode ren2 = new RENode(state, 6, ren);
                    if (min > 0 && (ren.flags & 4) != 0) {
                        ren2.flags = (byte)(ren2.flags | 4);
                    }
                    ren2.min = (short)min;
                    ren2.max = (short)max;
                    ren = ren2;
                    break;
                }
                case '*': {
                    ++index;
                    ren = new RENode(state, 7, ren);
                    break;
                }
                case '+': {
                    ++index;
                    RENode ren2 = new RENode(state, 8, ren);
                    if ((ren.flags & 4) != 0) {
                        ren2.flags = (byte)(ren2.flags | 4);
                    }
                    ren = ren2;
                    break;
                }
                case '?': {
                    ++index;
                    ren = new RENode(state, 9, ren);
                    break;
                }
                default: {
                    break block6;
                }
            }
            if (index >= source.length || source[index] != '?') continue;
            ren.flags = (byte)(ren.flags | 0x80);
            ++index;
        }
        state.index = index;
        return ren;
    }

    RENode parseAtom(CompilerState state) {
        int index;
        int num = 0;
        RENode ren = null;
        boolean skipCommon = false;
        boolean doFlat = false;
        char[] source = state.source;
        int ocp = index = state.index;
        if (index == source.length) {
            state.index = index;
            return new RENode(state, 0, null);
        }
        switch (source[index]) {
            case '|': {
                return new RENode(state, 0, null);
            }
            case '(': {
                RENode ren2;
                byte op = 43;
                if (source[index + 1] == '?') {
                    switch (source[index + 2]) {
                        case ':': {
                            op = 39;
                            break;
                        }
                        case '=': {
                            op = 41;
                            break;
                        }
                        case '!': {
                            op = 42;
                        }
                    }
                }
                if (op == 43) {
                    op = 10;
                    num = state.parenCount++;
                    ++index;
                } else {
                    index += 3;
                }
                state.index = index;
                if (source[index] == ')') {
                    ren2 = new RENode(state, 0, null);
                } else {
                    ren2 = this.parseRegExp(state);
                    if (ren2 == null) {
                        return null;
                    }
                    index = state.index;
                    if (index >= source.length || source[index] != ')') {
                        this.reportError("msg.unterm.paren", this.tail(source, ocp), state);
                        return null;
                    }
                }
                ++index;
                ren = new RENode(state, op, ren2);
                ren.flags = (byte)(ren2.flags & 5);
                ren.num = num;
                if (op != 10 && op != 39) break;
                ren2 = new RENode(state, (byte)(op + 1), null);
                this.setNext(state, ren, ren2);
                ren2.num = num;
                break;
            }
            case '.': {
                int op = 12;
                if (++index < source.length && source[index] == '*') {
                    op = 24;
                    if (++index < source.length && source[index] == '?') {
                        ++index;
                        op = 38;
                    }
                }
                ren = new RENode(state, (byte)op, null);
                if (ren.op != 12) break;
                ren.flags = (byte)6;
                break;
            }
            case '[': {
                if (++index == source.length) {
                    this.reportError("msg.unterm.class", this.tail(source, ocp), state);
                    return null;
                }
                char c = source[index];
                ren = new RENode(state, 13, new Integer(index));
                if (c == '^' && ++index == source.length) {
                    this.reportError("msg.unterm.class", this.tail(source, ocp), state);
                    return null;
                }
                while (true) {
                    if (++index == source.length) {
                        this.reportError("msg.unterm.paren", this.tail(source, ocp), state);
                        return null;
                    }
                    c = source[index];
                    if (c == ']') break;
                    if (c != '\\' || index + 1 == source.length) continue;
                    ++index;
                }
                ren.kid2 = index++;
                ren.flags = (byte)6;
                break;
            }
            case '\\': {
                int len;
                if (++index == source.length) {
                    Context.reportError(ScriptRuntime.getMessage("msg.trail.backslash", null));
                    return null;
                }
                char c = source[index];
                switch (c) {
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        c = NativeRegExp.getEscape(c);
                        ren = new RENode(state, 22, null);
                        break;
                    }
                    case 'd': {
                        ren = new RENode(state, 14, null);
                        break;
                    }
                    case 'D': {
                        ren = new RENode(state, 15, null);
                        break;
                    }
                    case 'w': {
                        ren = new RENode(state, 16, null);
                        break;
                    }
                    case 'W': {
                        ren = new RENode(state, 17, null);
                        break;
                    }
                    case 's': {
                        ren = new RENode(state, 18, null);
                        break;
                    }
                    case 'S': {
                        ren = new RENode(state, 19, null);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (state.cx.getLanguageVersion() != 0 && state.cx.getLanguageVersion() <= 140) {
                            switch (c) {
                                case '0': {
                                    state.index = index;
                                    num = this.doOctal(state);
                                    index = state.index;
                                    ren = new RENode(state, 22, null);
                                    c = (char)num;
                                    break;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    num = NativeRegExp.unDigit(c);
                                    len = 1;
                                    while (++index < source.length && NativeRegExp.isDigit(c = source[index])) {
                                        num = 10 * num + NativeRegExp.unDigit(c);
                                        ++len;
                                    }
                                    if ((num == 8 || num == 9) && num > state.parenCount) {
                                        ocp = --index;
                                        doFlat = true;
                                        skipCommon = true;
                                        break;
                                    }
                                    if (len > 1 || num > state.parenCount) {
                                        state.index = ocp;
                                        num = this.doOctal(state);
                                        index = state.index;
                                        ren = new RENode(state, 22, null);
                                        c = (char)num;
                                        break;
                                    }
                                    --index;
                                    ren = new RENode(state, 20, null);
                                    ren.num = num - 1;
                                    ren.flags = (byte)4;
                                    skipCommon = true;
                                }
                            }
                            break;
                        }
                        if (c == '0') {
                            ren = new RENode(state, 22, null);
                            c = '\u0000';
                            break;
                        }
                        num = NativeRegExp.unDigit(c);
                        len = 1;
                        while (++index < source.length && NativeRegExp.isDigit(c = source[index])) {
                            num = 10 * num + NativeRegExp.unDigit(c);
                            ++len;
                        }
                        --index;
                        ren = new RENode(state, 20, null);
                        ren.num = num - 1;
                        ren.flags = (byte)4;
                        skipCommon = true;
                        break;
                    }
                    case 'x': {
                        ocp = index++;
                        if (index < source.length && NativeRegExp.isHex(c = source[index])) {
                            num = NativeRegExp.unHex(c);
                            if (++index < source.length && NativeRegExp.isHex(c = source[index])) {
                                num <<= 4;
                                num += NativeRegExp.unHex(c);
                            } else if (state.cx.getLanguageVersion() != 0 && state.cx.getLanguageVersion() <= 140) {
                                --index;
                            } else {
                                index = ocp;
                                num = 120;
                            }
                        } else {
                            index = ocp;
                            num = 120;
                        }
                        ren = new RENode(state, 22, null);
                        c = (char)num;
                        break;
                    }
                    case 'c': {
                        c = source[++index];
                        if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) {
                            ocp = index -= 2;
                            doFlat = true;
                            skipCommon = true;
                            break;
                        }
                        c = Character.toUpperCase(c);
                        c = (char)(c ^ 0x40);
                        ren = new RENode(state, 22, null);
                        break;
                    }
                    case 'u': {
                        if (index + 4 < source.length && NativeRegExp.isHex(source[index + 1]) && NativeRegExp.isHex(source[index + 2]) && NativeRegExp.isHex(source[index + 3]) && NativeRegExp.isHex(source[index + 4])) {
                            num = (((NativeRegExp.unHex(source[index + 1]) << 4) + NativeRegExp.unHex(source[index + 2]) << 4) + NativeRegExp.unHex(source[index + 3]) << 4) + NativeRegExp.unHex(source[index + 4]);
                            c = (char)num;
                            index += 4;
                            ren = new RENode(state, 22, null);
                            break;
                        }
                        ocp = index;
                        doFlat = true;
                        skipCommon = true;
                        break;
                    }
                    default: {
                        ocp = index;
                        doFlat = true;
                        skipCommon = true;
                    }
                }
                if (ren != null && !skipCommon) {
                    ren.chr = c;
                    ren.flags = (byte)6;
                }
                skipCommon = false;
                if (!doFlat) {
                    ++index;
                    break;
                }
                doFlat = false;
            }
            default: {
                while (++index != source.length && metachars.indexOf(source[index]) == -1) {
                }
                int len = index - ocp;
                if (index != source.length && len > 1 && closurechars.indexOf(source[index]) != -1) {
                    --index;
                    --len;
                }
                if (len > 255) {
                    len = 255;
                    index = ocp + len;
                }
                ren = new RENode(state, len == 1 ? (byte)22 : 21, new Integer(ocp));
                ren.flags = (byte)4;
                if (len > 1) {
                    ren.kid2 = index;
                    break;
                }
                ren.flags = (byte)(ren.flags | 2);
                ren.chr = source[ocp];
            }
        }
        state.index = index;
        return ren;
    }

    private int doOctal(CompilerState state) {
        int tmp;
        char c;
        char[] source = state.source;
        int index = state.index;
        int num = 0;
        while (++index < source.length && '0' <= (c = source[index]) && c <= '7' && (tmp = 8 * num + (c - 48)) <= 255) {
            num = tmp;
        }
        state.index = --index;
        return num;
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static int unHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private String tail(char[] a, int i) {
        return new String(a, i, a.length - i);
    }

    private static boolean matchChar(int flags, char c, char c2) {
        if (c == c2) {
            return true;
        }
        if ((flags & 2) != 0) {
            return (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c) == Character.toLowerCase(c2);
        }
        return false;
    }

    int greedyRecurse(GreedyState grState, int index, int previousKid) {
        int match;
        int num = grState.state.parenCount;
        boolean oldBroke = grState.state.goForBroke;
        grState.state.goForBroke = false;
        int kidMatch = this.matchRENodes(grState.state, grState.kid, grState.next, index);
        grState.state.complete = -1;
        grState.state.goForBroke = oldBroke;
        if (kidMatch == -1) {
            int match2;
            grState.state.parenCount = num;
            if (previousKid != -1) {
                this.matchRENodes(grState.state, grState.kid, grState.next, previousKid);
            }
            if ((match2 = this.matchRENodes(grState.state, grState.next, grState.stop, index)) != -1) {
                if (grState.stop == null) {
                    grState.state.complete = match2;
                    return index;
                }
                return index;
            }
            return -1;
        }
        if (kidMatch == index) {
            if (previousKid != -1) {
                this.matchRENodes(grState.state, grState.kid, grState.next, previousKid);
            }
            return kidMatch;
        }
        if (grState.maxKid == 0 || ++grState.kidCount < grState.maxKid) {
            match = this.greedyRecurse(grState, kidMatch, index);
            if (match != -1) {
                return match;
            }
            if (grState.maxKid != 0) {
                --grState.kidCount;
            }
        }
        grState.state.parenCount = num;
        this.matchRENodes(grState.state, grState.kid, grState.next, index);
        match = this.matchRENodes(grState.state, grState.next, grState.stop, kidMatch);
        if (match != -1) {
            if (grState.stop == null) {
                grState.state.complete = match;
                return kidMatch;
            }
            this.matchRENodes(grState.state, grState.kid, grState.next, index);
            return kidMatch;
        }
        return -1;
    }

    int matchGreedyKid(MatchState state, RENode ren, RENode stop, int kidCount, int index, int previousKid) {
        GreedyState grState = new GreedyState();
        grState.state = state;
        grState.kid = (RENode)ren.kid;
        grState.next = ren.next;
        grState.maxKid = ren.op == 6 ? ren.max : (short)0;
        grState.stop = null;
        grState.kidCount = kidCount;
        int match = this.greedyRecurse(grState, index, previousKid);
        if (match != -1 || stop == null) {
            return match;
        }
        grState.kidCount = kidCount;
        grState.stop = stop;
        return this.greedyRecurse(grState, index, previousKid);
    }

    int matchNonGreedyKid(MatchState state, RENode ren, int kidCount, int maxKid, int index) {
        int match = this.matchRENodes(state, ren.next, null, index);
        if (state.goForBroke && state.complete != -1) {
            return state.complete;
        }
        if (match != -1) {
            state.complete = match;
            return index;
        }
        if (match != -1) {
            return index;
        }
        int kidMatch = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
        if (kidMatch == -1) {
            return -1;
        }
        if (state.goForBroke && state.complete != -1) {
            return state.complete;
        }
        if (kidMatch == index) {
            return kidMatch;
        }
        return this.matchNonGreedyKid(state, ren, kidCount, maxKid, kidMatch);
    }

    boolean isLineTerminator(char c) {
        return TokenStream.isJSLineTerminator(c);
    }

    int matchRENodes(MatchState state, RENode ren, RENode stop, int index) {
        char[] input = state.input;
        block33: while (ren != stop && ren != null) {
            block0 : switch (ren.op) {
                case 0: {
                    break;
                }
                case 1: {
                    if (ren.next.op != 1) {
                        ren = (RENode)ren.kid;
                        continue block33;
                    }
                    int num = state.parenCount;
                    int kidMatch = this.matchRENodes(state, (RENode)ren.kid, stop, index);
                    if (state.goForBroke && state.complete != -1) {
                        return state.complete;
                    }
                    if (kidMatch != -1) {
                        return kidMatch;
                    }
                    for (int i = num; i < state.parenCount; ++i) {
                        state.parens[i] = null;
                    }
                    state.parenCount = num;
                    break;
                }
                case 6: {
                    int kidMatch;
                    int num;
                    int lastKid = -1;
                    for (num = 0; num < ren.min; ++num) {
                        kidMatch = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
                        if (kidMatch == -1) {
                            return -1;
                        }
                        if (state.goForBroke && state.complete != -1) {
                            return state.complete;
                        }
                        lastKid = index;
                        index = kidMatch;
                    }
                    if (num == ren.max) break;
                    if ((ren.flags & 0x80) == 0) {
                        kidMatch = this.matchGreedyKid(state, ren, stop, num, index, lastKid);
                        if (kidMatch == -1) {
                            if (lastKid == -1) break;
                            index = this.matchRENodes(state, (RENode)ren.kid, ren.next, lastKid);
                            if (!state.goForBroke || state.complete == -1) break;
                            return state.complete;
                        }
                        if (state.goForBroke && state.complete != -1) {
                            return state.complete;
                        }
                        index = kidMatch;
                        break;
                    }
                    if ((index = this.matchNonGreedyKid(state, ren, num, ren.max, index)) == -1) {
                        return -1;
                    }
                    if (!state.goForBroke || state.complete == -1) break;
                    return state.complete;
                }
                case 8: {
                    int kidMatch = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
                    if (kidMatch == -1) {
                        return -1;
                    }
                    if ((ren.flags & 0x80) == 0) {
                        if ((kidMatch = this.matchGreedyKid(state, ren, stop, 1, kidMatch, index)) == -1) {
                            index = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
                            if (state.goForBroke && state.complete != -1) {
                                return state.complete;
                            }
                        } else {
                            if (state.goForBroke && state.complete != -1) {
                                return state.complete;
                            }
                            index = kidMatch;
                        }
                    } else {
                        index = this.matchNonGreedyKid(state, ren, 1, 0, kidMatch);
                        if (state.goForBroke && state.complete != -1) {
                            return state.complete;
                        }
                    }
                    if (index != -1) break;
                    return -1;
                }
                case 7: {
                    if ((ren.flags & 0x80) == 0) {
                        int kidMatch = this.matchGreedyKid(state, ren, stop, 0, index, -1);
                        if (kidMatch == -1) break;
                        if (state.goForBroke && state.complete != -1) {
                            return state.complete;
                        }
                        index = kidMatch;
                        break;
                    }
                    if ((index = this.matchNonGreedyKid(state, ren, 0, 0, index)) == -1) {
                        return -1;
                    }
                    if (!state.goForBroke || state.complete == -1) break;
                    return state.complete;
                }
                case 9: {
                    int saveNum = state.parenCount;
                    if ((ren.flags & 0x80) != 0) {
                        int restMatch = this.matchRENodes(state, ren.next, stop, index);
                        if (state.goForBroke && state.complete != -1) {
                            return state.complete;
                        }
                        if (restMatch != -1) {
                            return restMatch;
                        }
                    }
                    int kidMatch = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
                    if (state.goForBroke && state.complete != -1) {
                        return state.complete;
                    }
                    if (kidMatch == -1) {
                        for (int i = saveNum; i < state.parenCount; ++i) {
                            state.parens[i] = null;
                        }
                        state.parenCount = saveNum;
                        break;
                    }
                    int restMatch = this.matchRENodes(state, ren.next, stop, kidMatch);
                    if (state.goForBroke && state.complete != -1) {
                        return state.complete;
                    }
                    if (restMatch == -1) {
                        for (int i = saveNum; i < state.parenCount; ++i) {
                            state.parens[i] = null;
                        }
                        state.parenCount = saveNum;
                        break;
                    }
                    return restMatch;
                }
                case 39: {
                    ren = (RENode)ren.kid;
                    continue block33;
                }
                case 40: {
                    break;
                }
                case 10: {
                    int num = ren.num;
                    ren = (RENode)ren.kid;
                    SubString parsub = state.parens[num];
                    if (parsub == null) {
                        parsub = state.parens[num] = new SubString();
                        parsub.charArray = input;
                    }
                    parsub.index = index;
                    parsub.length = 0;
                    if (num < state.parenCount) continue block33;
                    state.parenCount = num + 1;
                    continue block33;
                }
                case 11: {
                    int num = ren.num;
                    SubString parsub = state.parens[num];
                    if (parsub == null) {
                        throw new RuntimeException("Paren problem");
                    }
                    parsub.length = index - parsub.index;
                    break;
                }
                case 41: {
                    int kidMatch = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
                    if (state.goForBroke && state.complete != -1) {
                        return state.complete;
                    }
                    if (kidMatch != -1) break;
                    return -1;
                }
                case 42: {
                    int kidMatch = this.matchRENodes(state, (RENode)ren.kid, ren.next, index);
                    if (state.goForBroke && state.complete != -1) {
                        return state.complete;
                    }
                    if (kidMatch == -1) break;
                    return -1;
                }
                case 20: {
                    int num = ren.num;
                    if (num >= state.parens.length) {
                        Context.reportError(ScriptRuntime.getMessage("msg.bad.backref", null));
                        return -1;
                    }
                    SubString parsub = state.parens[num];
                    if (parsub == null) {
                        parsub = state.parens[num] = new SubString();
                    }
                    int length = parsub.length;
                    int i = 0;
                    while (i < length) {
                        if (index >= input.length) {
                            return state.noMoreInput();
                        }
                        if (!NativeRegExp.matchChar(state.flags, input[index], parsub.charArray[parsub.index + i])) {
                            return -1;
                        }
                        ++i;
                        ++index;
                    }
                    break;
                }
                case 13: {
                    char c;
                    int b;
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (ren.bitmap == null) {
                        char[] source = ren.s != null ? ren.s : this.source.toCharArray();
                        ren.buildBitmap(state, source, (state.flags & 2) != 0);
                    }
                    if ((b = (c = input[index]) >>> 3) >= ren.bmsize) {
                        if (ren.kid2 == -1) {
                            ++index;
                            break;
                        }
                        return -1;
                    }
                    int bit = c & 7;
                    if ((ren.bitmap[b] & (bit = 1 << bit)) != 0) {
                        ++index;
                        break;
                    }
                    return -1;
                }
                case 12: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (!this.isLineTerminator(input[index])) {
                        ++index;
                        break;
                    }
                    return -1;
                }
                case 38: {
                    for (int cp2 = index; cp2 < input.length; ++cp2) {
                        int cp3 = this.matchRENodes(state, ren.next, stop, cp2);
                        if (cp3 != -1) {
                            return cp3;
                        }
                        if (!this.isLineTerminator(input[cp2])) continue;
                        return -1;
                    }
                    return state.noMoreInput();
                }
                case 24: {
                    int cp2;
                    for (cp2 = index; cp2 < input.length && !this.isLineTerminator(input[cp2]); ++cp2) {
                    }
                    while (cp2 >= index) {
                        int cp3 = this.matchRENodes(state, ren.next, stop, cp2);
                        if (cp3 != -1) {
                            index = cp2;
                            break block0;
                        }
                        --cp2;
                    }
                    break;
                }
                case 4: {
                    if (index == 0 || !NativeRegExp.isWord(input[index - 1])) {
                        if (index >= input.length) {
                            return state.noMoreInput();
                        }
                        if (NativeRegExp.isWord(input[index])) break;
                        return -1;
                    }
                    if (index >= input.length || !NativeRegExp.isWord(input[index])) break;
                    return -1;
                }
                case 5: {
                    if (index == 0 || !NativeRegExp.isWord(input[index - 1])) {
                        if (index >= input.length || !NativeRegExp.isWord(input[index])) break;
                        return -1;
                    }
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (NativeRegExp.isWord(input[index])) break;
                    return -1;
                }
                case 3: 
                case 26: {
                    if (index == input.length) break;
                    Context cx = Context.getCurrentContext();
                    RegExpImpl reImpl = NativeRegExp.getImpl(cx);
                    if (reImpl.multiline || (state.flags & 4) != 0) {
                        if (this.isLineTerminator(input[index])) break;
                        return -1;
                    }
                    return -1;
                }
                case 2: {
                    Context cx = Context.getCurrentContext();
                    RegExpImpl reImpl = NativeRegExp.getImpl(cx);
                    if (index == 0) break;
                    if (reImpl.multiline || (state.flags & 4) != 0) {
                        if (index >= input.length) {
                            return state.noMoreInput();
                        }
                        if (this.isLineTerminator(input[index - 1])) break;
                    }
                    return -1;
                }
                case 14: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (!NativeRegExp.isDigit(input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 15: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (NativeRegExp.isDigit(input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 16: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (!NativeRegExp.isWord(input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 17: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (NativeRegExp.isWord(input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 18: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (!TokenStream.isJSSpace(input[index]) && !TokenStream.isJSLineTerminator(input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 19: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (TokenStream.isJSSpace(input[index]) || TokenStream.isJSLineTerminator(input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 22: {
                    if (index >= input.length) {
                        return state.noMoreInput();
                    }
                    if (!NativeRegExp.matchChar(state.flags, ren.chr, input[index])) {
                        return -1;
                    }
                    ++index;
                    break;
                }
                case 21: {
                    char[] source = ren.s != null ? ren.s : this.source.toCharArray();
                    int start = (Integer)ren.kid;
                    int length = ren.kid2 - start;
                    int i = 0;
                    while (i < length) {
                        if (index >= input.length) {
                            return state.noMoreInput();
                        }
                        if (!NativeRegExp.matchChar(state.flags, input[index], source[start + i])) {
                            return -1;
                        }
                        ++i;
                        ++index;
                    }
                    break;
                }
                case 23: {
                    break;
                }
                case 43: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported by node matcher");
                }
            }
            ren = ren.next;
        }
        return index;
    }

    int matchRegExp(MatchState state, RENode ren, int index) {
        for (int i = index; i <= state.input.length; ++i) {
            state.skipped = i - index;
            state.parenCount = 0;
            int result = this.matchRENodes(state, ren, null, i);
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    Object executeRegExp(Context cx, Scriptable scopeObj, RegExpImpl res, String str, int[] indexp, int matchType) {
        Scriptable obj;
        Object result;
        int i;
        NativeRegExp re = this;
        MatchState state = new MatchState();
        state.inputExhausted = false;
        state.anchoring = false;
        state.flags = re.flags;
        state.scope = scopeObj;
        int start = indexp[0];
        char[] charArray = str.toCharArray();
        if (start > charArray.length) {
            start = charArray.length;
        }
        int index = start;
        state.cpbegin = 0;
        state.cpend = charArray.length;
        state.start = start;
        state.skipped = 0;
        state.input = charArray;
        state.complete = -1;
        state.goForBroke = true;
        state.parenCount = 0;
        state.maybeParens = new SubString[re.parenCount];
        state.parens = new SubString[re.parenCount];
        if ((index = this.matchRegExp(state, this.ren, index)) == -1) {
            if (matchType != 2 || !state.inputExhausted) {
                return null;
            }
            return Undefined.instance;
        }
        indexp[0] = i = index - state.cpbegin;
        int matchlen = i - (start + state.skipped);
        int ep = index;
        index -= matchlen;
        if (matchType == 0) {
            result = Boolean.TRUE;
            obj = null;
        } else {
            Scriptable scope = NativeRegExp.getTopLevelScope(scopeObj);
            result = ScriptRuntime.newObject(cx, scope, "Array", null);
            obj = (Scriptable)result;
            String matchstr = new String(charArray, index, matchlen);
            obj.put(0, obj, (Object)matchstr);
        }
        if (state.parenCount > re.parenCount) {
            throw new RuntimeException();
        }
        if (state.parenCount == 0) {
            res.parens.setSize(0);
            res.lastParen = SubString.emptySubString;
        } else {
            SubString parsub = null;
            res.parens.setSize(state.parenCount);
            for (int num = 0; num < state.parenCount; ++num) {
                parsub = state.parens[num];
                res.parens.setElementAt(parsub, num);
                if (matchType == 0) continue;
                String parstr = parsub == null ? "" : parsub.toString();
                obj.put(num + 1, obj, (Object)parstr);
            }
            res.lastParen = parsub;
        }
        if (matchType != 0) {
            obj.put("index", obj, (Object)new Integer(start + state.skipped));
            obj.put("input", obj, (Object)str);
        }
        if (res.lastMatch == null) {
            res.lastMatch = new SubString();
            res.leftContext = new SubString();
            res.rightContext = new SubString();
        }
        res.lastMatch.charArray = charArray;
        res.lastMatch.index = index;
        res.lastMatch.length = matchlen;
        res.leftContext.charArray = charArray;
        if (cx.getLanguageVersion() == 120) {
            res.leftContext.index = start;
            res.leftContext.length = state.skipped;
        } else {
            res.leftContext.index = 0;
            res.leftContext.length = start + state.skipped;
        }
        res.rightContext.charArray = charArray;
        res.rightContext.index = ep;
        res.rightContext.length = state.cpend - ep;
        return result;
    }

    public byte getFlags() {
        return this.flags;
    }

    private void reportError(String msg, String arg, CompilerState state) {
        Object[] args = new Object[]{arg};
        throw NativeGlobal.constructError(state.cx, "SyntaxError", ScriptRuntime.getMessage(msg, args), state.scope);
    }

    protected int getIdDefaultAttributes(int id) {
        switch (id) {
            case 1: {
                return 4;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 5;
            }
        }
        return super.getIdDefaultAttributes(id);
    }

    protected Object getIdValue(int id) {
        switch (id) {
            case 1: {
                return this.wrap_long(0xFFFFFFFFL & (long)this.lastIndex);
            }
            case 2: {
                return this.source;
            }
            case 3: {
                return this.wrap_boolean((this.flags & 1) != 0);
            }
            case 4: {
                return this.wrap_boolean((this.flags & 2) != 0);
            }
            case 5: {
                return this.wrap_boolean((this.flags & 4) != 0);
            }
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        if (id == 1) {
            this.setLastIndex(ScriptRuntime.toInt32(value));
            return;
        }
        super.setIdValue(id, value);
    }

    void setLastIndex(int value) {
        this.lastIndex = value;
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 6: {
                    return this.realThis(thisObj, f, false).compile(cx, scope, args);
                }
                case 7: {
                    return this.realThis(thisObj, f, true).toString();
                }
                case 8: {
                    return this.realThis(thisObj, f, false).exec(cx, scope, args);
                }
                case 9: {
                    return this.realThis(thisObj, f, false).test(cx, scope, args);
                }
                case 10: {
                    return this.realThis(thisObj, f, false).prefix(cx, scope, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeRegExp realThis(Scriptable thisObj, IdFunction f, boolean readOnly) {
        while (!(thisObj instanceof NativeRegExp)) {
            thisObj = this.nextInstanceCheck(thisObj, f, readOnly);
        }
        return (NativeRegExp)thisObj;
    }

    protected String getIdName(int id) {
        switch (id) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        if (this.prototypeFlag) {
            switch (id) {
                case 6: {
                    return "compile";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "exec";
                }
                case 9: {
                    return "test";
                }
                case 10: {
                    return "prefix";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        char c;
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 6) {
            c = s.charAt(0);
            if (c == 'g') {
                X = "global";
                id = 3;
            } else if (c == 's') {
                X = "source";
                id = 2;
            }
        } else if (s_length == 9) {
            c = s.charAt(0);
            if (c == 'l') {
                X = "lastIndex";
                id = 1;
            } else if (c == 'm') {
                X = "multiline";
                id = 5;
            }
        } else if (s_length == 10) {
            X = "ignoreCase";
            id = 4;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id != 0 || !this.prototypeFlag) {
            return id;
        }
        id = 0;
        X = null;
        switch (s.length()) {
            case 4: {
                c = s.charAt(0);
                if (c == 'e') {
                    X = "exec";
                    id = 8;
                    break;
                }
                if (c != 't') break;
                X = "test";
                id = 9;
                break;
            }
            case 6: {
                X = "prefix";
                id = 10;
                break;
            }
            case 7: {
                X = "compile";
                id = 6;
                break;
            }
            case 8: {
                X = "toString";
                id = 7;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    static {
        reopname = null;
    }
}

