/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;

public class NativeRegExpCtor
extends NativeFunction {
    private static final int Id_multiline = 1;
    private static final int Id_STAR = 2;
    private static final int Id_input = 3;
    private static final int Id_UNDERSCORE = 4;
    private static final int Id_lastMatch = 5;
    private static final int Id_AMPERSAND = 6;
    private static final int Id_lastParen = 7;
    private static final int Id_PLUS = 8;
    private static final int Id_leftContext = 9;
    private static final int Id_BACK_QUOTE = 10;
    private static final int Id_rightContext = 11;
    private static final int Id_QUOTE = 12;
    private static final int DOLLAR_ID_BASE = 12;
    private static final int Id_DOLLAR_1 = 13;
    private static final int Id_DOLLAR_2 = 14;
    private static final int Id_DOLLAR_3 = 15;
    private static final int Id_DOLLAR_4 = 16;
    private static final int Id_DOLLAR_5 = 17;
    private static final int Id_DOLLAR_6 = 18;
    private static final int Id_DOLLAR_7 = 19;
    private static final int Id_DOLLAR_8 = 20;
    private static final int Id_DOLLAR_9 = 21;
    private static final int MAX_INSTANCE_ID = 21;
    private int idBase = this.getMaxId();

    public NativeRegExpCtor() {
        this.setMaxId(this.idBase + 21);
        this.functionName = "RegExp";
    }

    public String getClassName() {
        return "Function";
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length > 0 && args[0] instanceof NativeRegExp && (args.length == 1 || args[1] == Undefined.instance)) {
            return args[0];
        }
        return this.construct(cx, this.parent, args);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        NativeRegExp re = new NativeRegExp();
        re.compile(cx, scope, args);
        re.setPrototype(NativeRegExpCtor.getClassPrototype(scope, "RegExp"));
        re.setParentScope(this.getParentScope());
        return re;
    }

    static RegExpImpl getImpl() {
        Context cx = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }

    protected int getIdDefaultAttributes(int id) {
        int shifted = id - this.idBase;
        if (1 <= shifted && shifted <= 21) {
            switch (shifted) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return 4;
                }
            }
            return 5;
        }
        return super.getIdDefaultAttributes(id);
    }

    private static String stringResult(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    protected Object getIdValue(int id) {
        int shifted = id - this.idBase;
        if (1 <= shifted && shifted <= 21) {
            RegExpImpl impl = NativeRegExpCtor.getImpl();
            switch (shifted) {
                case 1: 
                case 2: {
                    return this.wrap_boolean(impl.multiline);
                }
                case 3: 
                case 4: {
                    return NativeRegExpCtor.stringResult(impl.input);
                }
                case 5: 
                case 6: {
                    return NativeRegExpCtor.stringResult(impl.lastMatch);
                }
                case 7: 
                case 8: {
                    return NativeRegExpCtor.stringResult(impl.lastParen);
                }
                case 9: 
                case 10: {
                    return NativeRegExpCtor.stringResult(impl.leftContext);
                }
                case 11: 
                case 12: {
                    return NativeRegExpCtor.stringResult(impl.rightContext);
                }
            }
            int substring_number = shifted - 12 - 1;
            return impl.getParenSubString(substring_number).toString();
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        switch (id - this.idBase) {
            case 1: 
            case 2: {
                NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(value);
                return;
            }
            case 3: 
            case 4: {
                NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(value);
                return;
            }
        }
        super.setIdValue(id, value);
    }

    protected String getIdName(int id) {
        int shifted = id - this.idBase;
        if (1 <= shifted && shifted <= 21) {
            switch (shifted) {
                case 1: {
                    return "multiline";
                }
                case 2: {
                    return "$*";
                }
                case 3: {
                    return "input";
                }
                case 4: {
                    return "$_";
                }
                case 5: {
                    return "lastMatch";
                }
                case 6: {
                    return "$&";
                }
                case 7: {
                    return "lastParen";
                }
                case 8: {
                    return "$+";
                }
                case 9: {
                    return "leftContext";
                }
                case 10: {
                    return "$`";
                }
                case 11: {
                    return "rightContext";
                }
                case 12: {
                    return "$'";
                }
            }
            int substring_number = shifted - 12 - 1;
            char[] buf = new char[]{'$', (char)(49 + substring_number)};
            return new String(buf);
        }
        return super.getIdName(id);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int mapNameToId(String s) {
        int n;
        int id;
        block28: {
            id = 0;
            String X = null;
            switch (s.length()) {
                case 2: {
                    switch (s.charAt(1)) {
                        case '&': {
                            if (s.charAt(0) != '$') break;
                            id = 6;
                            break block28;
                        }
                        case '\'': {
                            if (s.charAt(0) != '$') break;
                            id = 12;
                            break block28;
                        }
                        case '*': {
                            if (s.charAt(0) != '$') break;
                            id = 2;
                            break block28;
                        }
                        case '+': {
                            if (s.charAt(0) != '$') break;
                            id = 8;
                            break block28;
                        }
                        case '1': {
                            if (s.charAt(0) != '$') break;
                            id = 13;
                            break block28;
                        }
                        case '2': {
                            if (s.charAt(0) != '$') break;
                            id = 14;
                            break block28;
                        }
                        case '3': {
                            if (s.charAt(0) != '$') break;
                            id = 15;
                            break block28;
                        }
                        case '4': {
                            if (s.charAt(0) != '$') break;
                            id = 16;
                            break block28;
                        }
                        case '5': {
                            if (s.charAt(0) != '$') break;
                            id = 17;
                            break block28;
                        }
                        case '6': {
                            if (s.charAt(0) != '$') break;
                            id = 18;
                            break block28;
                        }
                        case '7': {
                            if (s.charAt(0) != '$') break;
                            id = 19;
                            break block28;
                        }
                        case '8': {
                            if (s.charAt(0) != '$') break;
                            id = 20;
                            break block28;
                        }
                        case '9': {
                            if (s.charAt(0) != '$') break;
                            id = 21;
                            break block28;
                        }
                        case '_': {
                            if (s.charAt(0) != '$') break;
                            id = 4;
                            break block28;
                        }
                        case '`': {
                            if (s.charAt(0) != '$') break;
                            id = 10;
                            break block28;
                        }
                    }
                    break;
                }
                case 5: {
                    X = "input";
                    id = 3;
                    break;
                }
                case 9: {
                    char c = s.charAt(4);
                    if (c == 'M') {
                        X = "lastMatch";
                        id = 5;
                        break;
                    }
                    if (c == 'P') {
                        X = "lastParen";
                        id = 7;
                        break;
                    }
                    if (c != 'i') break;
                    X = "multiline";
                    id = 1;
                    break;
                }
                case 11: {
                    X = "leftContext";
                    id = 9;
                    break;
                }
                case 12: {
                    X = "rightContext";
                    id = 11;
                }
            }
            if (X != null && X != s && !X.equals(s)) {
                id = 0;
            }
        }
        if (id != 0) {
            n = this.idBase + id;
            return n;
        }
        n = super.mapNameToId(s);
        return n;
    }
}

