/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExp;

class RENode
implements Serializable {
    static final long serialVersionUID = -5896495686381169903L;
    public static final int ANCHORED = 1;
    public static final int SINGLE = 2;
    public static final int NONEMPTY = 4;
    public static final int ISNEXT = 8;
    public static final int GOODNEXT = 16;
    public static final int ISJOIN = 32;
    public static final int REALLOK = 64;
    public static final int MINIMAL = 128;
    byte op;
    byte flags;
    short offset;
    RENode next;
    Object kid;
    int kid2;
    int num;
    char chr;
    short min;
    short max;
    short kidlen;
    short bmsize;
    char[] s;
    byte[] bitmap;

    RENode(CompilerState state, byte op, Object kid) {
        this.op = op;
        this.kid = kid;
    }

    private void calcBMSize(char[] s, int index, int cp2, boolean fold) {
        int maxc = 0;
        while (index < cp2) {
            int c;
            if ((c = s[index++]) == 92) {
                if (index + 5 <= cp2 && s[index] == 'u' && NativeRegExp.isHex(s[index + 1]) && NativeRegExp.isHex(s[index + 2]) && NativeRegExp.isHex(s[index + 3]) && NativeRegExp.isHex(s[index + 4])) {
                    int x = (((NativeRegExp.unHex(s[index + 0]) << 4) + NativeRegExp.unHex(s[index + 1]) << 4) + NativeRegExp.unHex(s[index + 2]) << 4) + NativeRegExp.unHex(s[index + 3]);
                    c = (char)x;
                    index += 5;
                } else {
                    if (s[index] == 'S' || s[index] == 'W' || s[index] == 'D') {
                        maxc = 65535;
                        break;
                    }
                    if (maxc >= 255) continue;
                    maxc = 255;
                    continue;
                }
            }
            if (fold) {
                int c2 = Character.toUpperCase((char)c);
                if (c2 > maxc) {
                    maxc = c2;
                }
                int n = Character.toLowerCase((char)c2);
                c2 = n;
                if (n > maxc) {
                    maxc = c2;
                }
            }
            if (c <= maxc) continue;
            maxc = c;
        }
        this.bmsize = (short)((maxc + 8) / 8);
    }

    private void matchBit(int c, int fill) {
        int i = c >> 3;
        byte b = (byte)(c & 7);
        b = (byte)(1 << b);
        if (fill != 0) {
            int n = i;
            this.bitmap[n] = (byte)(this.bitmap[n] & ~b);
        } else {
            int n = i;
            this.bitmap[n] = (byte)(this.bitmap[n] | b);
        }
    }

    private void checkRange(int lastc, int fill) {
        this.matchBit(lastc, fill);
        this.matchBit(45, fill);
    }

    void buildBitmap(MatchState state, char[] s, boolean fold) {
        int nchars;
        int i;
        int index = (Integer)this.kid;
        int end = this.kid2;
        int fill = 0;
        boolean not = false;
        this.kid2 = 0;
        if (s[index] == '^') {
            not = true;
            this.kid2 = -1;
            ++index;
        }
        this.calcBMSize(s, index, end, fold);
        this.bitmap = new byte[this.bmsize];
        if (not) {
            fill = -1;
            for (i = 0; i < this.bmsize; ++i) {
                this.bitmap[i] = -1;
            }
            this.bitmap[0] = -2;
        }
        int lastc = nchars = this.bmsize * 8;
        boolean inrange = false;
        block14: while (index < end) {
            int c;
            if ((c = s[index++]) == 92) {
                c = s[index++];
                switch (c) {
                    case 98: 
                    case 102: 
                    case 110: 
                    case 114: 
                    case 116: 
                    case 118: {
                        c = NativeRegExp.getEscape((char)c);
                        break;
                    }
                    case 100: {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = 48; c <= 57; ++c) {
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 68: {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = 0; c < 48; ++c) {
                            this.matchBit(c, fill);
                        }
                        for (c = 58; c < nchars; ++c) {
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 119: {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = 0; c < nchars; ++c) {
                            if (!NativeRegExp.isWord((char)c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 87: {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = 0; c < nchars; ++c) {
                            if (NativeRegExp.isWord((char)c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 115: {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = 0; c < nchars; ++c) {
                            if (!Character.isWhitespace((char)c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 83: {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = 0; c < nchars; ++c) {
                            if (Character.isWhitespace((char)c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int n = NativeRegExp.unDigit((char)c);
                        int ocp = index - 2;
                        c = s[index];
                        if (48 <= c && c <= 55) {
                            n = 8 * n + NativeRegExp.unDigit((char)c);
                            if (48 <= (c = s[++index]) && c <= 55) {
                                ++index;
                                i = 8 * n + NativeRegExp.unDigit((char)c);
                                if (i <= 255) {
                                    n = i;
                                } else {
                                    --index;
                                }
                            }
                        }
                        c = n;
                        break;
                    }
                    case 120: {
                        int n;
                        int ocp = index;
                        if (index < s.length && NativeRegExp.isHex((char)(c = s[index++]))) {
                            n = NativeRegExp.unHex((char)c);
                            if (index < s.length && NativeRegExp.isHex((char)(c = s[index++]))) {
                                n <<= 4;
                                n += NativeRegExp.unHex((char)c);
                            }
                        } else {
                            index = ocp;
                            n = 120;
                        }
                        c = n;
                        break;
                    }
                    case 117: {
                        int n;
                        if (s.length <= index + 3 || !NativeRegExp.isHex(s[index + 0]) || !NativeRegExp.isHex(s[index + 1]) || !NativeRegExp.isHex(s[index + 2]) || !NativeRegExp.isHex(s[index + 3])) break;
                        c = n = (((NativeRegExp.unHex(s[index + 0]) << 4) + NativeRegExp.unHex(s[index + 1]) << 4) + NativeRegExp.unHex(s[index + 2]) << 4) + NativeRegExp.unHex(s[index + 3]);
                        index += 4;
                        break;
                    }
                    case 99: {
                        c = s[index++];
                        c = Character.toUpperCase((char)c);
                        c ^= 0x40;
                    }
                }
            }
            if (inrange) {
                if (lastc > c) {
                    throw NativeGlobal.constructError(Context.getCurrentContext(), "RangeError", ScriptRuntime.getMessage("msg.bad.range", null), state.scope);
                }
                inrange = false;
            } else {
                lastc = c;
                if (index + 1 < end && s[index] == '-' && s[index + 1] != ']') {
                    ++index;
                    inrange = true;
                    continue;
                }
            }
            while (lastc <= c) {
                this.matchBit(lastc, fill);
                if (fold) {
                    char foldc = Character.toUpperCase((char)lastc);
                    this.matchBit(foldc, fill);
                    foldc = Character.toLowerCase(foldc);
                    this.matchBit(foldc, fill);
                }
                ++lastc;
            }
            lastc = c;
        }
    }
}

