/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.io.File;
import java.util.Vector;
import javax.swing.JComboBox;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.Main;

class UpdateContext
implements Runnable {
    Main db;
    ContextData contextData;

    UpdateContext(Main db, Context cx) {
        this.db = db;
        this.contextData = ContextData.get(cx);
    }

    public void run() {
        this.db.context.enable_();
        JComboBox ctx = this.db.context.context;
        Vector toolTips = this.db.context.toolTips;
        this.db.context.disableUpdate();
        int frameCount = this.contextData.getFrameCount();
        ctx.removeAllItems();
        ctx.setSelectedItem(null);
        toolTips.clear();
        for (int i = 0; i < frameCount; ++i) {
            FrameHelper frame = this.contextData.getFrame(i);
            String sourceName = frame.getSourceName();
            if (sourceName != null && sourceName.endsWith("(eval)")) {
                sourceName = sourceName.substring(0, sourceName.length() - 6);
            }
            String shortName = sourceName;
            int lineNumber = frame.getLineNumber();
            if (sourceName == null) {
                if (lineNumber == -1) {
                    sourceName = "<eval>";
                    shortName = "<eval>";
                } else {
                    sourceName = "<stdin>";
                    shortName = "<stdin>";
                }
            } else if (sourceName.length() > 20) {
                shortName = new File(sourceName).getName();
            }
            String location = "\"" + shortName + "\", line " + lineNumber;
            ctx.insertItemAt(location, i);
            location = "\"" + sourceName + "\", line " + lineNumber;
            toolTips.addElement(location);
        }
        this.db.context.enableUpdate();
        ctx.setSelectedIndex(0);
        ctx.setMinimumSize(new Dimension(50, ctx.getMinimumSize().height));
    }
}

