/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.sandbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.groovy.sandbox.util.XmlList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSlurper
extends DefaultHandler {
    private final XMLReader reader;
    private List result = null;
    private List body = null;
    private final StringBuffer charBuffer = new StringBuffer();

    public XmlSlurper() throws ParserConfigurationException, SAXException {
        this(false, true);
    }

    public XmlSlurper(boolean validating, boolean namespaceAware) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = null;
        try {
            factory = (SAXParserFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ParserConfigurationException {
                    return SAXParserFactory.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)e;
            }
            throw new RuntimeException(e);
        }
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        SAXParser parser = factory.newSAXParser();
        this.reader = parser.getXMLReader();
    }

    public XmlSlurper(XMLReader reader) {
        this.reader = reader;
    }

    public XmlSlurper(SAXParser parser) throws SAXException {
        this(parser.getXMLReader());
    }

    public XmlList parse(InputSource input) throws IOException, SAXException {
        this.reader.setContentHandler(this);
        this.reader.parse(input);
        return (XmlList)this.result.get(0);
    }

    public XmlList parse(File file) throws IOException, SAXException {
        InputSource input = new InputSource(new FileInputStream(file));
        input.setSystemId("file://" + file.getAbsolutePath());
        return this.parse(input);
    }

    public XmlList parse(InputStream input) throws IOException, SAXException {
        return this.parse(new InputSource(input));
    }

    public XmlList parse(Reader in) throws IOException, SAXException {
        return this.parse(new InputSource(in));
    }

    public XmlList parse(String uri) throws IOException, SAXException {
        return this.parse(new InputSource(uri));
    }

    public XmlList parseText(String text) throws IOException, SAXException {
        return this.parse(new StringReader(text));
    }

    public void startDocument() throws SAXException {
        this.result = null;
        this.body = new LinkedList();
        this.charBuffer.setLength(0);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.addNonWhitespaceCdata();
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = atts.getLength() - 1; i != -1; --i) {
            if (atts.getURI(i).length() == 0) {
                attributes.put(atts.getQName(i), atts.getValue(i));
                continue;
            }
            attributes.put(atts.getLocalName(i), atts.getValue(i));
        }
        LinkedList<Object> newBody = new LinkedList<Object>();
        newBody.add(attributes);
        newBody.add(this.body);
        this.body = newBody;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charBuffer.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.addNonWhitespaceCdata();
        List children = this.body;
        Map attributes = (Map)this.body.remove(0);
        this.body = (List)this.body.remove(0);
        if (namespaceURI.length() == 0) {
            this.body.add(new XmlList(qName, attributes, children, namespaceURI));
        } else {
            this.body.add(new XmlList(localName, attributes, children, namespaceURI));
        }
    }

    public void endDocument() throws SAXException {
        this.result = this.body;
        this.body = null;
    }

    private void addNonWhitespaceCdata() {
        if (this.charBuffer.length() != 0) {
            String cdata = this.charBuffer.toString();
            this.charBuffer.setLength(0);
            if (cdata.trim().length() != 0) {
                this.body.add(cdata);
            }
        }
    }
}

