/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.DoubleIntTable;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.rowio.RowOutputBinary;

class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long filePos;
    StopWatch stopw = new StopWatch();

    DataFileDefrag() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HsqlArrayList defrag(Database database, String string) throws IOException, HsqlException {
        Trace.printSystemOut("Defrag Transfer begins");
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = database.getTables();
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string + ".new", false);
                this.fileStreamOut = new BufferedOutputStream(fileOutputStream, 4096);
                int n = 0;
                while (n < 32) {
                    this.fileStreamOut.write(0);
                    ++n;
                }
                this.filePos = 32L;
                int n2 = 0;
                int n3 = hsqlArrayList2.size();
                while (n2 < n3) {
                    Table table = (Table)hsqlArrayList2.get(n2);
                    if (table.tableType == 4) {
                        int[] nArray = this.writeTableToDataFile(table);
                        hsqlArrayList.add(nArray);
                    } else {
                        hsqlArrayList.add(null);
                    }
                    Trace.printSystemOut(table.getName().name + " complete");
                    ++n2;
                }
                this.fileStreamOut.close();
                randomAccessFile = new RandomAccessFile(string + ".new", "rw");
                randomAccessFile.seek(16L);
                randomAccessFile.writeInt((int)this.filePos);
                int n4 = 0;
                int n5 = hsqlArrayList.size();
                while (n4 < n5) {
                    int[] nArray = (int[])hsqlArrayList.get(n4);
                    if (nArray != null) {
                        Trace.printSystemOut(StringUtil.getList(nArray, ",", ""));
                    }
                    ++n4;
                }
            }
            catch (IOException iOException) {
                throw Trace.error(29, string + ".new");
            }
            Object var14_16 = null;
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (randomAccessFile == null) return hsqlArrayList;
            randomAccessFile.close();
            return hsqlArrayList;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
        }
    }

    static void updateTableIndexRoots(HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList.get(n);
            if (table.tableType == 4) {
                int[] nArray = (int[])hsqlArrayList2.get(n);
                table.setIndexRoots(nArray);
            }
            ++n;
        }
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Object object;
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntTable doubleIntTable = new DoubleIntTable(1000000);
        int[] nArray = table.getIndexRootsArray();
        Index index = table.getPrimaryIndex();
        long l = this.filePos;
        int n = 0;
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        Node node = index.first();
        while (node != null) {
            object = (CachedRow)node.getRow();
            doubleIntTable.add(((CachedRow)object).iPos, (int)l);
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + ((CachedRow)object).iPos + " " + l);
            }
            l += (long)((CachedRow)object).storageSize;
            node = index.next(node);
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        object = index.first();
        while (object != null) {
            CachedRow cachedRow = (CachedRow)((Node)object).getRow();
            rowOutputBinary.reset();
            rowOutputBinary.writeSize(cachedRow.storageSize);
            Node node2 = cachedRow.nPrimaryNode;
            while (node2 != null) {
                ((DiskNode)node2).writeTranslate(rowOutputBinary, doubleIntTable);
                node2 = node2.nNext;
            }
            rowOutputBinary.writeData(cachedRow.getData(), cachedRow.getTable());
            rowOutputBinary.writeEnd();
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.filePos += (long)cachedRow.storageSize;
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            object = index.next((Node)object);
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != -1) {
                int n3 = doubleIntTable.find(0, nArray[n2]);
                if (n3 == -1) {
                    throw Trace.error(129);
                }
                nArray[n2] = doubleIntTable.get(n3, 1);
            }
            ++n2;
        }
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }
}

