/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

public class DatabaseScript {
    public static Result getScript(Database database, boolean bl) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        HsqlArrayList hsqlArrayList = database.getTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        Result result = Result.newSingleColumnResult("COMMAND", 12);
        result.metaData.tableNames[0] = "SYSTEM_SCRIPT";
        HashMappedList hashMappedList = database.sequenceManager.sequenceMap;
        int n2 = 0;
        int n3 = hashMappedList.size();
        while (n2 < n3) {
            NumberSequence numberSequence = (NumberSequence)hashMappedList.get(n2);
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("CREATE").append(' ');
            stringBuffer.append("SEQUENCE").append(' ');
            stringBuffer.append(numberSequence.getName().statementName).append(' ');
            stringBuffer.append("AS").append(' ');
            stringBuffer.append(Types.getTypeString(numberSequence.getType())).append(' ');
            stringBuffer.append("START").append(' ');
            stringBuffer.append("WITH").append(' ');
            stringBuffer.append(numberSequence.peek()).append(' ');
            if (numberSequence.getIncrement() != 1L) {
                stringBuffer.append("INCREMENT").append(' ');
                stringBuffer.append("BY").append(' ');
                stringBuffer.append(numberSequence.getIncrement()).append(' ');
            }
            DatabaseScript.addRow(result, stringBuffer.toString());
            ++n2;
        }
        int n4 = 0;
        int n5 = hsqlArrayList.size();
        while (n4 < n5) {
            Table table = (Table)hsqlArrayList.get(n4);
            if (!table.isTemp() && !table.isView()) {
                int n6;
                StringBuffer stringBuffer = new StringBuffer(128);
                DatabaseScript.getTableDDL(database, table, n4, hsqlArrayList2, hsqlArrayList3, stringBuffer);
                DatabaseScript.addRow(result, stringBuffer.toString());
                int n7 = 1;
                while (n7 < table.getIndexCount()) {
                    object4 = table.getIndex(n7);
                    if (!HsqlNameManager.HsqlName.isReservedIndexName(((Index)object4).getName().name)) {
                        stringBuffer = new StringBuffer(64);
                        stringBuffer.append("CREATE").append(' ');
                        if (((Index)object4).isUnique()) {
                            stringBuffer.append("UNIQUE").append(' ');
                        }
                        stringBuffer.append("INDEX").append(' ');
                        stringBuffer.append(((Index)object4).getName().statementName);
                        stringBuffer.append(' ').append("ON").append(' ');
                        stringBuffer.append(table.getName().statementName);
                        int[] nArray = ((Index)object4).getColumns();
                        n6 = ((Index)object4).getVisibleColumns();
                        DatabaseScript.getColumnList(table, nArray, n6, stringBuffer);
                        DatabaseScript.addRow(result, stringBuffer.toString());
                    }
                    ++n7;
                }
                if (table.isText() && table.isDataReadOnly()) {
                    stringBuffer = new StringBuffer(64);
                    stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
                    stringBuffer.append(table.getName().statementName);
                    stringBuffer.append(' ').append("READONLY").append(' ').append("TRUE");
                    DatabaseScript.addRow(result, stringBuffer.toString());
                }
                if ((object4 = DatabaseScript.getDataSource(table)) != null) {
                    DatabaseScript.addRow(result, (String)object4);
                }
                int n8 = 12;
                n6 = 0;
                while (n6 < n8) {
                    object3 = table.triggerLists[n6];
                    if (object3 != null) {
                        n = ((HsqlArrayList)object3).size();
                        int n9 = 0;
                        while (n9 < n) {
                            stringBuffer = ((TriggerDef)((HsqlArrayList)object3).get(n9)).getDDL();
                            DatabaseScript.addRow(result, stringBuffer.toString());
                            ++n9;
                        }
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        int n10 = 0;
        int n11 = hsqlArrayList2.size();
        while (n10 < n11) {
            Constraint constraint = (Constraint)hsqlArrayList2.get(n10);
            object4 = new StringBuffer(128);
            ((StringBuffer)object4).append("ALTER").append(' ').append("TABLE").append(' ');
            ((StringBuffer)object4).append(constraint.getRef().getName().statementName);
            ((StringBuffer)object4).append(' ').append("ADD").append(' ');
            DatabaseScript.getFKStatement(constraint, (StringBuffer)object4);
            DatabaseScript.addRow(result, ((StringBuffer)object4).toString());
            ++n10;
        }
        int n12 = 0;
        int n13 = hsqlArrayList.size();
        while (n12 < n13) {
            Table table = (Table)hsqlArrayList.get(n12);
            if (bl && table.isIndexCached() && !table.isEmpty()) {
                DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)hsqlArrayList.get(n12)));
            }
            ++n12;
        }
        if (database.isIgnoreCase()) {
            DatabaseScript.addRow(result, "SET IGNORECASE TRUE");
        }
        HashMap hashMap = database.getAliasMap();
        HashMap hashMap2 = Library.getAliasMap();
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            String string2 = (String)hashMap.get(string);
            object2 = (String)hashMap2.get(string);
            if (object2 != null && ((String)object2).equals(string2)) continue;
            object = new StringBuffer(64);
            ((StringBuffer)object).append("CREATE").append(' ').append("ALIAS").append(' ');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(" FOR \"");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append('\"');
            DatabaseScript.addRow(result, ((StringBuffer)object).toString());
        }
        n = 0;
        int n14 = hsqlArrayList.size();
        while (n < n14) {
            object2 = (Table)hsqlArrayList.get(n);
            if (((Table)object2).isView()) {
                object = (View)hsqlArrayList.get(n);
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append("CREATE").append(' ').append("VIEW").append(' ');
                stringBuffer.append(((Table)object).getName().statementName).append(' ').append('(');
                int n15 = ((Table)object).getColumnCount();
                int n16 = 0;
                while (n16 < n15) {
                    stringBuffer.append(((Table)object).getColumn((int)n16).columnName.statementName);
                    if (n16 < n15 - 1) {
                        stringBuffer.append(',');
                    }
                    ++n16;
                }
                stringBuffer.append(')').append(' ').append("AS").append(' ');
                stringBuffer.append(((View)object).getStatement());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
            ++n;
        }
        DatabaseScript.addRightsStatements(database, result);
        if (database.logger.hasLog()) {
            int n17 = database.logger.lLog.writeDelay;
            object = "SET WRITE_DELAY " + n17;
            DatabaseScript.addRow(result, (String)object);
        }
        return result;
    }

    static String getIndexRootsDDL(Table table) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("INDEX").append('\'');
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, StringBuffer stringBuffer) {
        Object object;
        Constraint[] constraintArray;
        stringBuffer.append("CREATE").append(' ');
        if (table.isText()) {
            stringBuffer.append("TEXT").append(' ');
        } else if (table.isCached()) {
            stringBuffer.append("CACHED").append(' ');
        }
        stringBuffer.append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        int n3 = 0;
        while (n3 < n2) {
            constraintArray = table.getColumn(n3);
            String string = constraintArray.columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            String string2 = Types.getTypeString(constraintArray.getType());
            stringBuffer.append(string2);
            if (constraintArray.getSize() > 0) {
                stringBuffer.append('(');
                stringBuffer.append(constraintArray.getSize());
                if (constraintArray.getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(constraintArray.getScale());
                }
                stringBuffer.append(')');
            }
            if ((object = constraintArray.getDefaultDDL()) != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append((String)object);
            }
            if (n3 == table.getIdentityColumn()) {
                stringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                stringBuffer.append(constraintArray.identityStart);
                if (constraintArray.identityIncrement != 1L) {
                    stringBuffer.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
                    stringBuffer.append(constraintArray.identityIncrement);
                }
                stringBuffer.append(") ");
            }
            if (!constraintArray.isNullable()) {
                stringBuffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length == 1 && n3 == nArray[0] && index.getName().isReservedIndexName()) {
                stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(',');
            }
            ++n3;
        }
        if (nArray.length > 1 || !index.getName().isReservedIndexName()) {
            stringBuffer.append(',').append("CONSTRAINT").append(' ');
            stringBuffer.append(index.getName().statementName);
            stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        constraintArray = table.getConstraints();
        int n4 = 0;
        int n5 = constraintArray.length;
        while (n4 < n5) {
            object = constraintArray[n4];
            switch (((Constraint)object).getType()) {
                case 2: {
                    stringBuffer.append(',').append("CONSTRAINT").append(' ');
                    stringBuffer.append(((Constraint)object).getName().statementName);
                    stringBuffer.append(' ').append("UNIQUE");
                    int[] nArray2 = ((Constraint)object).getMainColumns();
                    DatabaseScript.getColumnList(((Constraint)object).getMain(), nArray2, nArray2.length, stringBuffer);
                    break;
                }
                case 0: {
                    Table table2 = ((Constraint)object).getMain();
                    int n6 = database.getTableIndex(table2);
                    if (n6 > n) {
                        if (n >= hsqlArrayList2.size()) {
                            hsqlArrayList2.setSize(n + 1);
                        }
                        hsqlArrayList2.set(n, object);
                        hsqlArrayList.add(object);
                        break;
                    }
                    stringBuffer.append(',');
                    DatabaseScript.getFKStatement((Constraint)object, stringBuffer);
                    break;
                }
                case 3: {
                    try {
                        stringBuffer.append(',').append("CONSTRAINT").append(' ');
                        stringBuffer.append(((Constraint)object).getName().statementName);
                        stringBuffer.append(' ').append("CHECK").append('(');
                        stringBuffer.append(((Constraint)object).core.check.getDDL());
                        stringBuffer.append(')');
                        break;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
            ++n4;
        }
        stringBuffer.append(')');
    }

    static String getDataSource(Table table) {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(' ').append("DESC");
        }
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(table.getColumn((int)nArray[n2]).columnName.statementName);
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT").append(' ');
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(' ').append("FOREIGN").append(' ').append("KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(' ').append("REFERENCES").append(' ');
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.getDeleteAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getDeleteAction()));
        }
        if (constraint.getUpdateAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getUpdateAction()));
        }
    }

    private static String getFKAction(int n) {
        switch (n) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private static void addRightsStatements(Database database, Result result) {
        HashMappedList hashMappedList = database.getUserManager().getUsers();
        Iterator iterator = hashMappedList.values().iterator();
        while (iterator.hasNext()) {
            IntValueHashMap intValueHashMap;
            User user = (User)iterator.next();
            String string = user.getName();
            if (!string.equals("PUBLIC")) {
                DatabaseScript.addRow(result, user.getCreateUserDDL());
            }
            if ((intValueHashMap = user.getRights()) == null) continue;
            Iterator iterator2 = intValueHashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                int n = intValueHashMap.get(object, 0);
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("GRANT").append(' ');
                stringBuffer.append(UserManager.getRight(n));
                stringBuffer.append(' ').append("ON").append(' ');
                if (object instanceof String) {
                    if (object.equals("java.lang.Math") || object.equals("org.hsqldb.Library")) continue;
                    stringBuffer.append("CLASS \"");
                    stringBuffer.append((String)object);
                    stringBuffer.append('\"');
                } else {
                    Table table = database.findUserTable(((HsqlNameManager.HsqlName)object).name);
                    if (table == null) continue;
                    stringBuffer.append(((HsqlNameManager.HsqlName)object).statementName);
                }
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(user.getName());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
        }
    }
}

