/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.NoSuchElementException;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;

public class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private final HsqlNameManager.HsqlName indexName;
    final boolean[] colCheck;
    private final int[] colIndex;
    private final int[] colType;
    private final boolean isUnique;
    boolean isConstraint;
    boolean isForward;
    private final boolean isExact;
    private final int visibleColumns;
    private final int colIndex_0;
    private final int colType_0;
    private Node root;
    private int depth;
    private static RowIterator emtyIterator = new IndexRowIterator(null);

    Index(HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3, int n) {
        this.indexName = hsqlName;
        this.colIndex = nArray;
        this.colType = nArray2;
        this.isUnique = bl;
        this.isConstraint = bl2;
        this.isForward = bl3;
        this.colIndex_0 = this.colIndex[0];
        this.colType_0 = this.colType[0];
        this.visibleColumns = n;
        this.isExact = this.colIndex.length == this.visibleColumns;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
    }

    Node getRoot() {
        return this.root;
    }

    void setRoot(Node node) {
        this.root = node;
        this.depth = 0;
    }

    HsqlNameManager.HsqlName getName() {
        return this.indexName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.indexName.rename(string, bl);
    }

    int getVisibleColumns() {
        return this.visibleColumns;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    boolean isConstraint() {
        return this.isConstraint;
    }

    int[] getColumns() {
        return this.colIndex;
    }

    int size() throws HsqlException {
        int n = 0;
        Node node = this.first();
        while (node != null) {
            node = this.next(node);
            ++n;
        }
        return n;
    }

    void clearAll() {
        this.root = null;
        this.depth = 0;
    }

    void insert(Node node) throws HsqlException {
        Node node2;
        Object[] objectArray = node.getData();
        Node node3 = node2 = this.root;
        boolean bl = true;
        int n = -1;
        while (true) {
            if (node2 == null) {
                if (node3 == null) {
                    this.root = node;
                    return;
                }
                break;
            }
            Object[] objectArray2 = node2.getData();
            n = this.compareRowForInsert(objectArray, objectArray2);
            if (n == 0) {
                throw Trace.error(9, this.indexName.name);
            }
            bl = n < 0;
            node3 = node2;
            node2 = this.child(node3, bl);
        }
        this.set(node3, bl, node);
        this.balance(node3, bl);
    }

    private void balance(Node node, boolean bl) throws HsqlException {
        while (true) {
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case 1: {
                    node.setBalance(0);
                    return;
                }
                case 0: {
                    node.setBalance(-n);
                    break;
                }
                case -1: {
                    Node node2 = this.child(node, bl);
                    if (node2.getBalance() == -n) {
                        this.replace(node, node2);
                        this.set(node, bl, this.child(node2, !bl));
                        this.set(node2, !bl, node);
                        node.setBalance(0);
                        node2.setBalance(0);
                    } else {
                        Node node3 = this.child(node2, !bl);
                        this.replace(node, node3);
                        this.set(node2, !bl, this.child(node3, bl));
                        this.set(node3, bl, node2);
                        this.set(node, bl, this.child(node3, !bl));
                        this.set(node3, !bl, node);
                        int n2 = node3.getBalance();
                        node.setBalance(n2 == -n ? n : 0);
                        node2.setBalance(n2 == n ? -n : 0);
                        node3.setBalance(0);
                    }
                    return;
                }
            }
            if (node.equals(this.root)) {
                return;
            }
            bl = node.isFromLeft();
            node = node.getParent();
        }
    }

    void delete(Node node) throws HsqlException {
        Node node2;
        Node node3;
        if (node == null) {
            return;
        }
        if (node.getLeft() == null) {
            node3 = node.getRight();
        } else if (node.getRight() == null) {
            node3 = node.getLeft();
        } else {
            Node node4 = node;
            Node node5 = node = node.getLeft();
            while ((node5 = node5.getRight()) != null) {
                node = node5;
            }
            node3 = node.getLeft();
            int n = node.getBalance();
            node.setBalance(node4.getBalance());
            node4.setBalance(n);
            Node node6 = node.getParent();
            node2 = node4.getParent();
            if (node4 == this.root) {
                this.root = node;
            }
            node.setParent(node2);
            if (node2 != null) {
                if (node2.getRight().equals(node4)) {
                    node2.setRight(node);
                } else {
                    node2.setLeft(node);
                }
            }
            if (node6 == node4) {
                node4.setParent(node);
                if (node4.getLeft().equals(node)) {
                    node.setLeft(node4);
                    node.setRight(node4.getRight());
                } else {
                    node.setRight(node4);
                    node.setLeft(node4.getLeft());
                }
            } else {
                node4.setParent(node6);
                node6.setRight(node4);
                node.setRight(node4.getRight());
                node.setLeft(node4.getLeft());
            }
            node.getRight().setParent(node);
            node.getLeft().setParent(node);
            node4.setLeft(node3);
            if (node3 != null) {
                node3.setParent(node4);
            }
            node4.setRight(null);
            node = node4;
        }
        boolean bl = node.isFromLeft();
        this.replace(node, node3);
        node3 = node.getParent();
        node.delete();
        while (node3 != null) {
            node = node3;
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case -1: {
                    node.setBalance(0);
                    break;
                }
                case 0: {
                    node.setBalance(n);
                    return;
                }
                case 1: {
                    Node node7 = this.child(node, !bl);
                    int n2 = node7.getBalance();
                    if (n2 * n >= 0) {
                        this.replace(node, node7);
                        this.set(node, !bl, this.child(node7, bl));
                        this.set(node7, bl, node);
                        if (n2 == 0) {
                            node.setBalance(n);
                            node7.setBalance(-n);
                            return;
                        }
                        node.setBalance(0);
                        node7.setBalance(0);
                        node = node7;
                        break;
                    }
                    node2 = this.child(node7, bl);
                    this.replace(node, node2);
                    n2 = node2.getBalance();
                    this.set(node7, bl, this.child(node2, !bl));
                    this.set(node2, !bl, node7);
                    this.set(node, !bl, this.child(node2, bl));
                    this.set(node2, bl, node);
                    node.setBalance(n2 == n ? -n : 0);
                    node7.setBalance(n2 == -n ? n : 0);
                    node2.setBalance(0);
                    node = node2;
                }
            }
            bl = node.isFromLeft();
            node3 = node.getParent();
        }
    }

    /*
     * Unable to fully structure code
     */
    Node findNotNull(Object[] var1_1, int[] var2_2, boolean var3_3) throws HsqlException {
        var4_4 = this.root;
        var6_5 = null;
        if (!Index.isNull(var1_1, var2_2)) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            var7_7 = this.compareRowNonUnique(var1_1, var2_2, var4_4.getData());
            if (var7_7 == 0) {
                if (!var3_3) {
                    var6_5 = var4_4;
                    break;
                }
                if (var6_5 == var4_4) break;
                var6_5 = var4_4;
                var5_6 = var4_4.getLeft();
            } else {
                var5_6 = var7_7 > 0 ? var4_4.getRight() : var4_4.getLeft();
            }
            if (var5_6 == null) break;
            var4_4 = var5_6;
lbl17:
            // 2 sources

            ** while (var4_4 != null)
        }
lbl18:
        // 4 sources

        return var6_5;
    }

    Node find(Object[] objectArray, int[] nArray) throws HsqlException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, nArray, node.getData());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    static boolean isNull(Object[] objectArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[nArray[n2]] == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isNull(Object[] objectArray) {
        int n = this.colIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.colIndex[n2];
            if (n3 < this.visibleColumns && objectArray[n3] == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    Node findFirst(Object[] objectArray) throws HsqlException {
        Node node = this.root;
        Node node2 = null;
        boolean bl = this.isUnique && !this.isNull(objectArray);
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, this.colIndex, node.getData());
            if (n == 0) {
                node2 = node;
                if (bl) break;
                node = node.getLeft();
                continue;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return node2;
    }

    /*
     * Unable to fully structure code
     */
    Node findFirst(Object var1_1, int var2_2) throws HsqlException {
        var3_3 = var2_2 == 21 || var2_2 == 32;
        var4_4 = this.root;
        var5_5 = 1;
        if (var2_2 == 23) {
            var5_5 = 0;
        }
        if (var1_1 != null || var3_3) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            v0 = var6_6 = Column.compare(var1_1, var4_4.getData()[this.colIndex_0], this.colType_0) >= var5_5;
            if (var6_6) {
                var7_8 = var4_4.getRight();
                if (var7_8 == null) break;
                var4_4 = var7_8;
                continue;
            }
            var7_8 = var4_4.getLeft();
            if (var7_8 == null) break;
            var4_4 = var7_8;
lbl17:
            // 3 sources

            ** while (var4_4 != null)
        }
lbl18:
        // 5 sources

        while (var4_4 != null) {
            var6_7 = var4_4.getData()[this.colIndex_0];
            var7_10 = Column.compare(var1_1, var6_7, this.colType_0);
            if (var7_10 >= var5_5) {
                var4_4 = this.next(var4_4);
                continue;
            }
            if (var3_3) {
                if (var7_10 == 0) break;
                var4_4 = null;
                break;
            }
            if (var6_7 != null) break;
            var4_4 = this.next(var4_4);
        }
        return var4_4;
    }

    Node findFirstNotNull() throws HsqlException {
        Node node = this.root;
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = Column.compare(null, node.getData()[this.colIndex_0], this.colType_0) >= 0;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null) {
            Object object = node.getData()[this.colIndex_0];
            if (object != null) break;
            node = this.next(node);
        }
        return node;
    }

    Node first() throws HsqlException {
        Node node;
        this.depth = 0;
        Node node2 = node = this.root;
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
            ++this.depth;
        }
        return node;
    }

    RowIterator firstRow() throws HsqlException {
        return new IndexRowIterator(this);
    }

    Node next(Node node) throws HsqlException {
        if (node == null) {
            return null;
        }
        Node node2 = node.getRight();
        if (node2 != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        node = node.getParent();
        while (node != null && node4.equals(node.getRight())) {
            node4 = node;
            node = node.getParent();
        }
        return node;
    }

    private Node child(Node node, boolean bl) throws HsqlException {
        return bl ? node.getLeft() : node.getRight();
    }

    private void replace(Node node, Node node2) throws HsqlException {
        if (node.equals(this.root)) {
            this.root = node2;
            if (node2 != null) {
                node2.setParent(null);
            }
        } else {
            this.set(node.getParent(), node.isFromLeft(), node2);
        }
    }

    private void set(Node node, boolean bl, Node node2) throws HsqlException {
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2.setParent(node);
        }
    }

    Node search(Object[] objectArray) throws HsqlException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRow(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    int compareRowNonUnique(Object[] objectArray, int[] nArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[nArray[0]], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = nArray.length;
        if (n2 > this.visibleColumns) {
            n2 = this.visibleColumns;
        }
        int n3 = 1;
        while (n3 < n2) {
            n = Column.compare(objectArray[nArray[n3]], objectArray2[this.colIndex[n3]], this.colType[n3]);
            if (n != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    private int compareRow(Object[] objectArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[this.colIndex_0], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.colIndex.length;
        int n3 = 1;
        while (n3 < n2) {
            n = Column.compare(objectArray[this.colIndex[n3]], objectArray2[this.colIndex[n3]], this.colType[n3]);
            if (n != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    static int compareRows(Object[] objectArray, Object[] objectArray2, int[] nArray) throws HsqlException {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = Column.compare(objectArray[nArray[n2]], objectArray2[nArray[n2]], nArray[n2]);
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int compareRowForInsert(Object[] var1_1, Object[] var2_2) throws HsqlException {
        var3_3 = var1_1[this.colIndex_0];
        var4_4 = Column.compare(var3_3, var2_2[this.colIndex_0], this.colType_0);
        var5_5 = 1;
        if (var4_4 == 0) ** GOTO lbl13
        return var4_4;
lbl-1000:
        // 1 sources

        {
            var6_6 = var1_1[this.colIndex[var5_5]];
            var4_4 = Column.compare(var6_6, var2_2[this.colIndex[var5_5]], this.colType[var5_5]);
            if (var4_4 != 0) {
                return var4_4;
            }
            if (var6_6 == null) {
                var3_3 = null;
            }
            ++var5_5;
lbl13:
            // 2 sources

            ** while (var5_5 < this.visibleColumns)
        }
lbl14:
        // 1 sources

        if (!this.isExact && (!this.isUnique || var3_3 == null)) ** GOTO lbl21
        return 0;
lbl-1000:
        // 1 sources

        {
            var6_6 = var1_1[this.colIndex[var5_5]];
            var4_4 = Column.compare(var6_6, var2_2[this.colIndex[var5_5]], this.colType[var5_5]);
            if (var4_4 != 0) {
                return var4_4;
            }
            ++var5_5;
lbl21:
            // 2 sources

            ** while (var5_5 < this.colIndex.length)
        }
lbl22:
        // 1 sources

        return 0;
    }

    int getIndexOrderValue() {
        boolean bl = false;
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    public static class IndexRowIterator
    implements RowIterator {
        Index index;
        Node next;

        private IndexRowIterator(Index index) {
            this.index = index;
            if (index != null) {
                try {
                    this.next = index.first();
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Row next() {
            if (this.hasNext()) {
                try {
                    Row row = this.next.getRow();
                    this.next = this.index.next(this.next);
                    return row;
                }
                catch (Exception exception) {
                    throw new NoSuchElementException();
                }
            }
            throw new NoSuchElementException();
        }
    }
}

