/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.BaseTable;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DataFileCache;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.store.ValuePool;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 8;
    static final String DEFAULT_PK = "";
    public HashMappedList columnList;
    Index[] indexList;
    private int[] primaryKeyCols;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    boolean needsRowID;
    int[] nullRowIDCols;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    Constraint[] constraintList;
    HsqlArrayList[] triggerLists;
    private int[] colTypes;
    private int[] colSizes;
    private boolean[] colNullable;
    private Expression[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    private boolean isText;
    private boolean isView;
    boolean sqlEnforceSize;
    boolean sqlEnforceStrictSize;
    protected int columnCount;
    protected int visibleColumnCount;
    protected Database database;
    protected DataFileCache cache;
    protected HsqlNameManager.HsqlName tableName;
    protected int tableType;
    protected int ownerSessionId;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;
    HashSet constraintPath;
    HashMappedList tableUpdateList;

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceSize;
        this.sqlEnforceStrictSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (n) {
            case 0: 
            case 1: {
                this.isTemp = true;
                break;
            }
            case 2: {
                this.isTemp = true;
                this.ownerSessionId = n2;
                break;
            }
            case 4: {
                this.cache = database.logger.getCache();
                if (this.cache != null) {
                    this.isCached = true;
                    break;
                }
                n = 3;
                break;
            }
            case 5: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.isCached = true;
                this.ownerSessionId = n2;
                break;
            }
            case 6: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.isCached = true;
                break;
            }
            case 7: 
            case 8: {
                this.isView = true;
            }
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.primaryKeyCols = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = new Index[0];
        this.constraintList = new Constraint[0];
        this.triggerLists = new HsqlArrayList[12];
        if (database.isFilesReadOnly() && this.checkTableFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(Session session, String string) {
        if (this.isTemp && session.getId() != this.ownerSessionId) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    final boolean isSystem() {
        return this.tableType == 0 || this.tableType == 1 || this.tableType == 8;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.isFilesReadOnly() && this.checkTableFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean checkTableFileBased() {
        return this.isCached | this.isText;
    }

    int getOwnerSessionId() {
        return this.ownerSessionId;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, this.constraintList.length, 1);
    }

    Constraint[] getConstraints() {
        return this.constraintList;
    }

    Index getConstraintIndexForColumns(int[] nArray) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, true)) {
            return this.getPrimaryIndex();
        }
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getType() == 2 && ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, true)) {
                return constraint.getMainIndex();
            }
            ++n;
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.isEquivalent(table, nArray, this, nArray2)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    Constraint getConstraintForIndex(Index index) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getMainIndex() == index && constraint.getType() == 2) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = n;
        int n4 = this.constraintList.length;
        while (n3 < n4) {
            Constraint constraint = this.constraintList[n3];
            if (constraint.getType() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void addColumn(String string, int n) throws HsqlException {
        Column column = new Column(this.database.nameManager.newHsqlName(string, false), true, n, 0, 0, false, 0L, 0L, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws HsqlException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.columnCount;
        }
        Trace.doAssert(this.primaryKeyCols == null, "Table.addColumn");
        this.columnList.add(column.columnName.name, column);
        ++this.columnCount;
        ++this.visibleColumnCount;
    }

    void addColumns(Result.ResultMetaData resultMetaData, int n) throws HsqlException {
        int n2 = 0;
        while (n2 < n) {
            Column column = new Column(this.database.nameManager.newHsqlName(resultMetaData.colLabels[n2], resultMetaData.isLabelQuoted[n2]), true, resultMetaData.colTypes[n2], resultMetaData.colSizes[n2], resultMetaData.colScales[n2], false, 0L, 0L, false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = select.exprColumns[n2];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, 0L, 0L, false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    void renameTable(String string, boolean bl) throws HsqlException {
        String string2 = this.tableName.name;
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
        this.renameTableInCheckConstraints(string2, string);
    }

    int getInternalColumnCount() {
        return this.columnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType, this.ownerSessionId);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= this.columnCount || nArray2[n] >= table.columnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[n]).getType() != table.getColumn(nArray2[n]).getType()) {
                throw Trace.error(57);
            }
            ++n;
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws HsqlException {
        int[] nArray;
        Table table = this.duplicate();
        int n3 = 0;
        while (n3 < this.visibleColumnCount + 1) {
            block10: {
                block8: {
                    block9: {
                        if (n3 != n) break block8;
                        if (n2 <= 0) break block9;
                        table.addColumn(column);
                        break block8;
                    }
                    if (n2 < 0) break block10;
                }
                if (n3 == this.visibleColumnCount) break;
                table.addColumn(this.getColumn(n3));
            }
            ++n3;
        }
        int[] nArray2 = nArray = this.primaryKeyCols[0] == this.visibleColumnCount ? null : this.primaryKeyCols;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, false);
        table.constraintList = this.constraintList;
        int n4 = 1;
        while (n4 < this.getIndexCount()) {
            Index index;
            Index index2 = this.getIndex(n4);
            if (!(string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null)) {
                throw Trace.error(123);
            }
            ++n4;
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    void updateConstraintsTables(Table table, int n, int n2) throws HsqlException {
        int n3 = 0;
        int n4 = this.constraintList.length;
        while (n3 < n4) {
            Constraint constraint = this.constraintList[n3];
            constraint.replaceTable(table, this, n, n2);
            if (constraint.constType == 3) {
                this.recompileCheckConstraint(constraint);
            }
            ++n3;
        }
    }

    private void recompileCheckConstraints() throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                this.recompileCheckConstraint(constraint);
            }
            ++n;
        }
    }

    private void recompileCheckConstraint(Constraint constraint) throws HsqlException {
        Expression expression;
        String string = constraint.core.check.getDDL();
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(this.database.getSessionManager().getSysSession(), this.database, tokenizer);
        constraint.core.check = expression = parser.parseExpression();
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(this, expression);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.checkFilter.setAsCheckFilter();
        constraint.core.mainTable = this;
    }

    void checkColumnInCheckConstraint(String string) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3 && constraint.hasColumn(this, string)) {
                throw Trace.error(197, constraint.getName());
            }
            ++n;
        }
    }

    private void renameColumnInCheckConstraints(String string, String string2, boolean bl) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                Expression.Collector collector = new Expression.Collector();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    if (expression.getColumnName() != string) continue;
                    expression.setColumnName(string2, bl);
                }
            }
            ++n;
        }
    }

    private void renameTableInCheckConstraints(String string, String string2) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                Expression.Collector collector = new Expression.Collector();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    if (expression.getTableName() != string) continue;
                    expression.setTableName(string2);
                }
            }
            ++n;
        }
        this.recompileCheckConstraints();
    }

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    int getIndexCount() {
        return this.indexList.length;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n == this.visibleColumnCount ? -1 : n;
    }

    public Index getPrimaryIndex() {
        return this.getIndex(0);
    }

    public int[] getPrimaryKey() {
        return this.primaryKeyCols[0] == this.visibleColumnCount ? null : this.primaryKeyCols;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyCols[0] != this.visibleColumnCount;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    private void setBestRowIdentifiers() {
        int[] nArray = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndexForColumn = new int[this.columnList.size()];
        this.nullRowIDCols = new int[this.columnList.size()];
        int n3 = 0;
        while (n3 < this.bestIndexForColumn.length) {
            this.bestIndexForColumn[n3] = -1;
            this.nullRowIDCols[n3] = -1;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.indexList.length) {
            block16: {
                int n5;
                int[] nArray2;
                Index index;
                block15: {
                    index = this.indexList[n4];
                    nArray2 = index.getColumns();
                    n5 = index.getVisibleColumns();
                    if (n4 != 0) break block15;
                    if (this.getPrimaryKey() == null) break block16;
                    bl = true;
                }
                if (this.bestIndexForColumn[nArray2[0]] == -1) {
                    this.bestIndexForColumn[nArray2[0]] = n4;
                }
                if (index.isUnique()) {
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n5) {
                        if (!this.colNullable[nArray2[n7]]) {
                            ++n6;
                        } else {
                            this.nullRowIDCols[nArray2[n7]] = nArray2[n7];
                        }
                        ++n7;
                    }
                    if (n6 == n5) {
                        if (nArray == null || n != n2 || n5 < n) {
                            nArray = nArray2;
                            n = n5;
                            n2 = n5;
                            bl = true;
                        }
                    } else if (!(bl || nArray != null && n5 >= n && n6 <= n2)) {
                        nArray = nArray2;
                        n = n5;
                        n2 = n6;
                    }
                }
            }
            ++n4;
        }
        this.bestRowIdentifierCols = nArray == null || n == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n);
        this.bestRowIdentifierStrict = bl;
        ArrayUtil.sortArray(this.nullRowIDCols);
        int n8 = ArrayUtil.findNot(this.nullRowIDCols, -1);
        this.nullRowIDCols = n8 == -1 ? null : ArrayUtil.arraySlice(this.nullRowIDCols, 0, n8);
        this.needsRowID = this.getPrimaryKey() == null;
    }

    void setDefaultExpression(int n, Expression expression) {
        Column column = this.getColumn(n);
        column.setDefaultExpression(expression);
        this.resetDefaultValues();
    }

    void resetDefaultValues() {
        this.hasDefaultValues = false;
        int n = 0;
        while (n < this.columnCount) {
            Column column = this.getColumn(n);
            if (n < this.visibleColumnCount) {
                this.hasDefaultValues = this.hasDefaultValues || column.getDefaultExpression() != null;
                this.colDefaults[n] = column.getDefaultExpression();
            }
            ++n;
        }
    }

    Index getIndexForColumn(int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 == -1 && (this.tableType == 1 || this.tableType == 0)) {
            try {
                this.createIndex(new int[]{n}, null, false, false, false);
                n2 = this.bestIndexForColumn[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(boolean[] blArray) {
        Index index = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.indexList.length) {
            Index index2 = this.indexList[n2];
            boolean bl = ArrayUtil.containsAllTrueElements(blArray, index2.colCheck);
            if (bl && index2.getVisibleColumns() > n) {
                n = index2.getVisibleColumns();
                index = index2;
            }
            ++n2;
        }
        return index;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        int n = 0;
        int n2 = this.getIndexCount();
        while (n < n2) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            if (ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) && (!bl || index.isUnique())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int[] getIndexRootsArray() {
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        while (n < this.getIndexCount()) {
            Node node = this.getIndex(n).getRoot();
            nArray[n] = node != null ? node.getKey() : -1;
            ++n;
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.identitySequence.peek());
        return stringBuffer.toString();
    }

    void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        int n = 0;
        while (n < this.getIndexCount()) {
            int n2 = nArray[n];
            CachedRow cachedRow = null;
            if (n2 != -1) {
                cachedRow = this.cache.getRow(n2, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(n);
            }
            this.getIndex(n).setRoot(node);
            ++n;
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached, 22);
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.getIndexCount()) {
            int n3;
            int n4 = string.indexOf(32, n);
            nArray[n2] = n3 = Integer.parseInt(string.substring(n, n4));
            n = n4 + 1;
            ++n2;
        }
        this.setIndexRoots(nArray);
        this.identitySequence.reset(Long.parseLong(string.substring(n)));
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        Trace.doAssert(this.primaryKeyCols == null, "Table.createPrimaryKey(column)");
        Column column = new Column(this.database.nameManager.newAutoName(DEFAULT_PK), false, 4, 0, 0, false, 0L, 0L, nArray == null, null);
        this.addColumn(column);
        --this.visibleColumnCount;
        if (nArray == null) {
            nArray = new int[]{this.visibleColumnCount};
        } else {
            int n = 0;
            while (n < nArray.length) {
                if (bl) {
                    this.getColumn(nArray[n]).setNullable(false);
                }
                this.getColumn(nArray[n]).setPrimaryKey(true);
                ++n;
            }
        }
        this.primaryKeyCols = nArray;
        HsqlNameManager.HsqlName hsqlName2 = hsqlName != null ? hsqlName : this.database.nameManager.newHsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexStructure(nArray, hsqlName2, true, true, true, false);
        this.colTypes = new int[this.visibleColumnCount];
        this.colDefaults = new Expression[this.visibleColumnCount];
        this.colSizes = new int[this.visibleColumnCount];
        this.colNullable = new boolean[this.visibleColumnCount];
        this.defaultColumnMap = new int[this.visibleColumnCount];
        int n = 0;
        while (n < this.columnCount) {
            column = this.getColumn(n);
            if (n < this.visibleColumnCount) {
                this.colTypes[n] = column.getType();
                this.colSizes[n] = column.getSize();
                this.colNullable[n] = column.isNullable();
                this.defaultColumnMap[n] = n;
            }
            if (column.isIdentity()) {
                this.identitySequence.reset(column.identityStart, column.identityIncrement);
            }
            ++n;
        }
        this.resetDefaultValues();
        this.setBestRowIdentifiers();
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), false, index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, false, bl, bl2, bl3);
        Index index = this.indexList[n];
        Index index2 = this.getPrimaryIndex();
        Node node = index2.first();
        int n2 = 0;
        try {
            while (node != null) {
                Row row = node.getRow();
                Node node2 = Node.newNode(row, n, this);
                Node node3 = row.getNode(n - 1);
                node2.nNext = node3.nNext;
                node3.nNext = node2;
                index.insert(node2);
                node = index2.next(node);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n2 = 72;
        }
        catch (HsqlException hsqlException) {
            n2 = 9;
        }
        Node node4 = node;
        node = index2.first();
        while (node != node4) {
            int n3 = n;
            Node node5 = node;
            while (--n3 > 0) {
                node5 = node5.nNext;
            }
            node5.nNext = node5.nNext.nNext;
            node = index2.next(node);
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        this.setBestRowIdentifiers();
        throw Trace.error(n2);
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3, bl4);
        return this.indexList[n];
    }

    int createIndexStructureGetNo(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        Trace.doAssert(this.primaryKeyCols != null, "createIndex");
        int n = nArray.length;
        int n2 = bl ? 0 : this.primaryKeyCols.length;
        int[] nArray2 = new int[n + n2];
        int[] nArray3 = new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = this.getColumn(nArray2[n3]).getType();
            ++n3;
        }
        if (!bl) {
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n + n4] = this.primaryKeyCols[n4];
                nArray3[n + n4] = this.getColumn(this.primaryKeyCols[n4]).getType();
                ++n4;
            }
        }
        if (nArray2[0] == this.visibleColumnCount) {
            n = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl2, bl3, bl4, n);
        int n5 = this.addIndex(index);
        this.setBestRowIdentifiers();
        return n5;
    }

    private int addIndex(Index index) {
        int n = 0;
        while (n < this.indexList.length) {
            Index index2 = this.indexList[n];
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
            ++n;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, n, 1);
        return n;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (hashSet == null || !hashSet.contains(constraint)) {
                if (constraint.isIndexFK(index)) {
                    throw Trace.error(50, string);
                }
                if (constraint.isIndexUnique(index)) {
                    throw Trace.error(56, string);
                }
            }
            ++n;
        }
    }

    boolean isEmpty() {
        if (this.getIndexCount() == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.visibleColumnCount];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.visibleColumnCount];
    }

    Object[] getNewRow() {
        return new Object[this.columnCount];
    }

    Object[] getNewRowData(Session session, boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.columnCount];
        if (blArray != null && this.hasDefaultValues) {
            int n = 0;
            while (n < this.visibleColumnCount) {
                Expression expression = this.colDefaults[n];
                if (!blArray[n] && expression != null) {
                    objectArray[n] = expression.getValue(session, this.colTypes[n]);
                }
                ++n;
            }
        }
        return objectArray;
    }

    void dropIndex(String string) throws HsqlException {
        Index index;
        int n = 1;
        while (n < this.getIndexCount()) {
            index = this.getIndex(n);
            if (index.getName().name.equals(string)) {
                this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
                this.setBestRowIdentifiers();
                break;
            }
            ++n;
        }
        index = this.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            int n2 = n - 1;
            Node node2 = node;
            while (n2-- > 0) {
                node2 = node2.nNext;
            }
            node2.nNext = node2.nNext.nNext;
            node = index.next(node);
        }
    }

    void moveData(Session session, Table table, int n, int n2) throws HsqlException {
        Object object;
        Object object2 = null;
        if (n2 > 0) {
            object = this.getColumn(n);
            object2 = ((Column)object).getDefaultValue(session);
        }
        object = table.getPrimaryIndex();
        Node node = ((Index)object).first();
        while (node != null) {
            Object[] objectArray = node.getData();
            Object[] objectArray2 = this.getNewRow();
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object2, n, n2);
            this.insertWithIdentity(session, objectArray2);
            node = ((Index)object).next(node);
        }
        table.drop();
    }

    int insert(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        this.fireAll(session, 3);
        while (record != null) {
            this.insertRow(session, record.data);
            record = record.next;
            ++n;
        }
        this.fireAll(session, 0);
        return n;
    }

    void insert(Session session, Object[] objectArray) throws HsqlException {
        this.fireAll(session, 3);
        this.insertRow(session, objectArray);
        this.fireAll(session, 0);
    }

    private void insertRow(Session session, Object[] objectArray) throws HsqlException {
        if (this.triggerLists[9] != null) {
            this.fireAll(session, 9, null, objectArray);
        }
        this.setIdentityColumn(session, objectArray);
        this.checkRowDataInsert(session, objectArray);
        this.insertNoCheck(session, objectArray);
        if (this.triggerLists[6] != null) {
            this.fireAll(session, 6, null, objectArray);
            this.checkRowDataInsert(session, objectArray);
        }
    }

    void insertIntoTable(Session session, Result result) throws HsqlException {
        this.insert(result);
        if (this.isTemp || this.isText || !this.database.logger.hasLog()) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.database.logger.writeInsertStatement(session, this, record.data);
            record = record.next;
        }
    }

    private Row insertNoCheck(Session session, Object[] objectArray) throws HsqlException {
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (session != null) {
            session.addTransactionInsert(this, row);
        }
        if (!this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
        return row;
    }

    void insertNoCheckRollback(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    int insert(Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.insert(record.data);
            record = record.next;
            ++n;
        }
        return n;
    }

    public void insertFromScript(Object[] objectArray) throws HsqlException {
        this.updateIdentityValue(objectArray);
        this.insert(objectArray);
    }

    public void insertWithIdentity(Session session, Object[] objectArray) throws HsqlException {
        this.setIdentityColumn(session, objectArray);
        this.insert(objectArray);
    }

    public void insert(Object[] objectArray) throws HsqlException {
        Object object;
        if (objectArray.length != this.columnCount) {
            object = this.getNewRow();
            ArrayUtil.copyArray(objectArray, object, this.visibleColumnCount);
            objectArray = object;
        } else {
            int n = this.visibleColumnCount;
            while (n < this.columnCount) {
                objectArray[n] = null;
                ++n;
            }
        }
        object = Row.newRow(this, objectArray);
        this.indexRow((Row)object);
    }

    protected void insertNoChange(CachedDataRow cachedDataRow) throws HsqlException {
        Object[] objectArray = cachedDataRow.getData();
        this.updateIdentityValue(objectArray);
        this.enforceFieldValueLimits(objectArray);
        this.enforceNullConstraints(objectArray);
        this.indexRow(cachedDataRow);
    }

    protected void enforceNullConstraints(Object[] objectArray) throws HsqlException {
        int n = 0;
        while (n < this.visibleColumnCount) {
            if (objectArray[n] == null && !this.colNullable[n]) {
                Trace.throwerror(10, "column: " + this.getColumn((int)n).columnName.name + " table: " + this.tableName.name);
            }
            ++n;
        }
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null && this.identityColumn < this.visibleColumnCount) {
                session.setLastIdentity(number);
            }
        }
    }

    protected void updateIdentityValue(Object[] objectArray) throws HsqlException {
        Number number;
        if (this.identityColumn != -1 && (number = (Number)objectArray[this.identityColumn]) != null) {
            this.identitySequence.getValue(number.longValue());
        }
    }

    void enforceFieldValueLimits(Object[] objectArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            int n = 0;
            while (n < this.visibleColumnCount) {
                if (this.colSizes[n] != 0 && objectArray[n] != null) {
                    objectArray[n] = Table.enforceSize(objectArray[n], this.colTypes[n], this.colSizes[n], true, this.sqlEnforceStrictSize);
                }
                ++n;
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            if (nArray == null) {
                this.enforceFieldValueLimits(objectArray);
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (this.colSizes[n2] != 0 && objectArray[n2] != null) {
                    objectArray[n2] = Table.enforceSize(objectArray[n2], this.colTypes[n2], this.colSizes[n2], true, this.sqlEnforceStrictSize);
                }
                ++n;
            }
        }
    }

    static Object enforceSize(Object object, int n, int n2, boolean bl, boolean bl2) throws HsqlException {
        if (n2 == 0) {
            return object;
        }
        switch (n) {
            case 1: {
                return Table.padOrTrunc((String)object, n2, bl, bl2);
            }
            case 12: {
                return Table.padOrTrunc((String)object, n2, false, bl2);
            }
        }
        return object;
    }

    static String padOrTrunc(String string, int n, boolean bl, boolean bl2) throws HsqlException {
        if (bl2 && StringUtil.rTrimSize(string) > n) {
            throw Trace.error(124);
        }
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (!bl) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, n2, cArray, 0);
        int n3 = n2;
        while (n3 < n) {
            cArray[n3] = 32;
            ++n3;
        }
        return new String(cArray);
    }

    void fireAll(Session session, int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.triggerLists[n];
        if (hsqlArrayList == null) {
            return;
        }
        int n2 = 0;
        int n3 = hsqlArrayList.size();
        while (n2 < n3) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n2);
            triggerDef.pushPair(session, objectArray, objectArray2);
            ++n2;
        }
    }

    void fireAll(Session session, int n) {
        if (this.triggerLists[n] != null) {
            this.fireAll(session, n, null, null);
        }
    }

    void addTrigger(TriggerDef triggerDef) {
        if (this.triggerLists[triggerDef.vectorIndex] == null) {
            this.triggerLists[triggerDef.vectorIndex] = new HsqlArrayList();
        }
        this.triggerLists[triggerDef.vectorIndex].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.triggerLists[n2];
            if (hsqlArrayList != null) {
                int n3 = hsqlArrayList.size() - 1;
                while (n3 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                    if (triggerDef.name.name.equals(string)) {
                        hsqlArrayList.remove(n3);
                        triggerDef.terminate();
                    }
                    --n3;
                }
                if (hsqlArrayList.isEmpty()) {
                    this.triggerLists[n2] = null;
                }
            }
            ++n2;
        }
    }

    void dropTriggers() {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.triggerLists[n2];
            if (hsqlArrayList != null) {
                int n3 = hsqlArrayList.size() - 1;
                while (n3 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                    triggerDef.terminate();
                    --n3;
                }
                this.triggerLists[n2] = null;
            }
            ++n2;
        }
    }

    static void checkCascadeDelete(Session session, Table table, HashMappedList hashMappedList, Row row, boolean bl, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = table.constraintList.length;
        while (n < n2) {
            Node node;
            Constraint constraint = table.constraintList[n];
            if (constraint.getType() == 1 && constraint.getRef() != null && (node = constraint.findFkRef(row.getData(), true)) != null) {
                boolean bl2;
                Table table2 = constraint.getRef();
                boolean bl3 = bl2 = table2.getNextConstraintIndex(0, 1) != -1;
                if (bl || bl2) {
                    Index index = constraint.getRefIndex();
                    int[] nArray = constraint.getMainColumns();
                    int[] nArray2 = constraint.getRefColumns();
                    Object[] objectArray = row.getData();
                    boolean bl4 = constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4;
                    HashMappedList hashMappedList2 = null;
                    if (bl4 && (hashMappedList2 = (HashMappedList)hashMappedList.get(table2)) == null) {
                        hashMappedList2 = new HashMappedList();
                        hashMappedList.add(table2, hashMappedList2);
                    }
                    Node node2 = node;
                    while (!node2.isDeleted() && index.compareRowNonUnique(objectArray, nArray, node2.getData()) == 0) {
                        node2 = node2.getUpdatedNode();
                        Node node3 = index.next(node2);
                        if (bl4) {
                            int n3;
                            Object[] objectArray2 = table2.getNewRow();
                            System.arraycopy(node2.getData(), 0, objectArray2, 0, objectArray2.length);
                            if (constraint.getDeleteAction() == 2) {
                                n3 = 0;
                                while (n3 < nArray2.length) {
                                    objectArray2[nArray2[n3]] = null;
                                    ++n3;
                                }
                            } else {
                                n3 = 0;
                                while (n3 < nArray2.length) {
                                    Column column = table2.getColumn(nArray2[n3]);
                                    objectArray2[nArray2[n3]] = column.getDefaultValue(session);
                                    ++n3;
                                }
                            }
                            if (bl2 && hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table2, null, node2.getRow(), objectArray2, nArray2, null, hashSet);
                                hashSet.remove(constraint);
                                node2 = node2.getUpdatedNode();
                                Node node4 = node3 = node3 == null ? null : node3.getUpdatedNode();
                            }
                            if (bl && (table2 != table || node2.getRow() != row.getUpdatedRow())) {
                                Table.mergeUpdate(hashMappedList2, node2.getRow(), objectArray2, nArray2);
                            }
                        } else if (bl2) {
                            if (table2 != table) {
                                if (hashSet.add(constraint)) {
                                    Table.checkCascadeDelete(session, table2, hashMappedList, node2.getRow(), bl, hashSet);
                                    hashSet.remove(constraint);
                                    node2 = node2.getUpdatedNode();
                                    node3 = node3 == null ? null : node3.getUpdatedNode();
                                }
                            } else {
                                Row row2 = row = row == null ? null : row.getUpdatedRow();
                                if (node2.getRow() != row) {
                                    Table.checkCascadeDelete(session, table2, hashMappedList, node2.getRow(), bl, hashSet);
                                    node2 = node2.getUpdatedNode();
                                    Node node5 = node3 = node3 == null ? null : node3.getUpdatedNode();
                                }
                            }
                        }
                        if (bl && !bl4 && !node2.isDeleted()) {
                            table2.deleteNoRefCheck(session, node2.getRow());
                        }
                        if (node3 == null) break;
                        node2 = node3;
                    }
                }
            }
            ++n;
        }
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray, Table table2, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = table.constraintList.length;
        while (n < n2) {
            Object object;
            Constraint constraint = table.constraintList[n];
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if ((table2 == null || constraint.getMain() != table2) && ArrayUtil.countCommonElements(nArray, constraint.getRefColumns()) != 0) {
                    object = constraint.findMainRef(objectArray);
                }
            } else if (constraint.getType() == 1 && constraint.getRef() != null && (object = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) != null) {
                Node node;
                int[] nArray2 = constraint.getMainColumns();
                int[] nArray3 = constraint.getRefColumns();
                boolean bl = true;
                int n3 = 0;
                while (n3 < nArray2.length) {
                    if (!row.getData()[nArray2[n3]].equals(objectArray[nArray2[n3]])) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (!bl && (node = constraint.findFkRef(row.getData(), false)) != null) {
                    Table table3 = constraint.getRef();
                    boolean bl2 = table3.getNextConstraintIndex(0, 1) != -1;
                    Index index = constraint.getRefIndex();
                    HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(table3);
                    if (hashMappedList2 == null) {
                        hashMappedList2 = new HashMappedList();
                        hashMappedList.add(table3, hashMappedList2);
                    }
                    Node node2 = node;
                    while (index.compareRowNonUnique(row.getData(), nArray2, node2.getData()) == 0) {
                        int n4;
                        node2 = node2.getUpdatedNode();
                        Node node3 = index.next(node2);
                        Object[] objectArray2 = table3.getNewRow();
                        System.arraycopy(node2.getData(), 0, objectArray2, 0, objectArray2.length);
                        if (constraint.getUpdateAction() == 2) {
                            n4 = 0;
                            while (n4 < nArray3.length) {
                                objectArray2[nArray3[n4]] = null;
                                ++n4;
                            }
                        } else if (constraint.getUpdateAction() == 4) {
                            n4 = 0;
                            while (n4 < nArray3.length) {
                                Column column = table3.getColumn(nArray3[n4]);
                                objectArray2[nArray3[n4]] = column.getDefaultValue(session);
                                ++n4;
                            }
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table3, hashMappedList, node2.getRow(), objectArray2, nArray3, null, hashSet);
                                hashSet.remove(constraint);
                            }
                        } else {
                            n4 = 0;
                            while (n4 < nArray2.length) {
                                objectArray2[nArray3[n4]] = objectArray[nArray2[n4]];
                                ++n4;
                            }
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table3, hashMappedList, node2.getRow(), objectArray2, object, table, hashSet);
                                hashSet.remove(constraint);
                            }
                        }
                        Table.mergeUpdate(hashMappedList2, node2.getRow(), objectArray2, nArray3);
                        if (node3 == null) break;
                        node2 = node3;
                    }
                }
            }
            ++n;
        }
    }

    static void mergeUpdate(HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            int n = 0;
            while (n < nArray.length) {
                objectArray2[nArray[n]] = objectArray[nArray[n]];
                ++n;
            }
        } else {
            hashMappedList.add(row, objectArray);
        }
    }

    static boolean mergeKeepUpdate(HashMappedList hashMappedList, int[] nArray, Row row, Object[] objectArray) throws HsqlException {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            if (Index.compareRows(row.getData(), objectArray, nArray) != 0 && Index.compareRows(objectArray, objectArray2, nArray) != 0) {
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                objectArray[nArray[n]] = objectArray2[nArray[n]];
                ++n;
            }
            hashMappedList.put(row, objectArray);
        } else {
            hashMappedList.add(row, objectArray);
        }
        return true;
    }

    static void clearUpdateLists(HashMappedList hashMappedList) {
        int n = 0;
        while (n < hashMappedList.size()) {
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n);
            hashMappedList2.clear();
            ++n;
        }
    }

    int delete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        Row row;
        int n;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        if (this.database.isReferentialIntegrity()) {
            n = 0;
            while (n < hsqlArrayList.size()) {
                row = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, row, false, hashSet);
                ++n;
            }
        }
        this.fireAll(session, 4);
        if (this.database.isReferentialIntegrity()) {
            n = 0;
            while (n < hsqlArrayList.size()) {
                row = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, row, true, hashSet);
                ++n;
            }
        }
        n = 0;
        while (n < hsqlArrayList.size()) {
            row = (Row)hsqlArrayList.get(n);
            if (!row.isDeleted()) {
                this.deleteNoRefCheck(session, row);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < hashMappedList.size()) {
            Table table = (Table)hashMappedList.getKey(n2);
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n2);
            table.updateRowSet(session, hashMappedList2, null, false);
            hashMappedList2.clear();
            ++n2;
        }
        this.fireAll(session, 1);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList;
        return hsqlArrayList.size();
    }

    private void deleteNoRefCheck(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(session, 10, objectArray, null);
        this.deleteNoCheck(session, row, true);
        this.fireAll(session, 7, objectArray, null);
    }

    private void deleteNoCheck(Session session, Row row, boolean bl) throws HsqlException {
        if (row.isDeleted()) {
            return;
        }
        Object[] objectArray = row.getData();
        row = row.getUpdatedRow();
        int n = this.getIndexCount() - 1;
        while (n >= 0) {
            Node node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, row);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    void deleteNoCheckRollback(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        Node node = this.getIndex(0).search(objectArray);
        Row row = node.getRow();
        int n = this.getIndexCount() - 1;
        while (n >= 0) {
            node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row.delete();
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    int update(Session session, HashMappedList hashMappedList, int[] nArray) throws HsqlException {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList2 = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        int n = 0;
        while (n < hashMappedList.size()) {
            objectArray2 = (Object[])hashMappedList.get(n);
            this.setIdentityColumn(session, objectArray2);
            this.enforceFieldValueLimits(objectArray2, nArray);
            this.enforceNullConstraints(objectArray2);
            ++n;
        }
        if (this.database.isReferentialIntegrity()) {
            int n2 = 0;
            while (n2 < hashMappedList.size()) {
                Object[] objectArray3 = (Object[])hashMappedList.get(n2);
                object = (Row)hashMappedList.getKey(n2);
                Table.checkCascadeUpdate(session, this, hashMappedList2, (Row)object, objectArray3, nArray, null, hashSet);
                ++n2;
            }
        }
        this.fireAll(session, 5);
        objectArray2 = (HashMappedList)hashMappedList2.get(this);
        if (objectArray2 != null) {
            int n3 = 0;
            while (n3 < objectArray2.size()) {
                object = (Row)objectArray2.getKey(n3);
                objectArray = (Object[])objectArray2.get(n3);
                Table.mergeKeepUpdate(hashMappedList, nArray, (Row)object, objectArray);
                ++n3;
            }
            objectArray2.clear();
        }
        int n4 = 0;
        while (n4 < hashMappedList2.size()) {
            object = (Table)hashMappedList2.getKey(n4);
            objectArray = (HashMappedList)hashMappedList2.get(n4);
            ((Table)object).updateRowSet(session, (HashMappedList)objectArray, null, false);
            objectArray.clear();
            ++n4;
        }
        this.updateRowSet(session, hashMappedList, nArray, true);
        this.fireAll(session, 2);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList2;
        Table.clearUpdateLists(this.tableUpdateList);
        return hashMappedList.size();
    }

    void updateRowSet(Session session, HashMappedList hashMappedList, int[] nArray, boolean bl) throws HsqlException {
        Object object;
        int n = hashMappedList.size() - 1;
        while (n >= 0) {
            Row row = (Row)hashMappedList.getKey(n);
            object = (Object[])hashMappedList.get(n);
            if (row.isDeleted()) {
                if (bl) {
                    throw Trace.error(199);
                }
                hashMappedList.remove(n);
            } else {
                int n2 = 0;
                while (n2 < this.constraintList.length) {
                    Constraint constraint = this.constraintList[n2];
                    if (constraint.getType() == 3) {
                        constraint.checkCheckConstraint(session, (Object[])object);
                    }
                    ++n2;
                }
                this.deleteNoCheck(session, row, true);
            }
            --n;
        }
        int n3 = 0;
        while (n3 < hashMappedList.size()) {
            object = (Row)hashMappedList.getKey(n3);
            Object[] objectArray = (Object[])hashMappedList.get(n3);
            if (this.triggerLists[11] != null) {
                this.fireAll(session, 11, ((Row)object).getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            this.insertNoCheck(session, objectArray);
            if (this.triggerLists[8] != null) {
                this.fireAll(session, 8, ((Row)object).getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            ++n3;
        }
    }

    void checkRowDataInsert(Session session, Object[] objectArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray);
        this.enforceNullConstraints(objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = 0;
            int n2 = this.constraintList.length;
            while (n < n2) {
                this.constraintList[n].checkInsert(session, objectArray);
                ++n;
            }
        }
    }

    void checkRowDataUpdate(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, nArray);
        this.enforceNullConstraints(objectArray);
        int n = 0;
        while (n < this.constraintList.length) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getType() == 3) {
                constraint.checkCheckConstraint(session, objectArray);
            }
            ++n;
        }
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.getIndexCount()) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName().name)) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            if (this.constraintList[n].getName().name.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    Column getColumn(int n) {
        return (Column)this.columnList.get(n);
    }

    void renameColumn(Column column, String string, boolean bl) throws HsqlException {
        String string2 = column.columnName.name;
        int n = this.getColumnNr(string2);
        this.columnList.setKey(n, string);
        column.columnName.rename(string, bl);
        this.renameColumnInCheckConstraints(string2, string, bl);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return this.indexList[n];
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isCached) {
            return this.cache.getRow(n, this);
        }
        return null;
    }

    void addRowToStore(Row row) throws HsqlException {
        if (this.isCached && this.cache != null) {
            this.cache.add((CachedRow)row);
        } else if (this.needsRowID) {
            row.getData()[this.visibleColumnCount] = ValuePool.getInt((int)this.rowIdSequence.getValue());
        }
    }

    void registerRow(CachedRow cachedRow) {
        if (this.needsRowID) {
            cachedRow.getData()[this.visibleColumnCount] = new Integer(cachedRow.iPos);
        }
    }

    void removeRow(CachedRow cachedRow) throws HsqlException {
        if (this.cache != null) {
            this.cache.free(cachedRow);
        }
    }

    /*
     * Unable to fully structure code
     */
    void indexRow(Row var1_1) throws HsqlException {
        block5: {
            var2_2 = 0;
            try {
                var3_3 = null;
                while (var2_2 < this.getIndexCount()) {
                    var3_3 = var1_1.getNextNode(var3_3);
                    this.getIndex(var2_2).insert(var3_3);
                    ++var2_2;
                }
                break block5;
            }
            catch (HsqlException var3_4) {
                var4_5 = this.getIndex(var2_2);
                var5_6 = var4_5.isConstraint;
                --var2_2;
                ** while (var2_2 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                var6_7 = var1_1.getNode(var2_2);
                this.getIndex(var2_2).delete((Node)var6_7);
                --var2_2;
                continue;
            }
lbl19:
            // 1 sources

            var1_1.delete();
            if (var5_6) {
                var6_7 = this.getConstraintForIndex(var4_5);
                var7_8 = var6_7 == null ? "" : var6_7.getName().name;
                throw Trace.error(104, var7_8);
            }
            throw var3_4;
        }
    }

    void clearAllRows() {
        int n = 0;
        while (n < this.getIndexCount()) {
            this.getIndex(n).clearAll();
            ++n;
        }
        this.identitySequence.reset();
        this.rowIdSequence.reset();
    }

    void drop() throws HsqlException {
        if (this.cache != null && !this.isEmpty()) {
            this.cache.remove(this);
        }
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs") ? this.database.getURI() : null;
    }

    String getSchemaName() {
        if (!this.database.getProperties().isPropertyTrue("hsqldb.schemas")) {
            return null;
        }
        switch (this.tableType) {
            case 0: {
                return "DEFINITION_SCHEMA";
            }
            case 8: {
                return "INFORMATION_SCHEMA";
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return "PUBLIC";
            }
            case 2: 
            case 5: {
                Session session = this.database.sessionManager.getSession(this.ownerSessionId);
                if (session == null) {
                    return null;
                }
                if (session.getId() == this.ownerSessionId) {
                    return session.getUsername();
                }
                return null;
            }
        }
        return null;
    }

    public int getRowCount() throws HsqlException {
        return this.getPrimaryIndex().size();
    }
}

