/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Date;
import org.hsqldb.lib.HsqlArrayHeap;
import org.hsqldb.lib.HsqlThreadFactory;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.ThreadFactory;

public class HsqlTimer
implements ObjectComparator {
    protected final TaskQueue taskQueue = new TaskQueue(16, this);
    protected final TaskRunner taskRunner = new TaskRunner();
    protected Thread taskRunnerThread;
    protected ThreadFactory threadFactory;

    public HsqlTimer() {
        this(null);
    }

    public HsqlTimer(ThreadFactory threadFactory) {
        this.threadFactory = new HsqlThreadFactory(threadFactory);
    }

    public int compare(Object object, Object object2) {
        long l = ((Task)object).getNextScheduled();
        long l2 = ((Task)object2).getNextScheduled();
        return (int)(l - l2);
    }

    public synchronized Thread getThread() {
        return this.taskRunnerThread;
    }

    public synchronized void restart() {
        if (this.taskRunnerThread == null) {
            this.taskRunnerThread = this.threadFactory.newThread(this.taskRunner);
            this.taskRunnerThread.setName("HSQLDB Timer @" + Integer.toHexString(this.hashCode()));
            this.taskRunnerThread.setDaemon(true);
            this.taskRunnerThread.start();
        } else {
            this.notify();
        }
    }

    public Object scheduleAfter(long l, Runnable runnable) {
        return this.addTask(HsqlTimer.now() + l, runnable, 0L, false);
    }

    public Object scheduleAt(Date date, Runnable runnable) {
        return this.addTask(date.getTime(), runnable, -1L, false);
    }

    public Object schedulePeriodicallyAt(Date date, long l, Runnable runnable, boolean bl) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        return this.addTask(date.getTime(), runnable, l, bl);
    }

    public Object schedulePeriodicallyAfter(long l, long l2, Runnable runnable, boolean bl) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        return this.addTask(HsqlTimer.now() + l, runnable, l2, bl);
    }

    public synchronized void shutDown() {
        this.taskQueue.clear();
        if (this.taskRunnerThread != null) {
            this.taskRunnerThread.interrupt();
        }
        this.taskRunnerThread = null;
    }

    public static void cancel(Object object) throws ClassCastException {
        if (object != null) {
            ((Task)object).cancel();
        }
    }

    public static boolean isCancelled(Object object) throws ClassCastException {
        return object == null ? true : ((Task)object).isCancelled();
    }

    public static boolean isFixedRate(Object object) throws ClassCastException {
        return object == null ? false : ((Task)object).relative && ((Task)object).period > 0L;
    }

    public static boolean isFixedDelay(Object object) throws ClassCastException {
        return object == null ? false : !((Task)object).relative && ((Task)object).period > 0L;
    }

    public static boolean isPeriodic(Object object) throws ClassCastException {
        return object == null ? false : ((Task)object).period != 0L;
    }

    public static Date getLastScheduled(Object object) throws ClassCastException {
        long l = object == null ? 0L : ((Task)object).getLastScheduled();
        return l == 0L ? null : new Date(l);
    }

    public static Date getNextScheduled(Object object) throws ClassCastException {
        return HsqlTimer.isCancelled(object) ? null : new Date(((Task)object).getNextScheduled());
    }

    protected Task addTask(long l, Runnable runnable, long l2, boolean bl) {
        Task task = new Task(l, runnable, l2, bl);
        this.taskQueue.add(task);
        this.restart();
        return task;
    }

    protected synchronized void clearThread() {
        this.taskRunnerThread = null;
    }

    protected synchronized Task nextTask() {
        try {
            while (!Thread.interrupted()) {
                Task task = (Task)this.taskQueue.peek();
                if (task == null) {
                    this.wait();
                    continue;
                }
                long l = HsqlTimer.now();
                long l2 = task.getNextScheduled();
                if (l2 > l) {
                    this.wait(l2 - l);
                    continue;
                }
                task = (Task)this.taskQueue.remove();
                if (task == null || task.isCancelled()) continue;
                long l3 = task.period;
                if (l3 > 0L) {
                    long l4;
                    l = HsqlTimer.now();
                    if (task.relative && (l4 = l - l2) > 0L) {
                        l3 -= l4;
                    }
                    l2 = l + l3;
                    task.setNextScheduled(l2);
                    this.taskQueue.add(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    protected class TaskQueue
    extends HsqlArrayHeap {
        TaskQueue(int n, ObjectComparator objectComparator) {
            super(n, objectComparator);
        }

        public synchronized void clear() {
            int n = 0;
            while (n < this.count) {
                ((Task)this.heap[n]).cancel();
                this.heap[n] = null;
                ++n;
            }
            this.count = 0;
        }
    }

    protected class Task {
        final Runnable runnable;
        final long period;
        private long last = 0L;
        private long next;
        private boolean cancelled = false;
        private Object cancel_mutex = new Object();
        final boolean relative;

        Task(long l, Runnable runnable, long l2, boolean bl) {
            this.next = l;
            this.runnable = runnable;
            this.period = l2;
            this.relative = bl;
        }

        void cancel() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                this.cancelled = true;
            }
        }

        boolean isCancelled() {
            Object object = this.cancel_mutex;
            synchronized (object) {
                boolean bl = this.cancelled;
                return bl;
            }
        }

        synchronized long getLastScheduled() {
            return this.last;
        }

        synchronized void setLastScheduled(long l) {
            this.last = l;
        }

        synchronized long getNextScheduled() {
            return this.next;
        }

        synchronized void setNextScheduled(long l) {
            this.next = l;
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        public void run() {
            try {
                Task task;
                while ((task = HsqlTimer.this.nextTask()) != null) {
                    task.setLastScheduled(HsqlTimer.now());
                    task.runnable.run();
                }
                Object var3_2 = null;
                HsqlTimer.this.clearThread();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                HsqlTimer.this.clearThread();
                throw throwable;
            }
        }
    }
}

