/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;

public class StringConverter {
    private static final byte[] HEXBYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    byte[] stringToFullByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            byArray[n2 * 2] = (byte)((c & 0xFF00) >> 8);
            byArray[n2 * 2 + 1] = (byte)(c & 0xFF);
            ++n2;
        }
        return byArray;
    }

    public static byte[] hexToByte(String string) throws IOException {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        if (string.length() % 2 != 0) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        int n3 = 0;
        while (n3 < n) {
            char c;
            int n4;
            if ((n4 = HEXINDEX.indexOf(c = string.charAt(n2++))) == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            int n5 = (n4 & 0xF) << 4;
            c = string.charAt(n2++);
            n4 = HEXINDEX.indexOf(c);
            byArray[n3] = (byte)(n5 += n4 & 0xF);
            ++n3;
        }
        return byArray;
    }

    public static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = byArray[n2] & 0xFF;
            cArray[n3++] = (char)HEXBYTES[n4 >> 4 & 0xF];
            cArray[n3++] = (char)HEXBYTES[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public static void writeHex(byte[] byArray, int n, byte[] byArray2) throws IOException {
        int n2 = byArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray2[n3] & 0xFF;
            byArray[n++] = HEXBYTES[n4 >> 4 & 0xF];
            byArray[n++] = HEXBYTES[n4 & 0xF];
            ++n3;
        }
    }

    public static String byteToString(byte[] byArray, String string) {
        try {
            return string == null ? new String(byArray) : new String(byArray, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String unicodeToHexString(String string) {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        try {
            StringConverter.writeUTF(string, hsqlByteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.byteToHex(hsqlByteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) throws IOException {
        byte[] byArray = StringConverter.hexToByte(string);
        return StringConverter.readUTF(byArray, 0, byArray.length);
    }

    public static int unicodeToAscii(OutputStream outputStream, String string, boolean bl) throws IOException {
        int n = 0;
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\\') {
                if (n3 < n2 - 1 && string.charAt(n3 + 1) == 'u') {
                    outputStream.write(c);
                    outputStream.write(117);
                    outputStream.write(48);
                    outputStream.write(48);
                    outputStream.write(53);
                    outputStream.write(99);
                    n += 6;
                } else {
                    outputStream.write(c);
                    ++n;
                }
            } else if (c >= ' ' && c <= '\u007f') {
                outputStream.write(c);
                ++n;
                if (c == '\'' && bl) {
                    outputStream.write(c);
                    ++n;
                }
            } else {
                outputStream.write(92);
                outputStream.write(117);
                outputStream.write(HEXBYTES[c >> 12 & 0xF]);
                outputStream.write(HEXBYTES[c >> 8 & 0xF]);
                outputStream.write(HEXBYTES[c >> 4 & 0xF]);
                outputStream.write(HEXBYTES[c & 0xF]);
                n += 6;
            }
            ++n3;
        }
        return n;
    }

    public static String asciiToUnicode(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byte by = byArray[n + n4];
            if (by == 92 && n4 < n2 - 5) {
                byte by2 = byArray[n + n4 + 1];
                if (by2 == 117) {
                    ++n4;
                    int n5 = HEXINDEX.indexOf(byArray[n + ++n4]) << 12;
                    n5 += HEXINDEX.indexOf(byArray[n + ++n4]) << 8;
                    n5 += HEXINDEX.indexOf(byArray[n + ++n4]) << 4;
                    cArray[n3++] = (char)(n5 += HEXINDEX.indexOf(byArray[n + ++n4]));
                } else {
                    cArray[n3++] = (char)by;
                }
            } else {
                cArray[n3++] = (char)by;
            }
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '\\' && n3 < n - 5) {
                char c2 = string.charAt(n3 + 1);
                if (c2 == 'u') {
                    ++n3;
                    int n4 = HEXINDEX.indexOf(string.charAt(++n3)) << 12;
                    n4 += HEXINDEX.indexOf(string.charAt(++n3)) << 8;
                    n4 += HEXINDEX.indexOf(string.charAt(++n3)) << 4;
                    cArray[n2++] = (char)(n4 += HEXINDEX.indexOf(string.charAt(++n3)));
                } else {
                    cArray[n2++] = c;
                }
            } else {
                cArray[n2++] = c;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String readUTF(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = byArray[n + n4];
            if (n3 > cArray.length - 4) {
                cArray = (char[])ArrayUtil.resizeArray(cArray, cArray.length + n2);
            }
            if (n5 > 0) {
                ++n4;
                cArray[n3++] = (char)n5;
                continue;
            }
            switch ((n5 &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((n4 += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n4 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                case 14: {
                    if ((n4 += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n4 - 2];
                    byte by2 = byArray[n + n4 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public static int writeUTF(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
                ++n2;
            } else if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                n2 += 3;
            } else {
                outputStream.write(0xC0 | c >> 6 & 0x1F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                n2 += 2;
            }
            ++n3;
        }
        return n2;
    }

    public static int getUTFSize(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }

    public static String inputStreamToString(InputStream inputStream, int n) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n2 = 8192;
        char[] cArray = new char[n2];
        int n3 = n;
        while (n3 > 0) {
            int n4 = inputStreamReader.read(cArray, 0, n3 > n2 ? n2 : n3);
            if (n4 == -1) break;
            stringWriter.write(cArray, 0, n4);
            n3 -= n4;
        }
        stringWriter.close();
        return stringWriter.toString();
    }

    public static String toQuotedString(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = bl ? StringConverter.count(string, c) : 0;
        int n2 = string.length();
        char[] cArray = new char[2 + n + n2];
        int n3 = 0;
        int n4 = 0;
        cArray[n4++] = c;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            cArray[n4++] = c2;
            if (bl && c2 == c) {
                cArray[n4++] = c2;
            }
            ++n3;
        }
        cArray[n4] = c;
        return new String(cArray);
    }

    static int count(String string, char c) {
        int n = 0;
        int n2 = 0;
        if (string != null) {
            while ((n = string.indexOf(c, n)) > -1) {
                ++n2;
                ++n;
            }
        }
        return n2;
    }
}

