/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;

public class Binary {
    private byte[] data;
    int hash;

    public Binary(byte[] byArray, boolean bl) {
        if (bl) {
            byArray = (byte[])ArrayUtil.duplicateArray(byArray);
        }
        this.data = byArray;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public byte[] getClonedBytes() {
        return (byte[])this.data.clone();
    }

    public int getBytesLength() {
        return this.data.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Binary)) {
            return false;
        }
        if (this.data.length != ((Binary)object).data.length) {
            return false;
        }
        return ArrayUtil.containsAt(this.data, 0, ((Binary)object).data);
    }

    public int hashCode() {
        int n = 0;
        if (this.hash == 0) {
            int n2 = 0;
            while (n2 < this.data.length) {
                n = 31 * n + this.data[n2];
                ++n2;
            }
            this.hash = n;
        }
        return this.hash;
    }

    public String toString() {
        return StringConverter.byteToHex(this.data);
    }
}

