/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.ExcaliburComponentSelector;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.language.programming.Program;

public class GeneratorSelector
extends ExcaliburComponentSelector
implements Disposable {
    public static final String ROLE = "org.apache.cocoon.components.language.generator.ServerPages";
    private ClassLoaderManager classManager;
    protected ComponentManager manager;
    private LogkitLoggerManager logKitManager;
    protected Context context;
    protected RoleManager roles;
    protected Map componentHandlers = new HashMap();
    private Map componentMapping = new HashMap();

    public void contextualize(Context context) {
        super.contextualize(context);
        this.context = context;
    }

    public void setRoleManager(RoleManager roleMgr) {
        super.setRoleManager(roleMgr);
        this.roles = roleMgr;
    }

    public void setLogKitManager(LogKitManager logkit) {
        super.setLogKitManager(logkit);
        if (null == this.logKitManager) {
            this.logKitManager = new LogkitLoggerManager(null, logkit);
        }
    }

    public void setLoggerManager(LoggerManager logkit) {
        super.setLoggerManager(logkit);
        if (null == this.logKitManager) {
            this.logKitManager = new LogkitLoggerManager(logkit, null);
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.manager = manager;
        try {
            this.classManager = (ClassLoaderManager)manager.lookup(ClassLoaderManager.ROLE);
        }
        catch (ComponentException cme) {
            throw new ComponentException(ClassLoaderManager.ROLE, "GeneratorSelector", (Throwable)cme);
        }
        try {
            this.classManager.addDirectory((File)this.m_context.get((Object)"work-directory"));
        }
        catch (Exception e) {
            throw new ComponentException(ROLE, "Could not add repository to ClassLoaderManager", (Throwable)e);
        }
    }

    public Component select(Object hint) throws ComponentException {
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(hint);
        if (handler == null) {
            throw new ComponentException(ROLE, "Could not find component for hint: " + hint);
        }
        try {
            Component component = handler.get();
            this.componentMapping.put(component, handler);
            return component;
        }
        catch (Exception ce) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not access component for hint: " + hint, (Throwable)ce);
            }
            throw new ComponentException(ROLE, "Could not access component for hint: " + hint, (Throwable)ce);
        }
    }

    public void release(Component component) {
        ComponentHandler handler = (ComponentHandler)this.componentMapping.remove(component);
        if (handler != null) {
            try {
                handler.put(component);
            }
            catch (Exception e) {
                this.getLogger().error("Error trying to release component", (Throwable)e);
            }
        }
    }

    public void addGenerator(ComponentManager newManager, Object hint, Program generator) throws Exception {
        try {
            ComponentHandler handler = generator.getHandler(newManager, this.context, this.roles, this.logKitManager);
            handler.enableLogging(this.getLogger());
            handler.initialize();
            this.componentHandlers.put(hint, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding " + generator.getName() + " for " + hint);
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not set up Component for hint: " + hint, (Throwable)e);
            }
            throw e;
        }
    }

    public void removeGenerator(Object hint) {
        ComponentHandler handler = (ComponentHandler)this.componentHandlers.remove(hint);
        if (handler != null) {
            handler.dispose();
            this.classManager.reinstantiate();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Removing " + handler.getClass().getName() + " for " + hint.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.manager.release((Component)this.classManager);
        GeneratorSelector generatorSelector = this;
        synchronized (generatorSelector) {
            Iterator<Object> keys = this.componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                ComponentHandler handler = (ComponentHandler)this.componentHandlers.get(key);
                handler.dispose();
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.componentHandlers.remove(keys.next());
            }
            keyList.clear();
        }
        super.dispose();
    }
}

