/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Logicsheet
extends AbstractLogEnabled {
    private SourceResolver resolver;
    private String systemId;
    protected Map namespaceURIs = new HashMap();
    private ServiceManager manager;

    public Logicsheet(Source source, ServiceManager manager, SourceResolver resolver) throws SAXException, IOException, ProcessingException {
        this.resolver = resolver;
        this.systemId = source.getURI();
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logicsheet(String systemId, ServiceManager manager, SourceResolver resolver) throws SAXException, IOException, SourceException, ProcessingException {
        this.resolver = resolver;
        this.manager = manager;
        Source source = null;
        try {
            source = this.resolver.resolveURI(systemId);
            this.systemId = source.getURI();
        }
        finally {
            this.resolver.release(source);
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Map getNamespaceURIs() throws ProcessingException {
        this.getTransformerHandler();
        return this.namespaceURIs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransformerHandler getTransformerHandler() throws ProcessingException {
        TransformerHandler transformerHandler;
        XSLTProcessor xsltProcessor = null;
        Source source = null;
        try {
            try {
                xsltProcessor = (XSLTProcessor)this.manager.lookup(XSLTProcessor.ROLE);
                source = this.resolver.resolveURI(this.systemId);
                SaveNamespaceFilter saveNSFilter = new SaveNamespaceFilter(this.namespaceURIs);
                transformerHandler = xsltProcessor.getTransformerHandler(source, (XMLFilter)saveNSFilter);
                Object var6_10 = null;
            }
            catch (ServiceException e) {
                throw new ProcessingException("Could not obtain XSLT processor", (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ProcessingException("Could not resolve " + this.systemId, (Throwable)e);
            }
            catch (SourceException e) {
                throw SourceUtil.handle((String)("Could not resolve " + this.systemId), (SourceException)e);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not resolve " + this.systemId, (Throwable)e);
            }
            catch (XSLTProcessorException e) {
                throw new ProcessingException("Could not transform " + this.systemId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.manager.release((Object)xsltProcessor);
            this.resolver.release(source);
            throw throwable;
        }
        this.manager.release((Object)xsltProcessor);
        this.resolver.release(source);
        return transformerHandler;
    }

    protected static class SaveNamespaceFilter
    extends XMLFilterImpl {
        private Map originalNamepaceURIs;

        public SaveNamespaceFilter(Map originalNamepaceURIs) {
            this.originalNamepaceURIs = originalNamepaceURIs;
        }

        public void setParent(XMLReader reader) {
            super.setParent(reader);
            reader.setContentHandler(this);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.originalNamepaceURIs.put(uri, prefix);
            super.startPrefixMapping(prefix, uri);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
        }
    }
}

