/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.javascript;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.markup.xsp.XSLTExtension;
import org.apache.cocoon.components.language.programming.AbstractProgrammingLanguage;
import org.apache.cocoon.components.language.programming.Program;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.components.language.programming.javascript.JavascriptProgram;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.IOUtils;

public class JavascriptLanguage
extends AbstractProgrammingLanguage
implements ProgrammingLanguage {
    public Program preload(String filename, File baseDirectory, String encoding) throws LanguageException {
        return this.load(filename, baseDirectory, encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Program load(String filename, File baseDirectory, String encoding) throws LanguageException {
        File sourceFile = new File(baseDirectory, filename + "." + this.getSourceExtension());
        if (!sourceFile.exists()) {
            throw new LanguageException("Can't load program - File doesn't exist: " + IOUtils.getFullFilename((File)sourceFile));
        }
        if (!sourceFile.isFile()) {
            throw new LanguageException("Can't load program - File is not a normal file: " + IOUtils.getFullFilename((File)sourceFile));
        }
        if (!sourceFile.canRead()) {
            throw new LanguageException("Can't load program - File cannot be read: " + IOUtils.getFullFilename((File)sourceFile));
        }
        Class clazz = null;
        ArrayList<String> dependecies = new ArrayList<String>();
        String className = null;
        BufferedReader r = null;
        try {
            try {
                String line;
                r = new BufferedReader(new FileReader(sourceFile));
                className = this.getMeta(r.readLine(), "extends");
                if (className == null) {
                    throw new LanguageException("Can't load program - Signature is not found: " + IOUtils.getFullFilename((File)sourceFile));
                }
                clazz = ClassUtils.loadClass((String)className);
                while ((line = this.getMeta(r.readLine(), "depends")) != null) {
                    dependecies.add(line);
                }
                Object var11_12 = null;
                if (r == null) return new JavascriptProgram(sourceFile, clazz, dependecies);
            }
            catch (IOException e) {
                throw new LanguageException("Can't load program - Signature is not found: " + IOUtils.getFullFilename((File)sourceFile));
            }
            catch (ClassNotFoundException e) {
                throw new LanguageException("Can't load program - Base class " + className + " is not found: " + IOUtils.getFullFilename((File)sourceFile));
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        r.close();
        return new JavascriptProgram(sourceFile, clazz, dependecies);
    }

    private String getMeta(String line, String meta) {
        int j;
        if (line == null) {
            return null;
        }
        meta = "$Cocoon " + meta + ": ";
        int i = line.indexOf(meta);
        line = i != -1 ? ((j = line.indexOf("$", i + 1)) != -1 ? line.substring(i + meta.length(), j) : null) : null;
        return line;
    }

    protected void doUnload(Object program, String filename, File baseDir) throws LanguageException {
    }

    public String quoteString(String constant) {
        return XSLTExtension.escapeJavaString(constant);
    }

    public String getSourceExtension() {
        return "js";
    }
}

