/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerEvent;

public final class PBStateEvent
extends PersistenceBrokerEvent {
    public static final int KEY_BEFORE_CLOSE = 1;
    public static final int KEY_BEFORE_BEGIN = 2;
    public static final int KEY_BEFORE_COMMIT = 3;
    public static final int KEY_BEFORE_ROLLBACK = 4;
    public static final int KEY_AFTER_BEGIN = 5;
    public static final int KEY_AFTER_COMMIT = 6;
    public static final int KEY_AFTER_OPEN = 7;
    public static final int KEY_AFTER_ROLLBACK = 8;
    private Type eventType;

    public PBStateEvent(PersistenceBroker persistenceBroker, Type type) {
        super(persistenceBroker);
        this.eventType = type;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("type", (Object)this.eventType.toString()).append("source object", this.getSource());
        return toStringBuilder.toString();
    }

    public Type getEventType() {
        return this.eventType;
    }

    public static class Type {
        public static final Type BEFORE_BEGIN = new Type(2);
        public static final Type AFTER_BEGIN = new Type(5);
        public static final Type BEFORE_COMMIT = new Type(3);
        public static final Type AFTER_COMMIT = new Type(6);
        public static final Type BEFORE_ROLLBACK = new Type(4);
        public static final Type AFTER_ROLLBACK = new Type(8);
        public static final Type AFTER_OPEN = new Type(7);
        public static final Type BEFORE_CLOSE = new Type(1);
        private int type;

        protected Type(int n) {
            this.type = n;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PBStateEvent)) {
                return false;
            }
            return this.type == ((Type)object).type;
        }

        public final int hashCode() {
            return this.type;
        }

        public final int typeId() {
            return this.type;
        }

        public String toString() {
            return this.getClass().getName() + " [type= " + this.typeAsName(this.type) + "]";
        }

        private String typeAsName(int n) {
            if (n == 5) {
                return "AFTER_BEGIN";
            }
            if (n == 6) {
                return "AFTER_COMMIT";
            }
            if (n == 7) {
                return "AFTER_OPEN";
            }
            if (n == 8) {
                return "AFTER_ROLLBACK";
            }
            if (n == 2) {
                return "BEFORE_BEGIN";
            }
            if (n == 1) {
                return "BEFORE_CLOSE";
            }
            if (n == 3) {
                return "BEFORE_COMMIT";
            }
            if (n == 4) {
                return "BEFORE_ROLLBACK";
            }
            throw new OJBRuntimeException("Could not find type " + n);
        }
    }
}

